/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.integration.jei.category.FluidPackageContentsCategory;
import thelm.packagedauto.integration.jei.category.FluidPackageFillingCategory;
import thelm.packagedauto.volume.FluidVolumeType;

public class FluidPackageManagerPlugin
implements IRecipeManagerPlugin {
    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        IVolumePackageItem vPackage;
        ItemStack stack;
        Item item;
        Object ingredient = focus.getTypedValue().getIngredient();
        if (ingredient instanceof ItemStack && (item = (stack = (ItemStack)ingredient).m_41720_()) instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) == FluidVolumeType.INSTANCE) {
            switch (focus.getRole()) {
                case INPUT: {
                    return List.of(FluidPackageContentsCategory.TYPE);
                }
                case OUTPUT: {
                    return List.of(FluidPackageFillingCategory.TYPE);
                }
            }
        }
        if (ingredient instanceof FluidStack) {
            stack = (FluidStack)ingredient;
            switch (focus.getRole()) {
                case INPUT: {
                    return List.of(FluidPackageFillingCategory.TYPE);
                }
                case OUTPUT: {
                    return List.of(FluidPackageContentsCategory.TYPE);
                }
            }
        }
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        IVolumePackageItem vPackage;
        ItemStack stack;
        Item item;
        RecipeType type = recipeCategory.getRecipeType();
        Object ingredient = focus.getTypedValue().getIngredient();
        if (ingredient instanceof ItemStack && (item = (stack = (ItemStack)ingredient).m_41720_()) instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) == FluidVolumeType.INSTANCE && (FluidPackageContentsCategory.TYPE.equals((Object)type) || FluidPackageFillingCategory.TYPE.equals((Object)type))) {
            return List.of(vPackage.getVolumeStack(stack));
        }
        if (ingredient instanceof FluidStack) {
            Optional<IVolumeStackWrapper> vStack;
            stack = (FluidStack)ingredient;
            if ((FluidPackageContentsCategory.TYPE.equals((Object)type) || FluidPackageFillingCategory.TYPE.equals((Object)type)) && (vStack = FluidVolumeType.INSTANCE.wrapStack(stack)).isPresent()) {
                return List.of(vStack.get());
            }
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }
}

