/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.stacks.AEItemKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.integration.appeng.recipe.DirectCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;

public class PackagePatternDetailsDecoder
implements IPatternDetailsDecoder {
    public static final PackagePatternDetailsDecoder INSTANCE = new PackagePatternDetailsDecoder();

    protected PackagePatternDetailsDecoder() {
    }

    public boolean isEncodedPattern(ItemStack stack) {
        return stack.m_41720_() instanceof IPackageItem;
    }

    public IPatternDetails decodePattern(AEItemKey what, Level level) {
        return this.decodePattern(what.toStack(), level, false);
    }

    public IPatternDetails decodePattern(ItemStack what, Level level, boolean tryRecovery) {
        Item item = what.m_41720_();
        if (item instanceof IPackageItem) {
            IPackageItem packageItem = (IPackageItem)item;
            switch (packageItem.getPatternType(what)) {
                case PACKAGE: {
                    IPackageRecipeInfo recipe = packageItem.getRecipeInfo(what);
                    int index = packageItem.getIndex(what);
                    if (recipe == null || !recipe.isValid() || !recipe.validPatternIndex(index)) break;
                    return new PackageCraftingPatternDetails(recipe.getPatterns().get(index));
                }
                case RECIPE: {
                    IPackageRecipeInfo recipe = packageItem.getRecipeInfo(what);
                    if (recipe == null || !recipe.isValid()) break;
                    return new RecipeCraftingPatternDetails(recipe);
                }
                case DIRECT: {
                    IPackageRecipeInfo recipe = packageItem.getRecipeInfo(what);
                    if (recipe == null || !recipe.isValid()) break;
                    return new DirectCraftingPatternDetails(recipe);
                }
            }
        }
        return null;
    }
}

