/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.client.RenderTimer;

public class DistributorRenderer {
    public static final DistributorRenderer INSTANCE = new DistributorRenderer();
    public static final Vec3 BLOCK_SIZE = new Vec3(1.0, 1.0, 1.0);
    public static final int BEAM_LIFETIME = 6;
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();
    private PoseStack poseStack;

    private DistributorRenderer() {
    }

    public void onConstruct() {
        MinecraftForge.EVENT_BUS.addListener(this::onRenderLevel);
    }

    public void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            this.poseStack = event.getPoseStack();
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (!(item instanceof IDistributorMarkerItem)) continue;
            IDistributorMarkerItem marker = (IDistributorMarkerItem)item;
            this.renderMarker(this.poseStack, marker.getDirectionalGlobalPos(stack));
        }
        this.renderBeams(this.poseStack, event.getPartialTick());
    }

    public void addBeam(Vec3 source, Vec3 delta) {
        this.beams.add(new BeamInfo(source, delta));
    }

    public void renderMarker(PoseStack poseStack, DirectionalGlobalPos globalPos) {
        if (globalPos == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!globalPos.dimension().equals((Object)mc.f_91073_.m_46472_())) {
            return;
        }
        int range = 2 * DistributorBlockEntity.range + 2;
        BlockPos blockPos = globalPos.blockPos();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Vec3 distVec = cameraPos.m_82546_(blockPos.m_252807_());
        double[] dArray = new double[]{Math.abs(distVec.f_82479_), Math.abs(distVec.f_82480_), Math.abs(distVec.f_82481_)};
        if (Doubles.max((double[])dArray) > (double)range) {
            return;
        }
        MultiBufferSource.BufferSource buffers = RenderTypeHelper.BUFFERS;
        VertexConsumer quadBuffer = buffers.m_6299_(RenderTypeHelper.MARKER_QUAD);
        VertexConsumer lineBuffer = buffers.m_6299_(RenderTypeHelper.MARKER_LINE_4);
        poseStack.m_85836_();
        poseStack.m_85837_((double)blockPos.m_123341_() - cameraPos.f_82479_, (double)blockPos.m_123342_() - cameraPos.f_82480_, (double)blockPos.m_123343_() - cameraPos.f_82481_);
        Direction direction = globalPos.direction();
        this.addMarkerVertices(poseStack, quadBuffer, BLOCK_SIZE, direction, 0.0f, 1.0f, 1.0f, 0.5f);
        this.addMarkerVertices(poseStack, lineBuffer, BLOCK_SIZE, null, 0.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        RenderSystem.disableDepthTest();
        buffers.m_109911_();
        RenderSystem.enableDepthTest();
    }

    public void renderBeams(PoseStack poseStack, float partialTick) {
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + partialTick;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffers = RenderTypeHelper.BUFFERS;
        VertexConsumer lineBuffer = buffers.m_6299_(RenderTypeHelper.BEAM_LINE_3);
        for (BeamInfo beam2 : this.beams) {
            Vec3 source = beam2.source();
            poseStack.m_85836_();
            poseStack.m_85837_(source.f_82479_ - cameraPos.f_82479_, source.f_82480_ - cameraPos.f_82480_, source.f_82481_ - cameraPos.f_82481_);
            this.addBeamVertices(poseStack, lineBuffer, beam2.delta(), 0.0f, 1.0f, 1.0f, beam2.getAlpha(renderTick));
            poseStack.m_85849_();
        }
        buffers.m_109911_();
    }

    public void addMarkerVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, Direction direction, float r, float g, float b, float a) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x = (float)delta.f_82479_;
        float y = (float)delta.f_82480_;
        float z = (float)delta.f_82481_;
        if (direction == null || direction == Direction.NORTH) {
            buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null || direction == Direction.SOUTH) {
            buffer.m_252986_(pose, x, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, z).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null || direction == Direction.WEST) {
            buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (direction == null || direction == Direction.EAST) {
            buffer.m_252986_(pose, x, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_252986_(pose, x, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (direction == Direction.DOWN) {
            buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == Direction.UP) {
            buffer.m_252986_(pose, 0.0f, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, z).m_85950_(r, g, b, a).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null) {
            buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, y, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, z).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        }
    }

    public void addBeamVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, float r, float g, float b, float a) {
        Vec3 normalVec = delta.m_82541_();
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x = (float)delta.f_82479_;
        float y = (float)delta.f_82480_;
        float z = (float)delta.f_82481_;
        float xn = (float)normalVec.f_82479_;
        float yn = (float)normalVec.f_82480_;
        float zn = (float)normalVec.f_82481_;
        buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_252939_(normal, xn, yn, zn).m_5752_();
        buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_252939_(normal, xn, yn, zn).m_5752_();
    }

    public record BeamInfo(Vec3 source, Vec3 delta, int startTick) {
        public BeamInfo(Vec3 source, Vec3 delta) {
            this(source, delta, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= 6;
        }

        public float getAlpha(float renderTick) {
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = diff / 6.0f;
            return 1.0f - factor * factor;
        }
    }

    public static class RenderTypeHelper
    extends RenderType {
        public static final RenderType MARKER_LINE_4 = RenderTypeHelper.m_173215_((String)"packagedauto:marker_line_4", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).m_110669_(f_110119_).m_110687_(f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false));
        public static final RenderType MARKER_QUAD = RenderTypeHelper.m_173215_((String)"packagedauto:marker_quad", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110669_(f_110119_).m_110685_(f_110139_).m_110687_(f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false));
        public static final RenderType BEAM_LINE_3 = RenderTypeHelper.m_173215_((String)"packagedauto:beam_line_3", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        public static final MultiBufferSource.BufferSource BUFFERS = MultiBufferSource.m_109900_(Map.of(MARKER_LINE_4, new BufferBuilder(MARKER_LINE_4.m_110507_()), MARKER_QUAD, new BufferBuilder(MARKER_QUAD.m_110507_()), BEAM_LINE_3, new BufferBuilder(BEAM_LINE_3.m_110507_())), (BufferBuilder)Tesselator.m_85913_().m_85915_());

        private RenderTypeHelper(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }
}

