/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagingProviderBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagingProviderBlockEntity;
import thelm.packagedauto.inventory.PackagingProviderItemHandler;
import thelm.packagedauto.menu.PackagingProviderMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagingProviderBlockEntity
extends BaseBlockEntity {
    public static final BlockEntityType<PackagingProviderBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEPackagingProviderBlockEntity::new, () -> () -> PackagingProviderBlockEntity::new).get()), (Block[])new Block[]{PackagingProviderBlock.INSTANCE}).m_58966_(null);
    public List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
    public IPackagePattern currentPattern;
    public List<ItemStack> toSend = new ArrayList<ItemStack>();
    public Direction sendDirection;
    public boolean sendOrdered;
    public boolean powered = false;
    public boolean blocking = false;
    public boolean provideDirect = true;
    public boolean providePackaging = false;
    public boolean provideUnpackaging = false;

    public PackagingProviderBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new PackagingProviderItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.packaging_provider");
    }

    public void updatePowered() {
        if (this.f_58857_.m_277086_(this.f_58858_) > 0 != this.powered) {
            this.powered = !this.powered;
            this.m_6596_();
        }
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.m_6596_();
    }

    public void changeProvideType(Type type) {
        switch (type) {
            case DIRECT: {
                boolean bl = this.provideDirect = !this.provideDirect;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideUnpackaging = false;
                    this.providePackaging = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideUnpackaging = true;
                this.providePackaging = true;
                break;
            }
            case PACKAGING: {
                boolean bl = this.providePackaging = !this.providePackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
                break;
            }
            case UNPACKAGING: {
                boolean bl = this.provideUnpackaging = !this.provideUnpackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
            }
        }
        this.postPatternChange();
        this.m_6596_();
    }

    public void postPatternChange() {
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.m_142466_(nbt);
        this.blocking = nbt.m_128471_("Blocking");
        this.provideDirect = nbt.m_128471_("Direct");
        this.providePackaging = nbt.m_128471_("Packaging");
        this.provideUnpackaging = nbt.m_128471_("Unpackaging");
        this.powered = nbt.m_128471_("Powered");
        if (nbt.m_128441_("Pattern") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.m_128469_("Pattern"))) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.m_128445_("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
            }
        }
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("ToSend", 10), this.toSend);
        if (nbt.m_128441_("SendDirection")) {
            this.sendDirection = Direction.m_122376_((int)nbt.m_128445_("SendDirection"));
        }
        this.sendOrdered = nbt.m_128471_("SendOrdered");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Blocking", this.blocking);
        nbt.m_128379_("Direct", this.provideDirect);
        nbt.m_128379_("Packaging", this.providePackaging);
        nbt.m_128379_("Unpackaging", this.provideUnpackaging);
        nbt.m_128379_("Powered", this.powered);
        if (this.currentPattern != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.currentPattern.getRecipeInfo());
            tag.m_128344_("Index", (byte)this.currentPattern.getIndex());
            nbt.m_128365_("Pattern", (Tag)tag);
        }
        nbt.m_128365_("ToSend", (Tag)MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.toSend));
        if (this.sendDirection != null) {
            nbt.m_128344_("SendDirection", (byte)this.sendDirection.m_122411_());
        }
        nbt.m_128379_("SendOrdered", this.sendOrdered);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new PackagingProviderMenu(windowId, inventory, this);
    }

    public static enum Type {
        DIRECT,
        PACKAGING,
        UNPACKAGING;

    }
}

