/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.CrafterBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.blockentity.AECrafterBlockEntity;
import thelm.packagedauto.inventory.CrafterItemHandler;
import thelm.packagedauto.menu.CrafterMenu;
import thelm.packagedauto.recipe.ICraftingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class CrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static final BlockEntityType<CrafterBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AECrafterBlockEntity::new, () -> () -> CrafterBlockEntity::new).get()), (Block[])new Block[]{CrafterBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public ICraftingPackageRecipeInfo currentRecipe;

    public CrafterBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new CrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.crafter");
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof ICraftingPackageRecipeInfo) {
            ICraftingPackageRecipeInfo recipe = (ICraftingPackageRecipeInfo)recipeInfo;
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.m_41619_() || ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.m_41613_() + outputStack.m_41613_() <= outputStack.m_41741_()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.remainingProgress = energyReq;
                for (int i = 0; i < 9; ++i) {
                    this.itemHandler.setStackInSlot(i, recipe.getMatrix().m_8020_(i).m_41777_());
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::m_41619_);
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(9).m_41619_()) {
            this.itemHandler.setStackInSlot(9, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(9).m_41769_(this.currentRecipe.getOutput().m_41613_());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.setStackInSlot(i, remainingItems.get(i));
        }
        this.endProcess();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.m_6596_();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity == null || blockEntity instanceof UnpackagerBlockEntity || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve().get();
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 10).stream().allMatch(ItemStack::m_41619_)) {
            return 15;
        }
        return 0;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.m_142466_(nbt);
        this.isWorking = nbt.m_128471_("Working");
        this.remainingProgress = nbt.m_128451_("Progress");
        this.currentRecipe = null;
        if (nbt.m_128441_("Recipe") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.m_128469_("Recipe"))) instanceof ICraftingPackageRecipeInfo) {
            ICraftingPackageRecipeInfo craftingRecipe;
            this.currentRecipe = craftingRecipe = (ICraftingPackageRecipeInfo)recipe;
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Working", this.isWorking);
        nbt.m_128405_("Progress", this.remainingProgress);
        if (this.currentRecipe != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.currentRecipe);
            nbt.m_128365_("Recipe", (Tag)tag);
        }
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new CrafterMenu(windowId, inventory, this);
    }
}

