/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class PackageCraftingPatternDetails
implements IPatternDetails {
    public final AEItemKey recipeHolder;
    public final IPackagePattern pattern;
    public final IPatternDetails.IInput[] inputs;
    public final GenericStack[] outputs;

    public PackageCraftingPatternDetails(ItemStack recipeHolder, IPackagePattern pattern) {
        this.recipeHolder = AEItemKey.of((ItemStack)recipeHolder);
        this.pattern = pattern;
        List<GenericStack> sparseInputs = pattern.getInputs().stream().map(GenericStack::fromItemStack).toList();
        this.inputs = AppEngUtil.toInputs(pattern.getRecipeInfo(), AppEngUtil.condenseStacks(sparseInputs));
        this.outputs = new GenericStack[]{GenericStack.fromItemStack((ItemStack)pattern.getOutput())};
    }

    public AEItemKey getDefinition() {
        return this.recipeHolder;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageCraftingPatternDetails) {
            PackageCraftingPatternDetails other = (PackageCraftingPatternDetails)obj;
            return this.pattern.getIndex() == other.pattern.getIndex() && this.pattern.getRecipeInfo().equals(other.pattern.getRecipeInfo());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pattern.getIndex(), this.pattern.getRecipeInfo());
    }
}

