/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;

public class AEUnpackagerBlockEntity
extends UnpackagerBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEUnpackagerBlockEntity>,
IActionHost,
ICraftingProvider {
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEUnpackagerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.getMainNode().create(this.f_58857_, this.f_58858_);
        }
        super.tick();
        if (drawMEEnergy && !this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 8L == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEUnpackagerBlockEntity nodeOwner, IGridNode node) {
        this.m_6596_();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("Node");
            this.gridNode.setVisualRepresentation((ItemLike)UnpackagerBlock.INSTANCE);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridNode.addService(ICraftingProvider.class, (IGridNodeService)this);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.f_58857_).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.isBusy() && patternDetails instanceof RecipeCraftingPatternDetails) {
            RecipeCraftingPatternDetails pattern = (RecipeCraftingPatternDetails)patternDetails;
            IntArrayList emptySlots = new IntArrayList();
            for (int i = 0; i < 9; ++i) {
                if (!this.itemHandler.getStackInSlot(i).m_41619_()) continue;
                emptySlots.add(i);
            }
            List<IPackagePattern> patterns = pattern.recipe.getPatterns();
            if (patterns.size() > emptySlots.size()) {
                return false;
            }
            for (int i = 0; i < patterns.size(); ++i) {
                this.itemHandler.setStackInSlot(emptySlots.getInt(i), patterns.get(i).getOutput().m_41777_());
            }
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return Arrays.stream(this.trackers).noneMatch(UnpackagerBlockEntity.PackageTracker::isEmpty);
    }

    public List<IPatternDetails> getAvailablePatterns() {
        ItemStack patternStack = this.itemHandler.getStackInSlot(9);
        return this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new RecipeCraftingPatternDetails(patternStack, (IPackageRecipeInfo)pattern)).toList();
    }

    @Override
    protected boolean isPatternProvider(BlockEntity blockEntity, Direction direction) {
        return AppEngUtil.isPatternProvider(blockEntity, direction);
    }

    @Override
    public void postPatternChange() {
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    protected void chargeMEEnergy() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyService.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyService.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (this.f_58857_ != null && nbt.m_128441_("Node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

