/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEDistributorBlockEntity;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.menu.DistributorMenu;
import thelm.packagedauto.network.packet.DistributorBeamPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static final BlockEntityType<DistributorBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEDistributorBlockEntity::new, () -> () -> DistributorBlockEntity::new).get()), (Block[])new Block[]{DistributorBlock.INSTANCE}).m_58966_(null);
    public static int range = 16;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);

    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new DistributorItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.distributor");
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 8L == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
            boolean blocking = false;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity instanceof UnpackagerBlockEntity) {
                UnpackagerBlockEntity unpackager = (UnpackagerBlockEntity)blockEntity;
                blocking = unpackager.blocking;
            }
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                IVolumePackageItem vPackage;
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.f_58857_.m_46749_(pos)) {
                    return false;
                }
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(pos);
                if (blockEntity2 == null) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).m_41777_();
                Direction dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)blockEntity2.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
                Item item = stack.m_41720_();
                if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity2, dir)) {
                    if (blocking && !vPackage.getVolumeType(stack).isEmpty((ICapabilityProvider)blockEntity2, dir)) {
                        return false;
                    }
                    if (MiscHelper.INSTANCE.fillVolume(blockEntity2, dir, stack, true).m_41619_()) continue;
                    return false;
                }
                if (itemHandler != null) {
                    if (blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).m_41619_()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).m_41777_());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        for (int i : this.pending.keySet().toIntArray()) {
            IVolumePackageItem vPackage;
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                return;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.f_58857_.m_46749_(pos)) continue;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity == null) {
                this.ejectItems();
                return;
            }
            ItemStack stack = (ItemStack)this.pending.get(i);
            Direction dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
            ItemStack stackRem = stack;
            Item item = stack.m_41720_();
            if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, dir)) {
                stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, dir, stack, false);
            } else if (itemHandler != null) {
                stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            } else {
                this.ejectItems();
                return;
            }
            if (!this.f_58857_.f_46443_ && stackRem.m_41613_() < stack.m_41613_()) {
                Vec3 source = Vec3.m_82512_((Vec3i)this.f_58858_);
                Vec3 target = Vec3.m_82512_((Vec3i)pos).m_82520_((double)dir.m_122429_() * 0.5, (double)dir.m_122430_() * 0.5, (double)dir.m_122431_() * 0.5);
                DistributorBeamPacket.sendBeam(source, target.m_82546_(source), (ResourceKey<Level>)this.f_58857_.m_46472_(), 32.0);
            }
            if (stackRem.m_41619_()) {
                this.pending.remove(i);
                continue;
            }
            this.pending.put(i, (Object)stackRem);
        }
        this.m_6596_();
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).m_41619_()) continue;
            double dx = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
            double dy = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.75;
            double dz = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + dx, (double)this.f_58858_.m_123342_() + dy, (double)this.f_58858_.m_123343_() + dz, stack);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
        this.m_6596_();
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Pending", 10), pendingList);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.m_41619_()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault(i, (Object)ItemStack.f_41583_));
        }
        ListTag pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), pendingList);
        nbt.m_128365_("Pending", (Tag)pendingTag);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new DistributorMenu(windowId, inventory, this);
    }
}

