/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import com.mojang.serialization.Codec;
import igentuman.nc.handler.config.OreGenConfig;
import igentuman.nc.setup.registration.WorldGeneration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class OrePlacementModifier
extends PlacementModifier {
    public static final Codec<OrePlacementModifier> CODEC = Codec.INT.fieldOf("count").xmap(OrePlacementModifier::new, modifier -> modifier.count).codec();
    private int count;
    private final HashMap<String, Integer> countMap = new HashMap();
    private final HashMap<String, Integer[]> heightMap = new HashMap();
    private final HashMap<String, List<Integer>> dimensionsMap = new HashMap();
    private String name;

    public OrePlacementModifier(int count) {
        for (String name : OreGenConfig.ORE_CONFIG.ORES.keySet()) {
            List dims;
            int maxHeight;
            int minHeight;
            int amount;
            boolean register;
            try {
                register = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).register.get();
                amount = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).veinSize.get();
                minHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).min_height.get();
                maxHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).max_height.get();
                dims = (List)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).dimensions.get();
            }
            catch (Exception e) {
                register = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).register.getDefault();
                amount = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).veinSize.getDefault();
                minHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).min_height.getDefault();
                maxHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).max_height.getDefault();
                dims = (List)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).dimensions.getDefault();
            }
            if (!register) {
                amount = 0;
            }
            this.heightMap.put(name, new Integer[]{minHeight, maxHeight});
            this.dimensionsMap.put(name, dims);
            this.countMap.put(name, amount);
        }
        this.count = count;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)WorldGeneration.NC_ORE_MODIFIER.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        int actualCount = this.determinePlacementCount(context, random, pos);
        return Stream.generate(() -> new BlockPos(pos.m_123341_() + random.m_188503_(16), this.heightMap.get(this.name)[0] + random.m_188503_(this.heightMap.get(this.name)[1] - this.heightMap.get(this.name)[0] + 1), pos.m_123343_() + random.m_188503_(16))).limit(actualCount);
    }

    private int determinePlacementCount(PlacementContext context, RandomSource random, BlockPos pos) {
        this.name = ((ResourceKey)((PlacedFeature)context.m_191832_().get()).f_191775_().m_203543_().get()).m_135782_().m_135815_().replace("_ore", "");
        int dimensionId = ((Registry)context.m_191831_().m_7654_().m_206579_().m_6632_(Registries.f_256787_).get()).m_7447_((Object)context.m_191831_().m_6018_().m_6042_());
        int veinSize = this.countMap.get(this.name);
        if (!this.dimensionsMap.get(this.name).contains(dimensionId)) {
            veinSize = 0;
        }
        if (veinSize == 0) {
            return 0;
        }
        return random.m_188503_(veinSize);
    }
}

