/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.world.NCConfiguredFeatures;
import igentuman.nc.world.OrePlacementModifier;
import igentuman.nc.world.ore.NCOre;
import igentuman.nc.world.ore.OreGenerator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class NCPlacedFeatures {
    public static final HashMap<String, ResourceKey<PlacedFeature>> PLACED_FEATURES = NCPlacedFeatures.initPlaceFeatures();

    private static HashMap<String, ResourceKey<PlacedFeature>> initPlaceFeatures() {
        HashMap<String, ResourceKey<PlacedFeature>> map = new HashMap<String, ResourceKey<PlacedFeature>>();
        for (String name : Ores.all().keySet()) {
            map.put(name, NCPlacedFeatures.registerKey(name + "_placed"));
        }
        return map;
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        for (String name : Ores.registered().keySet()) {
            NCOre ore = Ores.all().get(name);
            if (ore.dimensions.contains(0)) {
                NCPlacedFeatures.register(context, PLACED_FEATURES.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.ORE_CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(ore.config().veinSize), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
            }
            if (ore.dimensions.contains(-1)) {
                NCPlacedFeatures.register(context, PLACED_FEATURES.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.ORE_CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(ore.config().veinSize), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.height[1]))));
            }
            if (!ore.dimensions.contains(1)) continue;
            NCPlacedFeatures.register(context, PLACED_FEATURES.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.ORE_CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(ore.config().veinSize), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
        }
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)NuclearCraft.rl(name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

