/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.setup.registration.Registries;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.IReverseTag;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class TagUtil {
    public static Fluid getFirstMatchingFluidByTag(String key) {
        if (key.contains(":")) {
            String[] parts = key.split(":");
            if (!Objects.equals(parts[0], "forge")) {
                FluidStack fluid = TagUtil.getFluidByName(key.replace("/", "_"));
                if (!fluid.isEmpty()) {
                    return fluid.getFluid();
                }
                fluid = TagUtil.getFluidByName(key);
                if (!fluid.isEmpty()) {
                    return fluid.getFluid();
                }
            }
            key = parts[1];
        }
        for (String mod : (List)MaterialsConfig.MATERIAL_PRODUCTS.MODS_PRIORITY.get()) {
            FluidStack fluid = TagUtil.getFluidByName(mod + ":" + key);
            if (!fluid.isEmpty()) {
                return fluid.getFluid();
            }
            fluid = TagUtil.getFluidByName(mod + ":" + key.replace("/", "_"));
            if (fluid.isEmpty()) continue;
            return fluid.getFluid();
        }
        return FluidStack.EMPTY.getFluid();
    }

    public static FluidStack getFluidByName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("FluidName", name);
        tag.m_128405_("Amount", 1);
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
    }

    public static List<Block> getBlocksByTagKey(String key) {
        ArrayList<Block> tmp = new ArrayList<Block>();
        TagKey tag = TagKey.m_203882_(Registries.BLOCK_REGISTRY, (ResourceLocation)new ResourceLocation(key));
        for (Block holder : ForgeRegistries.BLOCKS.tags().getTag(tag).stream().toList()) {
            tmp.add(holder);
        }
        return tmp;
    }

    public static Block getSingleBlockByTagKey(String key) {
        for (String mod : (List)MaterialsConfig.MATERIAL_PRODUCTS.MODS_PRIORITY.get()) {
            for (Block holder : TagUtil.getBlocksByTagKey(key)) {
                if (!holder.m_7705_().contains(mod)) continue;
                return holder;
            }
        }
        return TagUtil.getBlocksByTagKey(key).get(0);
    }

    public static List<Item> getItemsByTagKey(String key) {
        ArrayList<Item> tmp = new ArrayList<Item>();
        TagKey tag = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation(key));
        for (Item holder : ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList()) {
            tmp.add(holder);
        }
        return tmp;
    }

    public static <TYPE> ITagManager<TYPE> manager(IForgeRegistry<TYPE> registry) {
        ITagManager tags = registry.tags();
        if (tags == null) {
            throw new IllegalStateException("Expected " + registry.getRegistryName() + " to have tags.");
        }
        return tags;
    }

    public static <TYPE> ITag<TYPE> tag(IForgeRegistry<TYPE> registry, TagKey<TYPE> key) {
        return TagUtil.manager(registry).getTag(key);
    }

    public static <TYPE> TagKey<TYPE> createKey(IForgeRegistry<TYPE> registry, ResourceLocation tag) {
        return TagUtil.manager(registry).createTagKey(tag);
    }

    public static <TYPE> Set<TagKey<TYPE>> tags(IForgeRegistry<TYPE> registry, TYPE element) {
        return TagUtil.tags(TagUtil.manager(registry), element);
    }

    public static <TYPE> Set<TagKey<TYPE>> tags(ITagManager<TYPE> tagManager, TYPE element) {
        return TagUtil.tagsStream(tagManager, element).collect(Collectors.toSet());
    }

    public static <TYPE> Stream<TagKey<TYPE>> tagsStream(IForgeRegistry<TYPE> registry, TYPE element) {
        return TagUtil.tagsStream(TagUtil.manager(registry), element);
    }

    public static <TYPE> Stream<TagKey<TYPE>> tagsStream(ITagManager<TYPE> tagManager, TYPE element) {
        return tagManager.getReverseTag(element).map(IReverseTag::getTagKeys).orElse(Stream.empty());
    }

    public static <TYPE> Set<ResourceLocation> tagNames(IForgeRegistry<TYPE> registry, TYPE element) {
        return TagUtil.tagNames(TagUtil.manager(registry), element);
    }

    public static <TYPE> Set<ResourceLocation> tagNames(ITagManager<TYPE> tagManager, TYPE element) {
        return TagUtil.tagNames(TagUtil.tagsStream(tagManager, element));
    }

    public static Set<ResourceLocation> tagNames(Stream<? extends TagKey<?>> stream) {
        return stream.map(TagKey::f_203868_).collect(Collectors.toUnmodifiableSet());
    }
}

