/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.IFluidTank;

@NothingNullByDefault
public class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static void readContainers(List<? extends INBTSerializable<CompoundTag>> containers, ListTag storedContainers) {
        DataHandlerUtils.readContents(containers, storedContainers, DataHandlerUtils.getTagByType(containers));
    }

    public static ListTag writeContainers(List<? extends INBTSerializable<CompoundTag>> containers) {
        return DataHandlerUtils.writeContents(containers, DataHandlerUtils.getTagByType(containers));
    }

    public static void readContents(List<? extends INBTSerializable<CompoundTag>> contents, ListTag storedContents, String key) {
        int size = contents.size();
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            CompoundTag tagCompound = storedContents.m_128728_(tagCount);
            byte id = tagCompound.m_128445_(key);
            if (id < 0 || id >= size) continue;
            contents.get(id).deserializeNBT((Tag)tagCompound);
        }
    }

    public static ListTag writeContents(List<? extends INBTSerializable<CompoundTag>> contents, String key) {
        ListTag storedContents = new ListTag();
        for (int tank = 0; tank < contents.size(); ++tank) {
            CompoundTag tagCompound = (CompoundTag)contents.get(tank).serializeNBT();
            if (tagCompound.m_128456_()) continue;
            tagCompound.m_128344_(key, (byte)tank);
            storedContents.add((Object)tagCompound);
        }
        return storedContents;
    }

    private static String getTagByType(List<? extends INBTSerializable<CompoundTag>> containers) {
        if (containers.isEmpty()) {
            return "Container";
        }
        INBTSerializable<CompoundTag> obj = containers.get(0);
        if (obj instanceof IFluidTank) {
            return "Tank";
        }
        return "Container";
    }

    public static int getMaxId(ListTag storedContents, String key) {
        byte maxId = -1;
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            byte id = storedContents.m_128728_(tagCount).m_128445_(key);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId + 1;
    }
}

