/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.NuclearCraft;
import igentuman.nc.world.OrePlacementModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class WorldGeneration {
    public static final ResourceKey<Biome> WASTELAND_BIOME = WorldGeneration.makeKey("wasteland");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)"nuclearcraft");
    public static final RegistryObject<PlacementModifierType<OrePlacementModifier>> NC_ORE_MODIFIER = PLACEMENT_MODIFIERS.register("nc_ore_modifier", () -> () -> OrePlacementModifier.CODEC);

    private static ResourceKey<Biome> makeKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)NuclearCraft.rl(name));
    }

    public static void registerExtraStuff(RegisterEvent evt) {
    }

    public static void register(IEventBus eventBus) {
        PLACEMENT_MODIFIERS.register(eventBus);
    }

    public static void init() {
    }

    public static class StructurePlacer {
        public static void placeStructure(ServerLevel level, BlockPos pos, String name) {
            ResourceLocation structureLocation = new ResourceLocation("nuclearcraft", name);
            StructureTemplate template = StructureLoader.loadStructure(level, structureLocation);
            if (template == null) {
                System.out.println("Structure not found: " + structureLocation);
                return;
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false);
            template.m_230328_((ServerLevelAccessor)level, pos, pos, settings, level.f_46441_, 2);
        }
    }

    public static class StructureLoader {
        private static final String STRUCTURE_PATH = ":structures/fission_reactor   ";

        public static StructureTemplate loadStructure(ServerLevel level, ResourceLocation structureLocation) {
            StructureTemplateManager manager = level.m_215082_();
            return manager.m_230407_(structureLocation).orElse(null);
        }
    }
}

