/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.BarrelBlock;
import igentuman.nc.block.BatteryBlock;
import igentuman.nc.block.ContainerBlock;
import igentuman.nc.block.RTGBlock;
import igentuman.nc.block.SolarPanelBlock;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class CreativeTabs {
    public static final RegistryObject<CreativeModeTab> FUSION_REACTOR_TAB = Registries.CREATIVE_TABS.register("fusion_reactor", () -> CreativeModeTab.builder().m_257501_((displayParams, output) -> FusionReactor.FUSION_BLOCKS.values().forEach(itemlike -> output.m_246342_(new ItemStack((ItemLike)itemlike.get())))).m_257737_(() -> new ItemStack((ItemLike)FusionReactor.FUSION_BLOCKS.get("fusion_core").get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_fusion_reactor")).m_257652_());
    public static final RegistryObject<CreativeModeTab> NC_BLOCKS_TAB = Registries.CREATIVE_TABS.register("nc_blocks", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)TagUtil.getBlocksByTagKey("forge:storage_blocks/uranium").get(0))).m_257501_((displayParams, output) -> CreativeTabs.getBlocks().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_blocks")).m_257652_());
    public static final RegistryObject<CreativeModeTab> NC_ITEMS_TAB = Registries.CREATIVE_TABS.register("nc_items", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)TagUtil.getItemsByTagKey("forge:ingots/uranium").get(0))).m_257501_((displayParams, output) -> CreativeTabs.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_items")).m_257652_());
    public static final RegistryObject<CreativeModeTab> NC_PARTS_TAB = Registries.CREATIVE_TABS.register("nc_parts", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)NCItems.NC_PARTS.get("actuator").get())).m_257501_((displayParams, output) -> NCItems.NC_PARTS.values().forEach(itemlike -> output.m_246342_(new ItemStack((ItemLike)itemlike.get())))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_items")).m_257652_());
    public static final RegistryObject<CreativeModeTab> FISSION_REACTOR_TAB = Registries.CREATIVE_TABS.register("fission_reactor", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)FissionReactor.FISSION_BLOCKS.get("fission_reactor_controller").get())).m_257501_((displayParams, output) -> FissionReactor.FISSION_BLOCKS.values().forEach(itemlike -> output.m_246342_(new ItemStack((ItemLike)itemlike.get())))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_fission_reactor")).m_257652_());
    public static final RegistryObject<CreativeModeTab> TURBINE_TAB = Registries.CREATIVE_TABS.register("turbine", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)TurbineRegistration.TURBINE_BLOCKS.get("turbine_controller").get())).m_257501_((displayParams, output) -> TurbineRegistration.TURBINE_BLOCKS.values().forEach(itemlike -> output.m_246342_(new ItemStack((ItemLike)itemlike.get())))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_turbine")).m_257652_());
    public static final RegistryObject<CreativeModeTab> NC_FLUIDS = Registries.CREATIVE_TABS.register("nc_fluids", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)NCFluids.FluidEntry.ALL_BUCKETS.get(0).get())).m_257501_((displayParams, output) -> NCFluids.FluidEntry.ALL_BUCKETS.forEach(itemlike -> output.m_246342_(new ItemStack((ItemLike)itemlike.get())))).m_257941_((Component)Component.m_237115_((String)"itemGroup.nuclearcraft_fluids")).m_257652_());

    private static List<ItemStack> itemStacks(Collection<RegistryObject<Item>> map) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (RegistryObject<Item> item : map) {
            stacks.add(new ItemStack((ItemLike)item.get()));
        }
        return stacks;
    }

    private static List<ItemStack> blockStacks(Collection<RegistryObject<Block>> map) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (RegistryObject<Block> item : map) {
            stacks.add(new ItemStack((ItemLike)item.get()));
        }
        return stacks;
    }

    private static List<ItemStack> onlyEnabledItems(String type, HashMap<String, RegistryObject<Item>> items) {
        ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>();
        Set<String> enabled = Materials.registeredOf(type);
        for (String name : items.keySet()) {
            if (!enabled.contains(name)) continue;
            itemsList.add(new ItemStack((ItemLike)items.get(name).get()));
        }
        return itemsList;
    }

    private static List<ItemStack> onlyEnabledBlocks(HashMap<String, RegistryObject<Block>> block) {
        ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>();
        Set<String> enabled = Materials.registeredOf("block");
        for (String name : block.keySet()) {
            if (!enabled.contains(name)) continue;
            itemsList.add(new ItemStack((ItemLike)block.get(name).get()));
        }
        return itemsList;
    }

    private static List<ItemStack> getItems() {
        List<ItemStack> items = CreativeTabs.itemStacks(NCItems.NC_PARTS.values());
        items.addAll(CreativeTabs.itemStacks(NCItems.NC_ITEMS.values()));
        items.addAll(CreativeTabs.itemStacks(NCItems.NC_RECORDS.values()));
        items.addAll(CreativeTabs.itemStacks(NCItems.NC_FOOD.values()));
        items.addAll(CreativeTabs.itemStacks(NCItems.NC_SHIELDING.values()));
        items.addAll(CreativeTabs.onlyEnabledItems("ingot", NCItems.NC_INGOTS));
        items.addAll(CreativeTabs.onlyEnabledItems("chunk", NCItems.NC_CHUNKS));
        items.addAll(CreativeTabs.onlyEnabledItems("dust", NCItems.NC_DUSTS));
        items.addAll(CreativeTabs.onlyEnabledItems("gem", NCItems.NC_GEMS));
        items.addAll(CreativeTabs.onlyEnabledItems("nugget", NCItems.NC_NUGGETS));
        items.addAll(CreativeTabs.onlyEnabledItems("plate", NCItems.NC_PLATES));
        items.addAll(CreativeTabs.itemStacks(FissionFuel.NC_ISOTOPES.values()));
        items.addAll(CreativeTabs.itemStacks(FissionFuel.NC_FUEL.values()));
        items.addAll(CreativeTabs.itemStacks(FissionFuel.NC_DEPLETED_FUEL.values()));
        items.add(new ItemStack((ItemLike)NCItems.HEV_HELMET.get()));
        items.add(new ItemStack((ItemLike)NCItems.HEV_CHEST.get()));
        items.add(new ItemStack((ItemLike)NCItems.HEV_PANTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.HEV_BOOTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.HAZMAT_MASK.get()));
        items.add(new ItemStack((ItemLike)NCItems.HAZMAT_CHEST.get()));
        items.add(new ItemStack((ItemLike)NCItems.HAZMAT_PANTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.HAZMAT_BOOTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.TOUGH_HELMET.get()));
        items.add(new ItemStack((ItemLike)NCItems.TOUGH_CHEST.get()));
        items.add(new ItemStack((ItemLike)NCItems.TOUGH_PANTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.TOUGH_BOOTS.get()));
        items.add(new ItemStack((ItemLike)NCItems.SPAXELHOE_THORIUM.get()));
        items.add(new ItemStack((ItemLike)NCItems.SPAXELHOE_TOUGH.get()));
        items.add(new ItemStack((ItemLike)NCItems.QNP.get()));
        items.add(new ItemStack((ItemLike)NCItems.MULTITOOL.get()));
        items.add(new ItemStack((ItemLike)NCItems.GEIGER_COUNTER.get()));
        items.add(new ItemStack((ItemLike)NCItems.LITHIUM_ION_CELL.get()));
        return items;
    }

    private static List<ItemStack> getBlocks() {
        Object object;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String string : NCProcessors.PROCESSORS.keySet()) {
            if (Processors.registered().containsKey(string)) {
                items.add(new ItemStack((ItemLike)NCProcessors.PROCESSORS.get(string).get()));
                continue;
            }
            NuclearCraft.LOGGER.info("Processor not registered: " + string);
        }
        items.addAll(CreativeTabs.blockStacks(NCBlocks.NC_BLOCKS.values()));
        items.add(new ItemStack((ItemLike)NCBlocks.REDSTONE_DIMMER_ITEM_BLOCK.get()));
        items.addAll(CreativeTabs.blockStacks(NCBlocks.NC_ELECTROMAGNETS.values()));
        items.addAll(CreativeTabs.blockStacks(NCBlocks.NC_RF_AMPLIFIERS.values()));
        for (RegistryObject registryObject : NCEnergyBlocks.ENERGY_BLOCKS.values()) {
            object = registryObject.get();
            if (object instanceof SolarPanelBlock) {
                SolarPanelBlock solarPanel = (SolarPanelBlock)((Object)object);
                if (!solarPanel.registered()) continue;
                items.add(new ItemStack((ItemLike)solarPanel));
                continue;
            }
            object = registryObject.get();
            if (object instanceof RTGBlock) {
                RTGBlock rtgBlock = (RTGBlock)((Object)object);
                if (!rtgBlock.registered()) continue;
                items.add(new ItemStack((ItemLike)rtgBlock));
                continue;
            }
            object = registryObject.get();
            if (object instanceof BatteryBlock) {
                BatteryBlock batteryBlock = (BatteryBlock)((Object)object);
                if (!batteryBlock.registered()) continue;
                items.add(new ItemStack((ItemLike)batteryBlock));
                continue;
            }
            items.add(new ItemStack((ItemLike)registryObject.get()));
        }
        for (ItemStack itemStack : CreativeTabs.blockStacks(NCBlocks.ORE_BLOCKS.values())) {
            String type = itemStack.m_41720_().toString().replaceAll("_ore|_deepslate_ore", "");
            if (!Ores.registered().containsKey(type)) continue;
            items.add(itemStack);
        }
        items.addAll(CreativeTabs.onlyEnabledBlocks(NCBlocks.NC_MATERIAL_BLOCKS));
        for (RegistryObject registryObject : NCStorageBlocks.STORAGE_BLOCKS.values()) {
            object = registryObject.get();
            if (object instanceof ContainerBlock) {
                ContainerBlock containerBlock = (ContainerBlock)((Object)object);
                if (!containerBlock.registered()) continue;
                items.add(new ItemStack((ItemLike)containerBlock));
                continue;
            }
            object = registryObject.get();
            if (object instanceof BarrelBlock) {
                BarrelBlock barrelBlock = (BarrelBlock)((Object)object);
                if (!barrelBlock.registered()) continue;
                items.add(new ItemStack((ItemLike)barrelBlock));
                continue;
            }
            items.add(new ItemStack((ItemLike)registryObject.get()));
        }
        return items;
    }

    public static void init() {
    }
}

