/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.type;

import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.FluidStackIngredientCreator;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public class MekChemicalConversionRecipe
extends NcRecipe {
    public ChemicalStack<?> inputChemical;
    public FluidStack outputFluid;

    public MekChemicalConversionRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiation, double rarityModifier) {
        super(id, input, output, timeModifier, powerModifier, radiation, rarityModifier);
    }

    public MekChemicalConversionRecipe(ChemicalStack<?> input, FluidStack outputFluid) {
        super(new ResourceLocation("mek_chemical_conversion"), new ItemStackIngredient[0], new ItemStackIngredient[0], 1.0, 1.0, 1.0, 1.0);
        this.inputChemical = input;
        this.outputFluid = outputFluid;
    }

    public static FluidStack getStackByTagCode(String name) {
        ITagManager tagManager = TagUtil.manager(ForgeRegistries.FLUIDS);
        TagKey key = tagManager.createTagKey(new ResourceLocation("forge", name));
        ITag fluidITag = TagUtil.tag(ForgeRegistries.FLUIDS, key);
        if (fluidITag.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        try {
            fluidStack = (FluidStack)FluidStackIngredientCreator.INSTANCE.from(fluidITag.getKey(), 1000).getRepresentations().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fluidStack;
    }

    public static FluidStack getFluidBySlurry(Slurry gas) {
        String name = gas.getName();
        return MekChemicalConversionRecipe.getStackByTagCode(name);
    }

    public static FluidStack getFluidByGas(Gas gas) {
        String name = gas.getName();
        return MekChemicalConversionRecipe.getStackByTagCode(name);
    }

    public static List<MekChemicalConversionRecipe> getRecipes() {
        FluidStack fluid;
        ArrayList<MekChemicalConversionRecipe> recipes = new ArrayList<MekChemicalConversionRecipe>();
        for (Map.Entry gas : MekanismAPI.gasRegistry().getEntries()) {
            fluid = MekChemicalConversionRecipe.getFluidByGas((Gas)gas.getValue());
            if (fluid.isEmpty()) continue;
            recipes.add(new MekChemicalConversionRecipe((ChemicalStack<?>)new GasStack((IGasProvider)gas.getValue(), 1000L), fluid));
        }
        for (Map.Entry slurry : MekanismAPI.slurryRegistry().getEntries()) {
            fluid = MekChemicalConversionRecipe.getFluidBySlurry((Slurry)slurry.getValue());
            if (fluid.isEmpty()) continue;
            recipes.add(new MekChemicalConversionRecipe((ChemicalStack<?>)new SlurryStack((ISlurryProvider)slurry.getValue(), 1000L), fluid));
        }
        return recipes;
    }

    @Override
    @NotNull
    public String m_6076_() {
        return "mek_chemical_conversion";
    }

    @Override
    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Items.f_42446_);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        if (this.m_142505_()) {
            return;
        }
        buffer.writeDouble(this.rarityModifier);
    }

    public static class Type
    extends MekChemicalConversionRecipe {
        public Type() {
            super(NuclearCraft.rl("mek_chemical"), new ItemStackIngredient[0], new ItemStackIngredient[0], new FluidStackIngredient[0], new FluidStackIngredient[0], 1.0, 1.0, 1.0, 1.0);
        }
    }
}

