/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class BoilingRecipeSerializer<RECIPE extends NcRecipe>
extends NcRecipeSerializer<RECIPE> {
    public BoilingRecipeSerializer(NcRecipeSerializer.IFactory factory) {
        super(factory);
    }

    @Override
    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        int i;
        this.inputFluids = new FluidStackIngredient[0];
        try {
            if (json.has("inputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"inputFluids")) {
                    JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"inputFluids");
                    this.inputFluids = new FluidStackIngredient[input.getAsJsonArray().size()];
                    i = 0;
                    for (JsonElement in : input.getAsJsonArray()) {
                        this.inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize(in);
                        ++i;
                    }
                } else {
                    JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"inputFluids");
                    this.inputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)inputJson)};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse input fluid for recipe: " + recipeId);
        }
        this.outputFluids = new FluidStackIngredient[0];
        try {
            if (json.has("outputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"outputFluids")) {
                    output = GsonHelper.m_13933_((JsonObject)json, (String)"outputFluids");
                    this.outputFluids = new FluidStackIngredient[output.getAsJsonArray().size()];
                    i = 0;
                    for (JsonElement out : output.getAsJsonArray()) {
                        this.outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)out.getAsJsonObject());
                        ++i;
                    }
                } else {
                    output = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluids");
                    this.outputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)output.getAsJsonObject())};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse output fluid for recipe: " + recipeId);
        }
        double heatRequired = 1.0;
        try {
            heatRequired = GsonHelper.m_144742_((JsonObject)json, (String)"heatRequired", (double)1.0);
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse params for recipe: " + recipeId);
        }
        return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], this.inputFluids, this.outputFluids, heatRequired, 1.0, 1.0, 1.0);
    }

    @Override
    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            boolean isIncomplete = buffer.readBoolean();
            if (isIncomplete) {
                return this.emptyRecipe(recipeId);
            }
            this.readIngredients(buffer);
            double heatRequired = buffer.readDouble();
            double powerModifier = buffer.readDouble();
            double radiation = buffer.readDouble();
            return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], this.inputFluids, this.outputFluids, heatRequired, 1.0, 1.0, 1.0);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("NC fromNetwork recipe error: " + recipeId);
            throw e;
        }
    }
}

