/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.turbine;

import igentuman.nc.block.entity.turbine.TurbineBE;
import igentuman.nc.block.entity.turbine.TurbineBladeBE;
import igentuman.nc.block.entity.turbine.TurbineCoilBE;
import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.block.entity.turbine.TurbinePortBE;
import igentuman.nc.block.entity.turbine.TurbineRotorBE;
import igentuman.nc.block.turbine.TurbineBearingBlock;
import igentuman.nc.block.turbine.TurbineBladeBlock;
import igentuman.nc.block.turbine.TurbineBlock;
import igentuman.nc.block.turbine.TurbineCoilBlock;
import igentuman.nc.block.turbine.TurbineControllerBlock;
import igentuman.nc.block.turbine.TurbinePortBlock;
import igentuman.nc.block.turbine.TurbineRotorBlock;
import igentuman.nc.container.TurbineControllerContainer;
import igentuman.nc.container.TurbinePortContainer;
import igentuman.nc.multiblock.turbine.BladeDef;
import igentuman.nc.multiblock.turbine.CoilDef;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class TurbineRegistration {
    public static final Item.Properties TURBINE_ITEM_PROPS = new Item.Properties();
    public static final BlockBehaviour.Properties TURBINE_BLOCKS_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_();
    public static final BlockBehaviour.Properties GLASS_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_();
    public static HashMap<String, RegistryObject<Block>> TURBINE_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<BlockEntityType<? extends TurbineBE>>> TURBINE_BE = new HashMap();
    public static HashMap<String, RegistryObject<BlockItem>> TURBINE_BLOCK_ITEMS = new HashMap();
    public static TagKey<Block> CASING_BLOCKS = Tags.blockTag("turbine_casing");
    public static TagKey<Block> INNER_TURBINE_BLOCKS = Tags.blockTag("turbine_inner");
    public static final HashMap<String, BladeDef> blades = TurbineRegistration.blades();
    public static final HashMap<String, CoilDef> coils = TurbineRegistration.coils();
    private static HashMap<String, Double> efficiency;
    public static final RegistryObject<MenuType<TurbineControllerContainer>> TURBINE_CONTROLLER_CONTAINER;
    public static final RegistryObject<MenuType<TurbinePortContainer>> TURBINE_PORT_CONTAINER;

    public static HashMap<String, BladeDef> blades() {
        if (blades != null) {
            return blades;
        }
        HashMap<String, BladeDef> tmp = new HashMap<String, BladeDef>();
        tmp.put("basic_rotor_blade", new BladeDef("basic", 95.0, 120.0));
        tmp.put("steel_rotor_blade", new BladeDef("steel", 100.0, 140.0));
        tmp.put("extreme_rotor_blade", new BladeDef("extreme", 110.0, 160.0));
        tmp.put("sic_sic_cmc_rotor_blade", new BladeDef("sic_sic_cmc", 125.0, 180.0));
        return tmp;
    }

    public static HashMap<String, CoilDef> coils() {
        if (coils != null) {
            return coils;
        }
        HashMap<String, CoilDef> tmp = new HashMap<String, CoilDef>();
        tmp.put("copper", new CoilDef("copper", 110, "turbine_gold_coil"));
        tmp.put("magnesium", new CoilDef("magnesium", 86, "turbine_bearing"));
        tmp.put("silver", new CoilDef("silver", 112, "turbine_magnesium_coil", "turbine_gold_coil"));
        tmp.put("gold", new CoilDef("gold", 104, "turbine_beryllium_coil"));
        tmp.put("beryllium", new CoilDef("beryllium", 90, "turbine_magnesium_coil"));
        tmp.put("aluminium", new CoilDef("aluminium", 98, "turbine_gold_coil|turbine_magnesium_coil|turbine_beryllium_coil|turbine_gold_coil|turbine_copper_coil"));
        return tmp;
    }

    public static void init() {
        TurbineRegistration.blocks();
    }

    public static RegistryObject<Block> addBlock(String name, Supplier<? extends Block> block) {
        TURBINE_BLOCKS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name, block));
        TURBINE_BLOCK_ITEMS.put(name, (RegistryObject<BlockItem>)Registries.ITEMS.register(name, () -> new BlockItem((Block)TURBINE_BLOCKS.get(name).get(), TURBINE_ITEM_PROPS)));
        return TURBINE_BLOCKS.get(name);
    }

    public static void blocks() {
        String key;
        RegistryObject<Block> controller = TurbineRegistration.addBlock("turbine_controller", () -> new TurbineControllerBlock(TURBINE_BLOCKS_PROPERTIES));
        TURBINE_BE.put("turbine_controller", (RegistryObject<BlockEntityType<? extends TurbineBE>>)Registries.BLOCK_ENTITIES.register("turbine_controller", () -> BlockEntityType.Builder.m_155273_(TurbineControllerBE::new, (Block[])new Block[]{(Block)controller.get()}).m_58966_(null)));
        RegistryObject<Block> port = TurbineRegistration.addBlock("turbine_port", () -> new TurbinePortBlock(TURBINE_BLOCKS_PROPERTIES));
        TURBINE_BE.put("turbine_port", (RegistryObject<BlockEntityType<? extends TurbineBE>>)Registries.BLOCK_ENTITIES.register("turbine_port", () -> BlockEntityType.Builder.m_155273_(TurbinePortBE::new, (Block[])new Block[]{(Block)port.get()}).m_58966_(null)));
        RegistryObject<Block> rotor = TurbineRegistration.addBlock("turbine_rotor_shaft", () -> new TurbineRotorBlock(GLASS_BLOCK_PROPERTIES));
        TURBINE_BE.put("turbine_rotor_shaft", (RegistryObject<BlockEntityType<? extends TurbineBE>>)Registries.BLOCK_ENTITIES.register("turbine_rotor_shaft", () -> BlockEntityType.Builder.m_155273_(TurbineRotorBE::new, (Block[])new Block[]{(Block)rotor.get()}).m_58966_(null)));
        TurbineRegistration.addBlock("turbine_bearing", () -> new TurbineBearingBlock(TURBINE_BLOCKS_PROPERTIES));
        TurbineRegistration.addBlock("turbine_glass", () -> new TurbineBlock(GLASS_BLOCK_PROPERTIES));
        TurbineRegistration.addBlock("turbine_casing", () -> new TurbineBlock(TURBINE_BLOCKS_PROPERTIES));
        for (String block : TurbineRegistration.blades().keySet()) {
            key = "turbine_" + block;
            TurbineRegistration.addBlock(key, () -> new TurbineBladeBlock(TURBINE_BLOCKS_PROPERTIES));
        }
        TURBINE_BE.put("turbine_blade", (RegistryObject<BlockEntityType<? extends TurbineBE>>)Registries.BLOCK_ENTITIES.register("turbine_blade", () -> BlockEntityType.Builder.m_155273_(TurbineBladeBE::new, (Block[])TurbineRegistration.getBladeBlocks()).m_58966_(null)));
        for (String block : TurbineRegistration.coils().keySet()) {
            key = "turbine_" + block + "_coil";
            TurbineRegistration.addBlock(key, () -> new TurbineCoilBlock(TURBINE_BLOCKS_PROPERTIES));
        }
        TURBINE_BE.put("turbine_coil", (RegistryObject<BlockEntityType<? extends TurbineBE>>)Registries.BLOCK_ENTITIES.register("turbine_coil", () -> BlockEntityType.Builder.m_155273_(TurbineCoilBE::new, (Block[])TurbineRegistration.getCoilBlocks()).m_58966_(null)));
    }

    public static Block[] getCoilBlocks() {
        Block[] blocks = new Block[TurbineRegistration.coils().size()];
        int i = 0;
        for (String block : TurbineRegistration.coils().keySet()) {
            String key = "turbine_" + block + "_coil";
            blocks[i] = (Block)TURBINE_BLOCKS.get(key).get();
            ++i;
        }
        return blocks;
    }

    public static Block[] getBladeBlocks() {
        Block[] blocks = new Block[4];
        int i = 0;
        for (String name : TURBINE_BLOCKS.keySet()) {
            if (!name.contains("blade")) continue;
            blocks[i] = (Block)TURBINE_BLOCKS.get(name).get();
            ++i;
        }
        return blocks;
    }

    public static List<String> initialPlacementRules(String name) {
        return List.of(TurbineRegistration.coils().get((Object)name).rules);
    }

    public static HashMap<String, Double> initialEfficiency() {
        if (efficiency == null) {
            efficiency = new HashMap();
            for (String name : TurbineRegistration.coils().keySet()) {
                if (name.contains("empty")) continue;
                efficiency.put(name, TurbineRegistration.coils().get((Object)name).efficiency);
            }
        }
        return efficiency;
    }

    static {
        TURBINE_CONTROLLER_CONTAINER = Registries.CONTAINERS.register("turbine_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new TurbineControllerContainer(windowId, data.m_130135_(), inv)));
        TURBINE_PORT_CONTAINER = Registries.CONTAINERS.register("turbine_port", () -> IForgeMenuType.create((windowId, inv, data) -> new TurbinePortContainer(windowId, data.m_130135_(), inv)));
    }
}

