/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fusion;

import igentuman.nc.block.ElectromagnetBlock;
import igentuman.nc.block.RFAmplifierBlock;
import igentuman.nc.block.entity.fusion.FusionCoreBE;
import igentuman.nc.block.fusion.MultiblockConnectorBlock;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.fusion.FusionReactorController;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.TagUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FusionReactorMultiblock
extends AbstractNCMultiblock {
    public int magnetsEfficiency = 0;
    public int rfEfficiency = 0;
    protected FusionCoreBE<?> controllerBE;
    protected int length = 0;
    public double magneticFieldStrength = 0.0;
    public int magnetsPower = 0;
    public int maxMagnetsTemp = 0;
    public int rfAmplification = 0;
    public int rfAmplifiersPower = 0;
    public int maxRFAmplifiersTemp = 0;
    protected boolean connectorsValid = false;
    protected boolean ringValid = false;
    protected boolean needToCollectFunctionalBlocks = true;
    public boolean needToRecalculateCharacteristics = true;
    protected HashMap<BlockPos, ElectromagnetBlock> electromagnets = new HashMap();
    protected HashMap<BlockPos, RFAmplifierBlock> amplifiers = new HashMap();

    public boolean isReadyToProcess() {
        return this.isFormed && this.outerValid && this.innerValid && !this.needToRecalculateCharacteristics && !this.needToCollectFunctionalBlocks;
    }

    public FusionReactorMultiblock(FusionCoreBE<?> core) {
        super(TagUtil.getBlocksByTagKey(FusionReactor.CASING_BLOCKS.f_203868_().toString()), List.of(Blocks.f_50016_));
        this.controllerBE = core;
        this.id = "fusion_reactor_" + this.controllerBE.m_58899_().m_123344_();
        MultiblockHandler.addMultiblock(this);
        this.controller = new FusionReactorController(this.controllerBE);
    }

    @Override
    public int height() {
        return 3;
    }

    @Override
    public int width() {
        return this.length;
    }

    @Override
    public int depth() {
        return this.length;
    }

    @Override
    public int maxHeight() {
        return 3;
    }

    @Override
    public int minHeight() {
        return 3;
    }

    @Override
    public int maxWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public final List<Block> validOuterBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public List<Block> validInnerBlocks() {
        return this.validInnerBlocks;
    }

    @Override
    public void validateOuter() {
        this.validateConnectors();
        this.validateRing();
        boolean bl = this.outerValid = this.ringValid && this.connectorsValid;
        if (this.outerValid) {
            this.validationResult = ValidationResult.VALID;
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.needToCollectFunctionalBlocks = this.isFormed;
    }

    @Override
    public void onBlockDestroyed(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (this.controllerBE.plasmaTemperature > 100000L) {
            // empty if block
        }
        this.controller.clearStats();
    }

    private Block getBlock(BlockPos pos) {
        if (this.level() == null) {
            return Blocks.f_50016_;
        }
        return this.level().m_8055_(pos).m_60734_();
    }

    private void processFunctionalBlock(NCBlockPos pos) {
        Block block = this.getBlock(pos);
        if (block instanceof ElectromagnetBlock) {
            ElectromagnetBlock magnet = (ElectromagnetBlock)block;
            this.electromagnets.put(pos.copy(), magnet);
            this.allBlocks.add(pos.copy());
            this.updateDimensions(pos);
        } else {
            block = this.getBlock(pos);
            if (block instanceof RFAmplifierBlock) {
                RFAmplifierBlock amplifier = (RFAmplifierBlock)block;
                this.amplifiers.put(pos.copy(), amplifier);
                this.allBlocks.add(pos.copy());
                this.updateDimensions(pos);
            }
        }
    }

    public void collectFunctionalParts() {
        this.electromagnets.clear();
        this.amplifiers.clear();
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_());
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            NCBlockPos startPosInnerWall = null;
            NCBlockPos startPosOuterWall = null;
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                }
            }
            if (startPosInnerWall == null || startPosOuterWall == null) {
                return;
            }
            for (i = 0; i < steps; ++i) {
                this.processFunctionalBlock(startPosInnerWall.revert().relative(dir, i));
                this.processFunctionalBlock(startPosInnerWall.revert().relative(Direction.UP, 2).relative(dir, i));
            }
            for (i = 0; i < steps + 2; ++i) {
                this.processFunctionalBlock(startPosOuterWall.revert().relative(dir, i));
                this.processFunctionalBlock(startPosOuterWall.revert().relative(Direction.UP, 2).relative(dir, i));
            }
        }
    }

    private void validateRing() {
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.ringValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            NCBlockPos startPosInnerWall = null;
            NCBlockPos startPosOuterWall = null;
            NCBlockPos startPosBottomWall = null;
            NCBlockPos startPosTopWall = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.UP));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.UP));
                }
            }
            for (i = 0; i < steps; ++i) {
                assert (startPosInnerWall != null);
                if (!this.isValidForOuter(startPosInnerWall.revert().relative(dir, i))) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosInnerWall);
                    return;
                }
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosInnerWall));
            }
            for (i = 0; i < steps + 2; ++i) {
                assert (startPosOuterWall != null);
                if (!this.isValidForOuter(startPosOuterWall.revert().relative(dir, i))) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosOuterWall);
                    return;
                }
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosOuterWall));
                assert (startPosBottomWall != null);
                if (!this.isValidForOuter(startPosBottomWall.revert().relative(dir, i))) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosBottomWall);
                    return;
                }
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosBottomWall));
                assert (startPosTopWall != null);
                if (!this.isValidForOuter(startPosTopWall.revert().relative(dir, i))) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosTopWall);
                    return;
                }
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosTopWall));
            }
        }
    }

    private void validateConnectors() {
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_7494_());
        this.length = 1;
        this.connectorsValid = true;
        for (int i = 2; i <= this.maxWidth() / 2 + 1; ++i) {
            int connectors = 0;
            for (Direction side : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (!(this.getBlockState(pos.revert().relative(side, i)).m_60734_() instanceof MultiblockConnectorBlock)) continue;
                this.allBlocks.add(new NCBlockPos((Vec3i)pos));
                ++connectors;
            }
            if (connectors == 4) {
                ++this.length;
                continue;
            }
            if (connectors != 0) {
                this.connectorsValid = false;
            } else {
                this.connectorsValid = true;
                this.validationResult = ValidationResult.INCOMPLETE;
                this.controller().addErroredBlock(pos);
            }
            return;
        }
    }

    @Override
    public void validateInner() {
        if (!this.outerValid) {
            return;
        }
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.innerValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 2;
            NCBlockPos innerRingStartPos = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                }
            }
            for (int i = 0; i < steps; ++i) {
                assert (innerRingStartPos != null);
                if (this.processInnerBlock(innerRingStartPos.revert().relative(dir, i))) continue;
                this.innerValid = false;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.controller().addErroredBlock(innerRingStartPos);
                return;
            }
        }
        this.validationResult = ValidationResult.VALID;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        return this.validInnerBlocks.contains(this.level().m_8055_(toCheck).m_60734_());
    }

    private Level level() {
        if (this.controllerBE == null) {
            return null;
        }
        return this.controllerBE.m_58904_();
    }

    @Override
    public void invalidateStats() {
        this.length = 0;
        this.controller().clearStats();
        this.isFormed = false;
        this.hasToRefresh = true;
    }

    @Override
    protected Direction getFacing() {
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isFormed) {
            if (this.needToCollectFunctionalBlocks) {
                this.collectFunctionalParts();
                this.needToCollectFunctionalBlocks = false;
                this.needToRecalculateCharacteristics = true;
            } else if (this.needToRecalculateCharacteristics) {
                this.recalculateCharacteristics();
                this.needToRecalculateCharacteristics = false;
            }
        }
    }

    public void recalculateCharacteristics() {
        this.magneticFieldStrength = 0.0;
        this.magnetsPower = 0;
        this.maxMagnetsTemp = 1000000;
        this.rfAmplification = 0;
        this.rfAmplifiersPower = 0;
        this.maxRFAmplifiersTemp = 1000000;
        double mEfficiency = 0.0;
        double rEfficiency = 0.0;
        for (ElectromagnetBlock magnet : this.electromagnets.values()) {
            this.magneticFieldStrength += magnet.getStrength();
            mEfficiency += (double)((int)magnet.getEfficiency());
            this.magnetsPower += magnet.getPower();
            if (magnet.getMaxTemperature() >= this.maxMagnetsTemp) continue;
            this.maxMagnetsTemp = magnet.getMaxTemperature();
        }
        this.magnetsEfficiency = (int)(mEfficiency / (double)this.electromagnets.size());
        for (RFAmplifierBlock amplifier : this.amplifiers.values()) {
            this.rfAmplification += amplifier.getAmplification();
            this.rfAmplifiersPower += amplifier.getPower();
            rEfficiency += (double)((int)amplifier.getEfficiency());
            if (amplifier.getMaxTemperature() >= this.maxRFAmplifiersTemp) continue;
            this.maxRFAmplifiersTemp = amplifier.getMaxTemperature();
        }
        this.rfEfficiency = (int)(rEfficiency / (double)this.amplifiers.size());
    }

    @Override
    public void onNeighborChange(BlockState state, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, pos, neighbor);
        if (!this.hasToRefresh && this.componentChanged(neighbor)) {
            this.needToCollectFunctionalBlocks = true;
        }
    }

    private boolean componentChanged(BlockPos neighbor) {
        if (this.electromagnets.containsKey(neighbor) || this.amplifiers.containsKey(neighbor)) {
            return true;
        }
        Block changedBlock = this.level().m_8055_(neighbor).m_60734_();
        return changedBlock instanceof ElectromagnetBlock || changedBlock instanceof RFAmplifierBlock;
    }
}

