/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.fission.FissionCasingBlock;
import igentuman.nc.block.fission.FissionFuelCellBlock;
import igentuman.nc.block.fission.HeatSinkBlock;
import igentuman.nc.block.fission.IrradiationChamberBlock;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.event.server.WorldEvents;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.multiblock.fission.FissionReactorController;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.TagUtil;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FissionReactorMultiblock
extends AbstractNCMultiblock {
    private int irradiationConnections = 0;
    private final List<Block> validModerators;
    public HashMap<BlockPos, HeatSinkBlock> validHeatSinks = new HashMap();
    private List<BlockPos> moderators = new ArrayList<BlockPos>();
    private List<BlockPos> irradiators = new ArrayList<BlockPos>();
    public List<BlockPos> heatSinks = new ArrayList<BlockPos>();
    public List<BlockPos> fuelCells = new ArrayList<BlockPos>();
    private double heatSinkCooling = 0.0;
    public double activeCooling = 0.0;
    private FissionControllerBE<?> controllerBe;
    private List<BlockPos> directFuelCellConnectionPos = new ArrayList<BlockPos>();
    private List<BlockPos> secondFuelCellConnectionPos = new ArrayList<BlockPos>();
    public HashMap<String, Integer> coolantPerTick = new HashMap();

    @Override
    public int maxHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    public FissionReactorMultiblock(FissionControllerBE<?> fissionControllerBE) {
        super(TagUtil.getBlocksByTagKey(FissionBlocks.CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(FissionBlocks.INNER_REACTOR_BLOCKS.f_203868_().toString()));
        this.id = "fission_reactor_" + fissionControllerBE.m_58899_().m_123344_();
        this.validModerators = TagUtil.getBlocksByTagKey(FissionBlocks.MODERATORS_BLOCKS.f_203868_().toString());
        for (Block b : this.validModerators) {
            if (WorldEvents.trackingBlocks.contains(b)) continue;
            WorldEvents.trackingBlocks.add(b);
        }
        for (Block b : this.validOuterBlocks()) {
            if (b instanceof FissionCasingBlock || WorldEvents.trackingBlocks.contains(b)) continue;
            WorldEvents.trackingBlocks.add(b);
        }
        MultiblockHandler.addMultiblock(this);
        this.controller = new FissionReactorController(fissionControllerBE);
        this.controllerBe = fissionControllerBE;
    }

    public Map<BlockPos, HeatSinkBlock> validHeatSinks() {
        if (this.validHeatSinks.isEmpty()) {
            for (BlockPos hpos : this.heatSinks) {
                HeatSinkBlock hs;
                Block block = this.getBlockState(hpos).m_60734_();
                if (!(block instanceof HeatSinkBlock) || !(hs = (HeatSinkBlock)block).isValid(this.getLevel(), hpos)) continue;
                this.validHeatSinks.put(hpos, hs);
                if (!hs.isActive()) continue;
                this.addActiveCoolant(hs.def.name.replace("active_", ""));
            }
        }
        this.controllerBE().heatSinksCount = this.validHeatSinks.size();
        return this.validHeatSinks;
    }

    private void addActiveCoolant(String name) {
        if (!this.coolantPerTick.containsKey(name)) {
            this.coolantPerTick.put(name, 0);
        }
        this.coolantPerTick.replace(name, this.coolantPerTick.get(name) + (Integer)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_COOLANT_PER_TICK.get());
    }

    @Override
    public void tick() {
        super.tick();
        this.tickActiveHeatSinks();
    }

    private void tickActiveHeatSinks() {
        this.activeCooling = 0.0;
        for (String coolant : this.coolantPerTick.keySet()) {
            int amount = this.coolantPerTick.get(coolant);
            if (amount == 0) continue;
            if (!this.controllerBE().hasEnoughCoolant(coolant, amount)) {
                this.activeCooling -= this.getCoolingByCoolant(coolant, amount);
                continue;
            }
            this.controllerBE().drainCoolant(coolant, amount);
        }
        this.controllerBE().activeCooling = this.activeCooling;
    }

    private double getCoolingByCoolant(String coolant, int amount) {
        if (!FissionBlocks.heatsinks.containsKey("active_" + coolant)) {
            return 0.0;
        }
        int mbPerTick = (Integer)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_COOLANT_PER_TICK.get();
        FissionBlocks.heatsinks.get("active_" + coolant);
        return (double)amount / (double)mbPerTick * FissionBlocks.heatsinks.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"active_\u0001"}, (String)coolant)).heat;
    }

    public boolean isModerator(BlockPos pos, Level level) {
        return this.validModerators.contains(level.m_8055_(pos).m_60734_());
    }

    public boolean isModerator(BlockPos pos) {
        return this.validModerators.contains(this.getBlockState(pos).m_60734_());
    }

    public boolean isIrradiator(BlockPos pos) {
        return this.getBlockState(pos).m_60734_() instanceof IrradiationChamberBlock;
    }

    protected boolean isHeatSink(BlockPos pos) {
        return this.getBlockState(pos).m_60734_() instanceof HeatSinkBlock;
    }

    protected boolean isFuelCell(BlockPos pos) {
        return this.getBlockState(pos).m_60734_() instanceof FissionFuelCellBlock;
    }

    private void addIfNotExists(BlockPos pos, List<BlockPos> list) {
        if (!list.contains(pos)) {
            list.add(pos);
        }
    }

    private boolean isAttachedToFuelCell(BlockPos toCheck) {
        if (this.directFuelCellConnectionPos.contains(toCheck)) {
            return true;
        }
        if (this.secondFuelCellConnectionPos.contains(toCheck)) {
            return true;
        }
        for (Direction d : Direction.values()) {
            if (this.isFuelCell(toCheck.m_121945_(d))) {
                this.addDirectFuelCellConnection(toCheck.m_121945_(d));
                return true;
            }
            if (this.directFuelCellConnectionPos.contains(toCheck)) {
                return true;
            }
            if (!this.secondFuelCellConnectionPos.contains(toCheck)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateInner() {
        this.invalidateStats();
        if (!this.outerValid) {
            return;
        }
        this.resolveDimensions();
        this.collectFuelCells();
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                for (int z = 1; z < this.depth - 1; ++z) {
                    NCBlockPos toCheck = new NCBlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                    if (!this.isValidForInner(toCheck)) {
                        this.validationResult = ValidationResult.WRONG_INNER;
                        this.controller().addErroredBlock(new BlockPos((Vec3i)toCheck));
                        return;
                    }
                    this.processInnerBlock(new BlockPos((Vec3i)toCheck));
                }
            }
        }
        this.validationResult = ValidationResult.VALID;
        this.heatSinkCooling = this.countCooling(true);
        this.controllerBE().moderatorsCount = this.moderators.size();
        this.controllerBE().irradiationConnections = this.irradiationConnections;
    }

    private void collectFuelCells() {
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                for (int z = 1; z < this.depth - 1; ++z) {
                    NCBlockPos toCheck = new NCBlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                    if (!this.isFuelCell(toCheck)) continue;
                    this.addDirectFuelCellConnection(new BlockPos((Vec3i)toCheck));
                    this.addIfNotExists(new BlockPos((Vec3i)toCheck), this.fuelCells);
                    int moderatorAttachments = this.countAttachedModeratorsToFuelCell(new BlockPos((Vec3i)toCheck));
                    this.controllerBE().fuelCellMultiplier += this.countAdjacentFuelCells(NCBlockPos.of(toCheck), 3);
                    this.controllerBE().moderatorCellMultiplier += (this.countAdjacentFuelCells(NCBlockPos.of(toCheck), 1) + 1) * moderatorAttachments;
                    this.controllerBE().moderatorAttachments += moderatorAttachments;
                }
            }
        }
        this.controllerBE().fuelCellsCount = this.fuelCells.size();
    }

    private FissionControllerBE<?> controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = (FissionControllerBE)this.controller().controllerBE();
        }
        return this.controllerBe;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        if (this.isFuelCell(toCheck)) {
            return true;
        }
        if (this.isModerator(toCheck)) {
            return true;
        }
        if (this.isHeatSink(toCheck) && this.isAttachedToFuelCell(toCheck)) {
            this.addIfNotExists(new BlockPos((Vec3i)toCheck), this.heatSinks);
            this.addSecondConnectionsToFuelCell(new BlockPos((Vec3i)toCheck));
            return true;
        }
        if (this.isIrradiator(toCheck)) {
            this.addIfNotExists(new BlockPos((Vec3i)toCheck), this.irradiators);
            this.countIrradiationConnections(toCheck);
            return true;
        }
        return true;
    }

    private void addSecondConnectionsToFuelCell(BlockPos toCheck) {
        this.addIfNotExists(toCheck, this.secondFuelCellConnectionPos);
        for (Direction d : Direction.values()) {
            this.addIfNotExists(toCheck.m_121945_(d), this.secondFuelCellConnectionPos);
        }
    }

    private void addDirectFuelCellConnection(BlockPos toCheck) {
        this.addIfNotExists(toCheck, this.directFuelCellConnectionPos);
        for (Direction d : Direction.values()) {
            this.addIfNotExists(toCheck.m_121945_(d), this.directFuelCellConnectionPos);
        }
    }

    @Override
    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        if (this.getBottomLeftBlock().m_123341_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123342_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123343_() >= pos.m_123343_() && this.getTopRightBlock().m_123341_() <= pos.m_123341_() && this.getTopRightBlock().m_123342_() <= pos.m_123342_() && this.getTopRightBlock().m_123343_() <= pos.m_123343_() && !this.allBlocks.contains(pos)) {
            return false;
        }
        if (toCheck.equals(FissionFuelCellBlock.class)) {
            return this.directFuelCellConnectionPos.contains(pos) || this.secondFuelCellConnectionPos.contains(pos);
        }
        return false;
    }

    private int countAttachedModeratorsToFuelCell(BlockPos toCheck) {
        int count = 0;
        for (Direction d : Direction.values()) {
            if (!this.isModerator(toCheck.m_121945_(d))) continue;
            this.addIfNotExists(new BlockPos((Vec3i)toCheck.m_121945_(d)), this.moderators);
            this.addSecondConnectionsToFuelCell(new BlockPos((Vec3i)toCheck.m_121945_(d)));
            ++count;
        }
        return count;
    }

    private void countIrradiationConnections(BlockPos toCheck) {
        for (Direction d : Direction.values()) {
            Block bs;
            if (!this.isModerator(toCheck.m_121945_(d)) || !((bs = this.getBlockState(toCheck.m_5484_(d, 2)).m_60734_()) instanceof FissionFuelCellBlock)) continue;
            ++this.irradiationConnections;
        }
    }

    private int countAdjacentFuelCells(NCBlockPos toCheck, int step) {
        int count = 0;
        for (Direction d : Direction.values()) {
            if (this.isFuelCell(toCheck.revert().relative(d))) {
                count += step;
                continue;
            }
            if (!this.isModerator(toCheck.revert().relative(d)) || !this.isFuelCell(toCheck.revert().relative(d, 2))) continue;
            count += step;
        }
        return count;
    }

    @Override
    public void invalidateStats() {
        this.controller().clearStats();
        this.moderators.clear();
        this.irradiators.clear();
        this.fuelCells.clear();
        this.heatSinks.clear();
        this.validHeatSinks.clear();
        this.coolantPerTick.clear();
        this.directFuelCellConnectionPos.clear();
        this.secondFuelCellConnectionPos.clear();
        this.irradiationConnections = 0;
    }

    @Override
    protected Direction getFacing() {
        return this.controllerBE().getFacing();
    }

    public double countCooling(boolean forceCheck) {
        if (this.refreshInnerCacheFlag || forceCheck) {
            this.heatSinkCooling = 0.0;
            for (HeatSinkBlock hs : this.validHeatSinks().values()) {
                if (hs.isActive()) {
                    // empty if block
                }
                this.heatSinkCooling += hs.heat;
            }
        }
        return this.heatSinkCooling;
    }
}

