/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.AbstractCapabilityHandler;
import igentuman.nc.handler.sided.capability.ItemHandlerWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemCapabilityHandler
extends AbstractCapabilityHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    public List<ItemStack> allowedInputItems;
    public HashMap<Integer, List<Item>> validItemsForSlot = new HashMap();
    protected NonNullList<ItemStack> stacks;
    protected ItemStack[] sortedStacks;
    private Map<Direction, LazyOptional<ItemHandlerWrapper>> handlerCache = new HashMap<Direction, LazyOptional<ItemHandlerWrapper>>();
    public List<ItemStack> holdedInputs = new ArrayList<ItemStack>();
    LazyOptional<ItemHandlerWrapper> globalCap;

    public ItemCapabilityHandler(int input, int output) {
        this.inputSlots = input;
        this.outputSlots = output;
        this.stacks = NonNullList.m_122780_((int)(input + output), (Object)ItemStack.f_41583_);
        this.initDefault();
    }

    @Override
    public int toggleMode(int slot, int side) {
        this.cleanCache();
        return super.toggleMode(slot, side);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        try {
            this.validateSlotIndex(slot);
        }
        catch (Exception ignored) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.getType(slot).equals((Object)SidedContentHandler.SlotType.OUTPUT)) {
            return stack;
        }
        return this.insertItemInternal(slot, stack, simulate);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    private int isValidForAnyInputSlot(ItemStack stack) {
        for (int i = 0; i < this.inputSlots; ++i) {
            if (!this.isItemValid(i, stack)) continue;
            if (this.getStackInSlot(i).m_41619_()) {
                return i;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(i), (ItemStack)stack) || this.getStackInSlot(i).m_41613_() >= this.getSlotLimit(i)) continue;
            return i;
        }
        return -1;
    }

    private int isValidForAnyOutputSlot(ItemStack stack) {
        for (int i = this.inputSlots; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            if (this.getStackInSlot(i).m_41619_()) {
                return i;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(i), (ItemStack)stack) || this.getStackInSlot(i).m_41613_() >= this.getSlotLimit(i)) continue;
            return i;
        }
        return -1;
    }

    private int getNextSlot(int currentSlot) {
        for (int i = currentSlot; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return 0;
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.stacks.size());
        if (this.sideMapUpdated) {
            this.sideMapUpdated = false;
            nbt.m_128365_("sideMap", SidedContentHandler.serializeSideMap(this.sideMap));
        }
        return nbt;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        if (!nbt.m_128469_("sideMap").m_128456_()) {
            this.sideMap = SidedContentHandler.deserializeSideMap(nbt.m_128469_("sideMap"));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onContentsChanged(int slot) {
        if (slot > this.inputSlots - 1) {
            this.sortedStacks = null;
        }
    }

    public LazyOptional<ItemHandlerWrapper> getCapability(Direction side) {
        if (side == null) {
            return this.globalCap();
        }
        if (!this.handlerCache.containsKey(side)) {
            this.handlerCache.put(side, (LazyOptional<ItemHandlerWrapper>)LazyOptional.of(() -> new ItemHandlerWrapper(side, this, i -> this.outputAllowed((Integer)i, side), (i, s) -> this.inputAllowed((Integer)i, (ItemStack)s, side))));
        }
        return this.handlerCache.get(side);
    }

    private LazyOptional<ItemHandlerWrapper> globalCap() {
        if (this.globalCap == null) {
            this.globalCap = LazyOptional.of(() -> new ItemHandlerWrapper(null, this, i -> true, (i, s) -> true));
        }
        return this.globalCap;
    }

    public void cleanCache() {
        this.handlerCache.clear();
    }

    private boolean outputAllowed(Integer i, Direction side) {
        if (side == null) {
            return true;
        }
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
        SlotModePair.SlotMode mode = ((SlotModePair[])this.sideMap.get(relativeDirection.ordinal()))[i].getMode();
        return mode == SlotModePair.SlotMode.OUTPUT || mode == SlotModePair.SlotMode.PUSH || mode == SlotModePair.SlotMode.PUSH_EXCESS;
    }

    private boolean inputAllowed(Integer i, ItemStack stack, Direction side) {
        boolean validForSlot = true;
        if (this.validItemsForSlot.containsKey(i)) {
            validForSlot = this.validItemsForSlot.get(i).contains(stack.m_41720_());
        }
        if (!validForSlot) {
            return false;
        }
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
        SlotModePair.SlotMode mode = ((SlotModePair[])this.sideMap.get(relativeDirection.ordinal()))[i].getMode();
        return mode == SlotModePair.SlotMode.INPUT || mode == SlotModePair.SlotMode.PULL && this.isValidInputItem(stack);
    }

    public boolean isValidInputItem(ItemStack item) {
        if (this.allowedInputItems == null) {
            return true;
        }
        if (this.allowedInputItems.contains(item)) {
            return true;
        }
        for (ItemStack stack : this.allowedInputItems) {
            if (!stack.m_150930_(item.m_41720_())) continue;
            return true;
        }
        return this.allowedInputItems.isEmpty();
    }

    public boolean pushItems(Direction dir) {
        return this.pushItems(dir, false, this.tile.m_58899_());
    }

    public boolean pushItems(Direction dir, boolean forceFlag, BlockPos pos) {
        BlockEntity be = this.tile.m_58904_().m_7702_(pos.m_121945_(dir));
        if (be == null) {
            return false;
        }
        LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_());
        if (cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                ItemStack remainder;
                ItemStack stack;
                if (pair.getMode() != SlotModePair.SlotMode.PUSH && (!forceFlag || pair.getMode() != SlotModePair.SlotMode.OUTPUT) || (stack = this.getStackInSlot(pair.getSlot())).m_41619_() || (remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).m_41613_() == stack.m_41613_()) continue;
                this.setStackInSlot(pair.getSlot(), remainder);
                return true;
            }
        }
        return false;
    }

    public boolean pullItems(Direction dir) {
        return this.pullItems(dir, false, this.tile.m_58899_());
    }

    public boolean pullItems(Direction dir, boolean forceFlag, BlockPos pos) {
        BlockEntity be = this.tile.m_58904_().m_7702_(pos.m_121945_(dir));
        if (be == null) {
            return false;
        }
        LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_());
        if (!cap.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)cap.orElse(null);
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
        for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
            if (pair.getMode() != SlotModePair.SlotMode.PULL && (!forceFlag || pair.getMode() != SlotModePair.SlotMode.INPUT)) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack remainder;
                ItemStack stack = handler.extractItem(i, 64, true);
                if (stack.m_41619_() || !this.isValidInputItem(stack) || (remainder = this.insertItem(pair.getSlot(), stack.m_41777_(), false)).m_41613_() == stack.m_41613_()) continue;
                handler.extractItem(i, stack.m_41613_() - remainder.m_41613_(), false);
                return true;
            }
        }
        return false;
    }

    public boolean isValidForOutputSlots(ItemStack outputItem) {
        for (int i = this.inputSlots; i < this.getSlots(); ++i) {
            if (!this.isValidForOutputSlot(i, outputItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidForOutputSlot(int i, ItemStack outputItem) {
        if (this.outputAllowed(i, null)) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) {
                return true;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)outputItem)) {
                return true;
            }
        }
        return false;
    }

    public boolean canPushExcessItems(int i, ItemStack outputItem) {
        for (Direction dir : Direction.values()) {
            LazyOptional cap;
            BlockEntity be = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_121945_(dir));
            if (be == null || !(cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())).isPresent()) continue;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                ItemStack remainder;
                if (pair.getSlot() != i || pair.getMode() != SlotModePair.SlotMode.PUSH && pair.getMode() != SlotModePair.SlotMode.PUSH_EXCESS || !(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)outputItem, (boolean)true)).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack pushExcessItems(int i, ItemStack outputItem) {
        for (Direction dir : Direction.values()) {
            LazyOptional cap;
            BlockEntity be = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_121945_(dir));
            if (be == null || !(cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())).isPresent()) continue;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                ItemStack remainder;
                if (pair.getSlot() != i || pair.getMode() != SlotModePair.SlotMode.PUSH || !(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)outputItem, (boolean)true)).m_41619_()) continue;
                return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)outputItem, (boolean)false);
            }
        }
        return outputItem;
    }

    public String getCacheKey() {
        Object key = "";
        if (this.sortedStacks == null) {
            this.sortedStacks = new ItemStack[this.inputSlots];
            for (int i = 0; i < this.inputSlots; ++i) {
                this.sortedStacks[i] = this.getStackInSlot(i);
            }
            Arrays.sort(this.sortedStacks, Comparator.comparing(itemStack -> itemStack.m_41720_().toString()));
        }
        for (ItemStack stack : this.sortedStacks) {
            if (stack.m_41619_()) continue;
            key = (String)key + stack.m_41720_().toString();
        }
        return key;
    }

    public void voidSlot(int i) {
        this.setStackInSlot(i, ItemStack.f_41583_);
    }

    public Object[] getSlotContent(int slotId) {
        ItemStack stack = this.getStackInSlot(slotId);
        if (stack.m_41619_()) {
            return new Object[0];
        }
        return new Object[]{stack.m_41613_(), ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString()};
    }

    public boolean canPush() {
        for (int i = this.inputSlots; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean canPull() {
        for (int i = 0; i < this.inputSlots; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    public void setValidItemsForSlot(List<Item> fuelItems, int slotId) {
        this.validItemsForSlot.put(slotId, fuelItems);
    }
}

