/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen;

import igentuman.nc.datagen.BaseLootTableProvider;
import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import java.util.ArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class NCLootTables
extends BaseLootTableProvider {
    private void ores() {
        for (String ore : NCBlocks.ORE_BLOCKS.keySet()) {
            if (NCItems.NC_CHUNKS.containsKey(ore.replaceAll("_deepslate|_end|_nether", ""))) {
                this.m_246481_((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), block -> this.createSilkTouchTable("ore", (Block)NCBlocks.ORE_BLOCKS.get(ore).get(), (Item)NCItems.NC_CHUNKS.get(ore.replaceAll("_deepslate|_end|_nether", "")).get(), 1.0f, 1.0f));
                continue;
            }
            this.m_246481_((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), block -> this.createSimpleTable("ore", (Block)NCBlocks.ORE_BLOCKS.get(ore).get()));
        }
    }

    private void blocks() {
        for (RegistryObject<Block> block : NCBlocks.NC_BLOCKS.values()) {
            this.add(block);
        }
        for (RegistryObject<Block> block : NCBlocks.NC_MATERIAL_BLOCKS.values()) {
            this.add(block);
        }
        FissionReactor.FISSION_BLOCKS.values().forEach(this::add);
        for (RegistryObject<Block> block : FusionReactor.FUSION_BLOCKS.values()) {
            this.add(block);
        }
        for (RegistryObject<Block> block : TurbineRegistration.TURBINE_BLOCKS.values()) {
            this.add(block);
        }
    }

    private void add(RegistryObject<Block> regBlock) {
        this.m_246481_((Block)regBlock.get(), block -> this.createSimpleTable("block", (Block)regBlock.get()));
    }

    private void machines() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            this.m_246481_((Block)NCProcessors.PROCESSORS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCProcessors.PROCESSORS.get(name).get()));
        }
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            this.m_246481_((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get()));
        }
        for (String name : NCStorageBlocks.STORAGE_BLOCKS.keySet()) {
            this.m_246481_((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get()));
        }
        for (String name : NCBlocks.NC_ELECTROMAGNETS.keySet()) {
            this.m_246481_((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get()));
        }
        for (String name : NCBlocks.NC_RF_AMPLIFIERS.keySet()) {
            this.m_246481_((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get()));
        }
    }

    public void m_245660_() {
        this.ores();
        this.blocks();
        this.machines();
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> all = new ArrayList<Block>();
        all.addAll(NCBlocks.ORE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_MATERIAL_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(FissionReactor.FISSION_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(FusionReactor.FUSION_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(TurbineRegistration.TURBINE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCProcessors.PROCESSORS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCEnergyBlocks.ENERGY_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCStorageBlocks.STORAGE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_ELECTROMAGNETS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_RF_AMPLIFIERS.values().stream().map(RegistryObject::get).toList());
        return all;
    }
}

