/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.fuel;

import com.google.gson.JsonObject;
import igentuman.nc.content.fuel.FuelDef;

public class NCFuel {
    public String group;
    public String name;
    private FuelDef def;
    private FuelDef oxide;
    private FuelDef nitride;
    private FuelDef zirconium;
    private FuelDef triso;

    public static NCFuel of(JsonObject data) {
        FuelDef def = new FuelDef(data.get("group").getAsString(), data.get("name").getAsString(), data.get("forge_energy").getAsInt(), data.get("heat").getAsDouble(), data.get("criticality").getAsInt(), data.get("depletion").getAsInt(), data.get("efficiency").getAsInt());
        def.isotopes(data.get("isotopes").getAsJsonArray().get(0).getAsInt(), data.get("isotopes").getAsJsonArray().get(1).getAsInt());
        return NCFuel.of(def);
    }

    public void setDef(FuelDef def) {
        this.def = def;
    }

    public FuelDef getDefault() {
        return this.def;
    }

    public FuelDef getZirconiumAlloy() {
        if (this.zirconium == null) {
            this.zirconium = new FuelDef(this.group, this.name, (int)((double)this.def.forge_energy * 1.25), Math.ceil(this.oxide.heat * (double)1.1f), (float)this.oxide.criticality / 1.25f, (float)this.oxide.depletion * 1.05f, (float)this.oxide.efficiency / 1.01f).isotopes(this.def.isotopes);
        }
        return this.zirconium;
    }

    public FuelDef getOxide() {
        if (this.oxide == null) {
            this.oxide = new FuelDef(this.group, this.name, (int)((double)this.def.forge_energy * 1.4), this.def.heat * 1.25, (float)this.def.criticality * 1.1f, (float)this.def.depletion / 1.1f, (float)this.def.efficiency / 1.05f).isotopes(this.def.isotopes);
        }
        return this.oxide;
    }

    public FuelDef getNitride() {
        if (this.nitride == null) {
            this.nitride = new FuelDef(this.group, this.name, (int)((double)this.def.forge_energy * 1.6), Math.ceil((double)((float)this.oxide.heat) * 1.5), (double)this.oxide.criticality * 1.25, (double)this.oxide.depletion / 1.25, (double)this.oxide.efficiency / 1.01).isotopes(this.def.isotopes);
        }
        return this.nitride;
    }

    public FuelDef getTriso() {
        if (this.triso == null) {
            this.triso = new FuelDef(this.group, this.name, 0, Math.ceil((double)((float)this.oxide.heat) * 1.5), (double)this.oxide.criticality / 1.5, (double)this.oxide.depletion / 1.25, (double)this.oxide.efficiency * 1.5);
        }
        return this.triso;
    }

    private NCFuel() {
    }

    public static NCFuel of(FuelDef fuelDef) {
        NCFuel f = new NCFuel();
        f.setDef(fuelDef);
        f.name = fuelDef.name;
        f.group = fuelDef.group;
        return f;
    }

    public FuelDef subType(String subType) {
        this.name = this.def.name;
        this.group = this.def.group;
        this.getOxide();
        this.getNitride();
        this.getTriso();
        this.getZirconiumAlloy();
        switch (subType) {
            case "": {
                return this.getDefault();
            }
            case "_ox": {
                return this.getOxide();
            }
            case "_ni": {
                return this.getNitride();
            }
            case "_tr": {
                return this.getTriso();
            }
            case "_za": {
                return this.getZirconiumAlloy();
            }
        }
        return this.getDefault();
    }
}

