/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.container.elements.NCSlotItemHandler;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.content.processors.config.ProcessorSlots;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NCProcessorContainer<T extends AbstractContainerMenu>
extends AbstractContainerMenu {
    protected NCProcessorBE<?> blockEntity;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected ProcessorPrefab<?, ?> processor;
    public int slotIndex = 0;
    protected String name;

    public ProcessorPrefab<?, ?> getProcessor() {
        return this.processor;
    }

    public NCProcessorContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    public NCProcessorContainer(int windowId, BlockPos pos, Inventory playerInventory, Player player, String name) {
        this((MenuType)NCProcessors.PROCESSORS_CONTAINERS.get(name).get(), windowId);
        this.blockEntity = (NCProcessorBE)player.m_20193_().m_7702_(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.name = name;
        this.processor = Processors.all().get(name);
        this.processorSlots();
        this.layoutPlayerInventorySlots();
    }

    protected void addMainSlots() {
        int i = 0;
        int slotIdx = 0;
        ProcessorSlots slots = this.processor.getSlotsConfig();
        for (int[] pos : slots.getSlotPositions()) {
            if (slots.getSlotType(i).contains("item")) {
                int idx = slotIdx;
                if (!this.processor.isSlotHidden(idx + slots.getInputFluids())) {
                    this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                        NCSlotItemHandler slotItemHandler = new NCSlotItemHandler((IItemHandler)h, idx, pos[0], pos[1]);
                        slotItemHandler.allowed(this.blockEntity.getAllowedItems(idx));
                        this.m_38897_((Slot)slotItemHandler);
                    });
                }
                ++slotIdx;
            }
            ++i;
        }
    }

    protected void processorSlots() {
        int idx;
        this.addMainSlots();
        int ux = 154;
        int i = 0;
        if (this.getProcessor().supportEnergyUpgrade) {
            idx = i++;
            this.m_38897_(new NCSlotItemHandler((IItemHandler)this.blockEntity.upgradesHandler, idx, ux, 77).allowed((Item)NCItems.NC_ITEMS.get("upgrade_energy").get()));
            ux -= 18;
        }
        if (this.getProcessor().supportSpeedUpgrade) {
            idx = i;
            this.m_38897_(new NCSlotItemHandler((IItemHandler)this.blockEntity.upgradesHandler, idx, ux, 77).allowed((Item)NCItems.NC_ITEMS.get("upgrade_speed").get()));
            ux -= 18;
        }
        if (this.getProcessor().supportsCatalyst) {
            this.m_38897_((Slot)new NCSlotItemHandler((IItemHandler)this.blockEntity.catalystHandler, 0, ux, 77));
        }
    }

    public int inputSlots() {
        return this.processor.getSlotsConfig().getInputItems();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        int maxSlotId = 36 + this.inputSlots() + this.processor.getSlotsConfig().getOutputItems() + this.processor.getUpgradesSlots() - 1;
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < this.inputSlots()) {
                if (!this.m_38903_(stack, this.inputSlots() + this.processor.getSlotsConfig().getOutputItems(), 37, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < this.inputSlots() + this.processor.getSlotsConfig().getOutputItems() && index > this.inputSlots() - 1) {
                boolean result = this.m_38903_(stack, this.inputSlots() + this.processor.getSlotsConfig().getOutputItems(), maxSlotId, false);
                if (!result) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 28) {
                boolean result = this.handleUpgradesQuickMove(stack);
                if (this.blockEntity.isInputAllowed(stack)) {
                    result = this.m_38903_(stack, 0, this.inputSlots(), false);
                }
                if (!result) {
                    result = this.m_38903_(stack, 28, maxSlotId, false);
                }
                if (!result) {
                    return ItemStack.f_41583_;
                }
            } else if (index < maxSlotId) {
                boolean result = false;
                if (this.blockEntity.isInputAllowed(stack)) {
                    result = this.m_38903_(stack, 0, this.inputSlots(), false);
                }
                if (!result) {
                    result = this.m_38903_(stack, this.inputSlots() + this.processor.getSlotsConfig().getOutputItems(), 28, false);
                }
                if (!result) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return itemstack;
    }

    private boolean handleUpgradesQuickMove(ItemStack stack) {
        if (stack.m_41720_().equals(NCItems.NC_ITEMS.get("upgrade_speed").get()) && this.processor.supportSpeedUpgrade) {
            return this.m_38903_(stack, this.inputSlots() + this.processor.getSlotsConfig().getOutputItems(), 37, true);
        }
        if (stack.m_41720_().equals(NCItems.NC_ITEMS.get("upgrade_energy").get()) && this.processor.supportEnergyUpgrade) {
            int id = 37;
            if (this.processor.supportSpeedUpgrade) {
                ++id;
            }
            return this.m_38903_(stack, this.inputSlots() + this.processor.getSlotsConfig().getOutputItems(), id, true);
        }
        return false;
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 10;
        int topRow = 154;
        this.addSlotRange(this.playerInventory, leftCol, topRow, 9, 18);
        this.addSlotBox(this.playerInventory, leftCol, topRow -= 58, 9, 18, 3, 18);
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return NCProcessorContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(this.blockEntity.m_58904_()), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)NCProcessors.PROCESSORS.get(this.name).get()));
    }

    public Component getTitle() {
        return Component.m_237115_((String)("block.nuclearcraft." + this.name));
    }

    public IEnergyStorage getEnergy() {
        return (IEnergyStorage)this.blockEntity.getEnergy().orElse(null);
    }

    public double getProgress() {
        return this.blockEntity.getProgress();
    }

    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }

    public SlotModePair.SlotMode getSlotMode(int direction, int slotId) {
        return this.blockEntity.getSlotMode(direction, slotId);
    }

    public FluidTank getFluidTank(int i) {
        return this.blockEntity.getFluidTank(i);
    }

    public int speedMultiplier() {
        return this.blockEntity.speedMultiplier;
    }

    public int energyMultiplier() {
        return this.blockEntity.energyMultiplier;
    }

    public int energyPerTick() {
        return this.blockEntity.energyPerTick;
    }

    public int getRedstoneMode() {
        return this.blockEntity.redstoneMode;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

