/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.kubejs;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.compat.kubejs.NCRecipeJS;
import igentuman.nc.recipes.NcRecipeType;

public class NuclearCraftKubeJSPlugin
extends KubeJSPlugin {
    RecipeKey<InputFluid[]> INPUT_FLUIDS = FluidComponents.INPUT_ARRAY.key("inputFluids").defaultOptional();
    RecipeKey<InputItem[]> INPUT_ITEMS = ItemComponents.INPUT_ARRAY.key("input").defaultOptional();
    RecipeKey<OutputItem[]> OUTPUT_ITEMS = ItemComponents.OUTPUT_ARRAY.key("output").defaultOptional();
    RecipeKey<OutputFluid[]> OUTPUT_FLUIDS = FluidComponents.OUTPUT_ARRAY.key("outputFluids").defaultOptional();
    RecipeKey<Double> POWER_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("powerModifier").defaultOptional();
    RecipeKey<Double> TIME_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("timeModifier").defaultOptional();
    RecipeKey<Double> RADIATION_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("radiation").defaultOptional();
    RecipeSchema SCHEMA = new RecipeSchema(NCRecipeJS.class, NCRecipeJS::new, new RecipeKey[]{this.INPUT_ITEMS, this.INPUT_FLUIDS, this.OUTPUT_ITEMS, this.OUTPUT_FLUIDS, this.POWER_MODIFIER, this.TIME_MODIFIER, this.RADIATION_MODIFIER, this.RADIATION_MODIFIER});

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.namespace("nuclearcraft").register(FissionControllerBE.NAME, this.SCHEMA);
        event.namespace("nuclearcraft").register(TurbineControllerBE.NAME, this.SCHEMA);
        event.namespace("nuclearcraft").register("nc_ore_veins", this.SCHEMA);
        event.namespace("nuclearcraft").register("fusion_core", this.SCHEMA);
        event.namespace("nuclearcraft").register("fusion_coolant", this.SCHEMA);
        event.namespace("nuclearcraft").register("fission_boiling", this.SCHEMA);
        event.namespace("nuclearcraft").special("reset_nbt");
        event.namespace("nuclearcraft").special("shielding");
        for (String recipeType : NcRecipeType.ALL_RECIPES.keySet()) {
            event.namespace("nuclearcraft").register(recipeType, this.SCHEMA);
        }
    }

    public void onServerReload() {
        NcRecipeType.invalidateCache();
    }
}

