/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.sound;

import igentuman.nc.client.sound.PlayerSound;
import igentuman.nc.radiation.client.ClientRadiationData;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GeigerSound
extends PlayerSound {
    public int radiationLevel = 0;

    public static GeigerSound create(@NotNull Player player) {
        if (!GeigerSound.playerHasGeigerCounter(player)) {
            return null;
        }
        ClientRadiationData.setCurrentChunk(player.m_146902_().f_45578_, player.m_146902_().f_45579_);
        int level = Math.max(0, Math.min(5, (int)((float)ClientRadiationData.getCurrentWorldRadiation() / 200000.0f)));
        if (level == 0) {
            return null;
        }
        return new GeigerSound(player, level);
    }

    private static boolean playerHasGeigerCounter(Player player) {
        return player.m_150109_().m_36063_(new ItemStack((ItemLike)NCItems.GEIGER_COUNTER.get()));
    }

    private GeigerSound(@NotNull Player player, int level) {
        super(player, (SoundEvent)NCSounds.GEIGER_SOUNDS.get(level - 1).get());
        this.radiationLevel = level;
        this.setFade(1.0f, 1.0f);
    }

    @Override
    public boolean shouldPlaySound(@NotNull Player player) {
        return this.radiationLevel > 0;
    }

    @Override
    public float m_7769_() {
        return super.m_7769_() * 0.5f;
    }
}

