/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import igentuman.nc.setup.registration.NcParticleTypes;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public record FusionBeamParticleData(Direction direction, double distance, float energyScale) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<FusionBeamParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FusionBeamParticleData>(){

        @NotNull
        public FusionBeamParticleData fromCommand(@NotNull ParticleType<FusionBeamParticleData> type, @NotNull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            Direction direction = Direction.m_122376_((int)reader.readInt());
            reader.expect(' ');
            double distance = reader.readDouble();
            reader.expect(' ');
            float energyScale = reader.readFloat();
            return new FusionBeamParticleData(direction, distance, energyScale);
        }

        @NotNull
        public FusionBeamParticleData fromNetwork(@NotNull ParticleType<FusionBeamParticleData> type, FriendlyByteBuf buf) {
            return new FusionBeamParticleData((Direction)buf.m_130066_(Direction.class), buf.readDouble(), buf.readFloat());
        }
    };
    public static final Codec<FusionBeamParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)Direction.f_175356_.fieldOf("direction").forGetter(data -> data.direction), (App)Codec.DOUBLE.fieldOf("distance").forGetter(data -> data.distance), (App)Codec.FLOAT.fieldOf("energyScale").forGetter(data -> Float.valueOf(data.energyScale))).apply((Applicative)val, FusionBeamParticleData::new));

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)NcParticleTypes.FUSION_BEAM.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.direction);
        buffer.writeDouble(this.distance);
        buffer.writeFloat(this.energyScale);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f", this.m_6012_().toString(), this.direction.ordinal(), this.distance, Float.valueOf(this.energyScale));
    }
}

