/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.processor;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.EnergyBar;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.client.gui.element.slot.BigSlot;
import igentuman.nc.client.gui.element.slot.NormalSlot;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.content.processors.config.ProcessorSlots;
import igentuman.nc.handler.event.client.TickHandler;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class NCProcessorScreen<T extends NCProcessorContainer>
extends AbstractContainerScreen<T>
implements IProgressScreen {
    protected final ResourceLocation GUI = new ResourceLocation("nuclearcraft", "textures/gui/processor.png");
    protected int relX;
    protected int relY;
    protected int xCenter;
    protected ProcessorSlots slots;
    protected Button.SideConfig sideConfigBtn;
    protected Button.RedstoneConfig redstoneConfigBtn;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    protected EnergyBar energyBar;
    private Button.ShowRecipes showRecipesBtn;

    public NCProcessorScreen(T container, Inventory inv, Component name) {
        super(container, inv, name);
        this.f_97726_ = 180;
        this.f_97727_ = 180;
        TickHandler.currentScreenCode = ((NCProcessorContainer)this.f_97732_).getProcessor().name;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void addSlots() {
        for (int i = 0; i < this.slots.slotsCount(); ++i) {
            if (this.slots.outputSlotsCount() == 1 && this.slots.getSlotType(i).contains("_out")) {
                this.addWidget(new BigSlot(this.slots.getSlotPos(i), this.slots.getSlotType(i)));
                if (!this.slots.getSlotType(i).contains("fluid")) continue;
                this.addWidget(FluidTankRenderer.tank(this.getFluidTank(this.slots.fluidSlotId(i))).id(this.slots.fluidSlotId(i)).size(24, 24).pos(this.slots.getSlotPos(i)[0] - 4, this.slots.getSlotPos(i)[1] - 4).canVoid());
                continue;
            }
            if (!((NCProcessorContainer)this.f_97732_).getProcessor().isSlotHidden(i + this.slots.getInputFluids()) || this.slots.getSlotType(i).contains("fluid")) {
                this.addWidget(new NormalSlot(this.slots.getSlotPos(i), this.slots.getSlotType(i)));
            }
            if (!this.slots.getSlotType(i).contains("fluid")) continue;
            this.addWidget(FluidTankRenderer.tank(this.getFluidTank(this.slots.fluidSlotId(i))).id(this.slots.fluidSlotId(i)).pos(this.slots.getSlotPos(i)).canVoid());
        }
    }

    protected void addWidget(NCGuiElement widget) {
        widget.setScreen(this);
        this.widgets.add(widget);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slots = ((NCProcessorContainer)this.f_97732_).getProcessor().getSlotsConfig();
        this.updateRelativeCords();
        this.widgets.clear();
        if (((NCProcessorContainer)this.f_97732_).getProcessor().getPower() > 0) {
            this.energyBar = new EnergyBar(9, 4, ((NCProcessorContainer)this.f_97732_).getEnergy());
            this.widgets.add(this.energyBar);
        }
        int progressBarX = 71;
        if (this.slots.getOutputItems() + this.slots.getOutputFluids() > 6) {
            progressBarX -= ProcessorSlots.margin;
        }
        if (this.slots.getInputItems() + this.slots.getInputFluids() > 5) {
            progressBarX += ProcessorSlots.margin;
        }
        this.addWidget(new ProgressBar(progressBarX, 40, this, ((NCProcessorContainer)this.f_97732_).getProcessor().progressBar));
        this.addOtherSlots();
        this.sideConfigBtn = new Button.SideConfig(29, 74, this);
        this.addWidget(this.sideConfigBtn);
        this.redstoneConfigBtn = new Button.RedstoneConfig(48, 74, this, ((NCProcessorContainer)this.f_97732_).getPosition());
        this.addWidget(this.redstoneConfigBtn);
        this.showRecipesBtn = new Button.ShowRecipes(67, 74, this);
        this.addWidget(this.showRecipesBtn);
        this.addSlots();
    }

    protected void addOtherSlots() {
        int ux = 154;
        if (((NCProcessorContainer)this.f_97732_).getProcessor().supportEnergyUpgrade) {
            this.addWidget(new NormalSlot(ux, 77, "energy_upgrade"));
            ux -= 18;
        }
        if (((NCProcessorContainer)this.f_97732_).getProcessor().supportSpeedUpgrade) {
            this.addWidget(new NormalSlot(ux, 77, "speed_upgrade"));
            ux -= 18;
        }
        if (((NCProcessorContainer)this.f_97732_).getProcessor().supportsCatalyst) {
            this.addWidget(new NormalSlot(ux, 77, "catalyst"));
        }
    }

    protected FluidTank getFluidTank(int i) {
        return ((NCProcessorContainer)this.f_97732_).getFluidTank(i);
    }

    public NCProcessorScreen(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component) {
        this((NCProcessorContainer)abstractContainerMenu, inventory, component);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.redstoneConfigBtn.setMode(((NCProcessorContainer)this.m_6262_()).getRedstoneMode());
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((NCProcessorContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    protected void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            if (widget instanceof EnergyBar) {
                widget.clearTooltips();
                widget.addTooltip((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"speed.multiplier", (Object[])new Object[]{((NCProcessorContainer)this.f_97732_).speedMultiplier()}), ChatFormatting.RED));
                widget.addTooltip((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"energy.multiplier", (Object[])new Object[]{((NCProcessorContainer)this.f_97732_).energyMultiplier()}), ChatFormatting.GOLD));
                widget.addTooltip((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"energy.per_tick", (Object[])new Object[]{TextUtils.scaledFormat(((NCProcessorContainer)this.f_97732_).energyPerTick())}), ChatFormatting.YELLOW));
            }
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    @Override
    public double getProgress() {
        return ((NCProcessorContainer)this.f_97732_).getProgress();
    }

    public String getRecipeTypeName() {
        return ((NCProcessorContainer)this.m_6262_()).getProcessor().name;
    }
}

