/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.fission;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.container.FissionControllerContainer;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FissionControllerScreen
extends AbstractContainerScreen<FissionControllerContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = new ResourceLocation("nuclearcraft", "textures/gui/fission/controller.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    private FluidTankRenderer coolantTank;
    private FluidTankRenderer steamTank;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    private VerticalBar heatBar;
    private VerticalBar coolantBar;
    private VerticalBar hotCoolantBar;
    private Button.ReactorMode modeBtn;
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();

    public FissionControllerContainer container() {
        return (FissionControllerContainer)this.f_97732_;
    }

    public FissionControllerScreen(FissionControllerContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 176;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(this.f_97726_ - 19, 80, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(this.f_97726_ - 32, 80, this, this.isInteriorValid());
        this.energyBar = new VerticalBar.Energy(17, 16, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.heatBar = new VerticalBar.Heat(8, 16, (IVerticalBarScreen)this, (int)this.container().getMaxHeat());
        this.coolantBar = new VerticalBar.Coolant(17, 16, (IVerticalBarScreen)this, 1000000);
        this.hotCoolantBar = new VerticalBar.HotCoolant(26, 16, (IVerticalBarScreen)this, 1000000);
        this.coolantTank = new FluidTankRenderer(this.getFluidTank(0), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 73, 18, 17);
        this.steamTank = new FluidTankRenderer(this.getFluidTank(1), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 73, 27, 17);
        this.widgets.add(this.heatBar);
        this.widgets.add(new ProgressBar(74, 35, this, 7));
        this.modeBtn = new Button.ReactorMode(150, 54, this, ((FissionControllerContainer)this.f_97732_).getPosition());
        this.widgets.add(this.modeBtn);
    }

    protected FluidTank getFluidTank(int i) {
        return ((FissionControllerContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        graphics.m_280480_(this.container().getInputStack(), this.relX + 82, this.relY + 20);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.modeBtn.setMode(((FissionControllerContainer)this.m_6262_()).getMode());
        this.modeBtn.setTimer(((FissionControllerContainer)this.m_6262_()).getModeTimer());
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid()) {
            this.checkboxInterior.addTooltip((Component)Component.m_237110_((String)"reactor.heat_sinks_count", (Object[])new Object[]{this.container().getHeatSinksCount()}));
            this.checkboxInterior.addTooltip((Component)Component.m_237110_((String)"reactor.moderators_count", (Object[])new Object[]{this.container().getModeratorsCount()}));
            this.checkboxInterior.addTooltip((Component)Component.m_237110_((String)"reactor.moderation_level", (Object[])new Object[]{this.container().getModerationLevel()}));
            this.checkboxInterior.addTooltip((Component)Component.m_237110_((String)"reactor.reactivity", (Object[])new Object[]{this.container().getReactivity()}));
            this.checkboxInterior.addTooltip((Component)Component.m_237110_((String)"reactor.irradiators_connections", (Object[])new Object[]{this.container().getIrradiatorsConnections()}));
        }
        if (!((FissionControllerContainer)this.m_6262_()).getMode()) {
            this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.coolantBar.draw(graphics, mouseX, mouseY, partialTicks);
            this.hotCoolantBar.draw(graphics, mouseX, mouseY, partialTicks);
            this.coolantTank.draw(graphics, mouseX, mouseY, partialTicks);
            this.steamTank.draw(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((FissionControllerContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        this.casingTootip = this.isCasingValid() ? TextUtils.applyFormat((Component)Component.m_237110_((String)"reactor.size", (Object[])new Object[]{this.getMultiblockHeight(), this.getMultiblockWidth(), this.getMultiblockDepth()}), ChatFormatting.GOLD) : TextUtils.applyFormat((Component)Component.m_237110_((String)this.getValidationResultKey(), (Object[])new Object[]{this.getValidationResultData()}), ChatFormatting.RED);
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                this.interiorTootip = TextUtils.applyFormat((Component)Component.m_237110_((String)"reactor.fuel_cells", (Object[])new Object[]{this.getFuelCellsCount()}), ChatFormatting.GOLD);
                if (this.container().hasRecipe() && !this.container().getEfficiency().equals("NaN")) {
                    graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"fission_reactor.efficiency", (Object[])new Object[]{this.container().getEfficiency()}), 35, 82, 0x8AFF8A);
                    graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"fission_reactor.net_heat", (Object[])new Object[]{this.container().getNetHeat()}), 35, 72, 0x8AFF8A);
                    graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"fission_reactor.heat_multiplier", (Object[])new Object[]{this.container().getHeatMultiplier()}), 35, 62, 0x8AFF8A);
                }
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)Component.m_237110_((String)this.getValidationResultKey(), (Object[])new Object[]{this.getValidationResultData()}), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private int getFuelCellsCount() {
        return this.container().getFuelCellsCount();
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    private int getMultiblockHeight() {
        return this.container().getHeight();
    }

    private int getMultiblockWidth() {
        return this.container().getWidth();
    }

    private int getMultiblockDepth() {
        return this.container().getDepth();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        this.heatBar.clearTooltips();
        this.heatBar.addTooltip((Component)Component.m_237110_((String)"reactor.cooling", (Object[])new Object[]{this.container().getCooling()}).m_130940_(ChatFormatting.AQUA));
        this.heatBar.addTooltip((Component)Component.m_237110_((String)"reactor.heating", (Object[])new Object[]{this.container().getHeating()}).m_130940_(ChatFormatting.RED));
        this.heatBar.addTooltip((Component)Component.m_237110_((String)"reactor.net_heat", (Object[])new Object[]{this.container().getNetHeat()}).m_130940_(ChatFormatting.GOLD));
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (!this.container().getMode()) {
            this.energyBar.clearTooltips();
            this.energyBar.addTooltip((Component)Component.m_237110_((String)"reactor.forge_energy_per_tick", (Object[])new Object[]{this.container().energyPerTick()}));
            if (this.energyBar.m_5953_(pMouseX, pMouseY + 10)) {
                graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
            }
        } else {
            if (this.coolantTank.m_5953_(pMouseX, pMouseY + 10)) {
                graphics.m_280677_(this.f_96547_, this.coolantTank.getTooltips(), Optional.empty(), pMouseX, pMouseY);
            }
            if (this.steamTank.m_5953_(pMouseX, pMouseY + 10)) {
                List<Component> tooltips = this.steamTank.getTooltips();
                tooltips.add((Component)Component.m_237110_((String)"reactor.steam_per_tick", (Object[])new Object[]{this.container().getSteamPerTick()}));
                graphics.m_280677_(this.f_96547_, tooltips, Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    @Override
    public double getProgress() {
        return this.container().getProgress();
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return this.container().getHeat();
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }
}

