/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.turbine;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.turbine.TurbineBE;
import igentuman.nc.block.entity.turbine.TurbineRotorBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.NCTurbinePeripheral;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.turbine.TurbineMultiblock;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.RecipeInfo;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class TurbineControllerBE<RECIPE extends Recipe>
extends TurbineBE {
    public static String NAME = "turbine_controller";
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    protected final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public BlockPos errorBlockPos = BlockPos.f_121853_;
    @NBTField
    public Direction orientation = Direction.NORTH;
    @NBTField
    public boolean isCasingValid = false;
    @NBTField
    public boolean isInternalValid = false;
    @NBTField
    public int height = 1;
    @NBTField
    public int width = 1;
    @NBTField
    public int depth = 1;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public int realFlow = 0;
    @NBTField
    public double coilsEfficiency = 0.0;
    @NBTField
    public boolean powered = false;
    @NBTField
    protected boolean forceShutdown = false;
    @NBTField
    public int activeCoils = 0;
    @NBTField
    public float flow = 0.0f;
    @NBTField
    public float rotationSpeed = 0.0f;
    @NBTField
    public int blades = 0;
    @NBTField
    public double efficiency = 0.0;
    public ValidationResult validationResult = ValidationResult.INCOMPLETE;
    public RecipeInfo<RECIPE> recipeInfo = new RecipeInfo();
    public boolean controllerEnabled = false;
    protected Direction facing;
    public RECIPE recipe;
    public HashMap<String, RECIPE> cachedRecipes = new HashMap();
    private List<FluidStack> allowedInputs;
    private LazyOptional<NCTurbinePeripheral> peripheralCap;
    protected int reValidateCounter = 0;

    @Override
    public String getName() {
        return NAME;
    }

    public TurbineControllerBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
        this.multiblock = new TurbineMultiblock(this);
        this.contentHandler = new SidedContentHandler(0, 0, 1, 1, 1000, 10000);
        this.contentHandler.fluidCapability.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler.fluidCapability.setGlobalMode(1, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.setBlockEntity(this);
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler.itemHandler;
    }

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 0, 100000000){

            @Override
            protected void onEnergyChanged() {
                TurbineControllerBE.this.m_6596_();
            }
        };
    }

    public BlockPos getBlockPosForSteam() {
        if (!this.multiblock().isFormed()) {
            this.multiblock().validate();
        }
        BlockPos start = this.f_58858_;
        if (this.multiblock().bearingPositions.size() > 0) {
            for (int i = 0; i < this.multiblock().bearingPositions.size(); ++i) {
                start = new BlockPos((Vec3i)this.multiblock().bearingPositions.get(i));
                BlockEntity be = this.m_58904_().m_7702_(start.m_121945_(this.orientation));
                if (be instanceof TurbineRotorBE) continue;
                return start;
            }
        }
        return start;
    }

    private void addToCache(RECIPE recipe) {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    public RECIPE getRecipe() {
        if (((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).isEmpty()) {
            return null;
        }
        RECIPE cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (NcRecipe ncRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
            if (!ncRecipe.test(this.contentHandler)) continue;
            this.addToCache((Recipe)ncRecipe);
            return (RECIPE)((Recipe)ncRecipe);
        }
        return null;
    }

    public RECIPE getCachedRecipe() {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key) && ((Recipe)this.cachedRecipes.get(key)).test(this.contentHandler)) {
            return (RECIPE)((Recipe)this.cachedRecipes.get(key));
        }
        return null;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new NCTurbinePeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler.getFluidCapability(null);
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected void playRunningSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FISSION_REACTOR.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FISSION_REACTOR.get()).m_11660_())) {
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)NCSounds.FISSION_REACTOR.get(), SoundSource.BLOCKS, 0.2f, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    @Override
    public void tickClient() {
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
            return;
        }
        if (this.rotationSpeed > 0.0f) {
            this.spawnSteamParticles();
            this.playRunningSound();
        }
    }

    @Override
    public void tickServer() {
        this.rotationSpeed = 0.0f;
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        this.changed = false;
        super.tickServer();
        boolean wasPowered = this.powered;
        this.handleValidation();
        this.trackChanges(wasPowered, this.powered);
        this.controllerEnabled = (this.hasRedstoneSignal() || this.controllerEnabled) && this.multiblock().isFormed();
        boolean bl = this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        if (this.multiblock().isFormed()) {
            this.trackChanges(this.contentHandler.tick());
            if (this.controllerEnabled) {
                this.powered = this.processRecipe();
                this.trackChanges(this.powered);
            } else {
                this.powered = false;
            }
            this.handleMeltdown();
            this.contentHandler.setAllowedInputFluids(0, this.getAllowedInputFluids());
        }
        boolean bl2 = this.refreshCacheFlag = !this.multiblock().isFormed();
        if (wasPowered != this.powered) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
        }
        if (this.refreshCacheFlag || this.changed) {
            try {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.controllerEnabled = false;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<FluidStack>();
            for (NcRecipe ncRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (FluidStackIngredient ingredient : ncRecipe.getInputFluids()) {
                    this.allowedInputs.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedInputs;
    }

    @Override
    public TurbineMultiblock multiblock() {
        if (this.multiblock == null) {
            this.multiblock = new TurbineMultiblock(this);
        }
        return this.multiblock;
    }

    private void handleValidation() {
        if (this.multiblock == null) {
            return;
        }
        ValidationResult wasResult = this.validationResult;
        boolean wasFormed = this.multiblock().isFormed();
        if (!(wasFormed && this.isInternalValid && this.isCasingValid)) {
            this.activeCoils = 0;
            this.coilsEfficiency = 0.0;
            this.flow = 0.0f;
            ++this.reValidateCounter;
            if (this.reValidateCounter < 40) {
                return;
            }
            this.reValidateCounter = 0;
            this.multiblock().validate();
            this.isCasingValid = this.multiblock().isOuterValid();
            if (this.isCasingValid) {
                this.isInternalValid = this.multiblock().isInnerValid();
            }
            this.powered = false;
            this.changed = true;
        }
        this.validationResult = this.multiblock().validationResult;
        if (this.validationResult.id != wasResult.id) {
            this.changed = true;
        }
        if (this.activeCoils != this.multiblock().activeCoils) {
            this.changed = true;
            this.activeCoils = this.multiblock().activeCoils;
            this.coilsEfficiency = this.multiblock().coilsEfficiency;
        }
        if (this.flow != this.multiblock().flow) {
            this.changed = true;
            this.flow = this.multiblock().flow;
            this.blades = this.multiblock().blades;
        }
        this.height = this.multiblock().height();
        this.width = this.multiblock().width();
        this.depth = this.multiblock().depth();
        this.trackChanges(wasFormed, this.multiblock().isFormed());
    }

    public float bladesEfficiency() {
        if (this.blades == 0) {
            return 0.0f;
        }
        return this.flow / (float)this.blades;
    }

    public float getEfficiencyRate() {
        return (float)this.coilsEfficiency / (float)(100 * this.activeCoils) * this.bladesEfficiency();
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private void handleMeltdown() {
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.multiblock() != null) {
            this.multiblock().onControllerRemoved();
        }
    }

    private boolean processRecipe() {
        if (this.recipeInfo.recipe != null && this.recipeInfo.isCompleted() && this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty()) {
            this.recipeInfo.clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    public List<BlockPos> getBlocks(BlockPos pos, Direction.Axis axis) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int x = pos.m_123341_();
        switch (axis) {
            case X: {
                positions.add(pos.m_7918_(0, -1, -1));
                positions.add(pos.m_7918_(0, -1, 1));
                positions.add(pos.m_7918_(0, 1, 1));
                positions.add(pos.m_7918_(0, 1, -1));
                break;
            }
            case Y: {
                positions.add(pos.m_7918_(-1, 0, -1));
                positions.add(pos.m_7918_(-1, 0, 1));
                positions.add(pos.m_7918_(1, 0, 1));
                positions.add(pos.m_7918_(1, 0, -1));
                break;
            }
            case Z: {
                positions.add(pos.m_7918_(-1, -1, 0));
                positions.add(pos.m_7918_(1, -1, 0));
                positions.add(pos.m_7918_(1, 1, 0));
                positions.add(pos.m_7918_(-1, 1, 0));
            }
        }
        return positions;
    }

    private void spawnSteamParticles() {
        if (this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 4L == 0L) {
            BlockPos pos = this.getBlockPosForSteam().m_5484_(this.orientation.m_122424_(), 1);
            for (BlockPos source : this.getBlocks(pos, this.multiblock().turbineDirection.m_122434_())) {
                for (int i = 0; i < 3; ++i) {
                    double x = (double)((float)source.m_123341_() + 0.4f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    double y = (double)((float)source.m_123342_() + 0.7f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    double z = (double)((float)source.m_123343_() - 0.4f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    float ySpeed = 0.0f;
                    float zSpeed = 0.0f;
                    float xSpeed = 0.0f;
                    switch (this.multiblock().turbineDirection) {
                        case UP: {
                            ySpeed = 0.2f;
                            break;
                        }
                        case DOWN: {
                            ySpeed = -0.1f;
                            break;
                        }
                        case NORTH: {
                            zSpeed = -0.1f;
                            z += 0.5;
                            break;
                        }
                        case SOUTH: {
                            zSpeed = 0.1f;
                            z += 0.5;
                            break;
                        }
                        case EAST: {
                            xSpeed = 0.1f;
                            z += 0.5;
                            break;
                        }
                        case WEST: {
                            xSpeed = -0.1f;
                            z += 0.5;
                        }
                    }
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
                }
            }
        }
    }

    private boolean process() {
        this.recipeInfo.process(1.0);
        this.flow = Math.max(1.0f, this.flow);
        float theFlow = this.getRealFlow();
        if (theFlow > 0.0f) {
            theFlow = Math.max(theFlow, this.flow / 2.0f * (float)((Integer)TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()).intValue());
        }
        this.rotationSpeed = (this.rotationSpeed * 4.0f + theFlow / (this.flow * (float)((Integer)TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()).intValue())) / 5.0f;
        this.energyStorage.addEnergy(this.calculateEnergy());
        this.efficiency = this.calculateEfficiency();
        this.handleRecipeOutput();
        ((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).drain(this.realFlow, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo.isCompleted()) {
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo.recipe();
            }
            if (((Recipe)this.recipe).handleOutputs(this.contentHandler)) {
                this.recipeInfo.clear();
                if (this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty()) {
                    this.recipe = null;
                }
            } else {
                this.recipeInfo.stuck = true;
            }
            this.m_6596_();
        }
    }

    public int getRealFlow() {
        int wasFlow = this.realFlow;
        this.realFlow = (int)Math.min(this.flow * (float)((Integer)TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()).intValue(), (float)this.getFluidTank(0).getFluidAmount());
        if (wasFlow != this.realFlow) {
            this.changed = true;
        }
        return this.realFlow;
    }

    private int calculateEnergy() {
        int wasEnergy = this.energyPerTick;
        this.energyPerTick = (int)((double)this.realFlow * (Double)TurbineConfig.TURBINE_CONFIG.ENERGY_GEN.get() * (double)this.getEfficiencyRate() * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
        if (wasEnergy != this.energyPerTick) {
            this.changed = true;
        }
        return this.energyPerTick;
    }

    private void updateRecipe() {
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo.setRecipe(this.recipe);
            this.recipeInfo.ticks = ((Recipe)this.recipeInfo.recipe()).getBaseTime();
            this.recipeInfo.energy = ((Recipe)this.recipeInfo.recipe).getEnergy();
            this.recipeInfo.be = this;
        }
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo.isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo.recipe() != null;
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (!this.isCasingValid || !this.isInternalValid) {
                this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
        }
        if (tag.m_128441_("Content")) {
            this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            this.energyStorage.setEnergy(infoTag.m_128451_("energy"));
            this.readTagData(infoTag);
            if (!this.isCasingValid || !this.isInternalValid) {
                this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
            if (tag.m_128441_("Content")) {
                this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
            }
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        infoTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        this.saveTagData(infoTag);
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public double calculateEfficiency() {
        return (double)this.energyPerTick / (this.recipeInfo.energy / 100.0);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo.ticksProcessed > 0.0 && !this.recipeInfo.isCompleted();
    }

    public int getActiveCoils() {
        return this.activeCoils;
    }

    public int getFlow() {
        return (int)this.flow;
    }

    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler.fluidCapability.tanks.get(i);
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public static class Recipe
    extends NcRecipe {
        public double ratio = 1.0;

        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(NAME, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return NAME;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return NAME;
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)TurbineRegistration.TURBINE_BLOCKS.get(this.getCodeId()).get());
        }

        public int getBaseTime() {
            return (int)Math.max(1.0, this.timeModifier);
        }

        @Override
        public double getEnergy() {
            return Math.max(1.0, this.powerModifier);
        }

        @Override
        public void consumeInputs(SidedContentHandler contentHandler) {
            TurbineControllerBE be = (TurbineControllerBE)contentHandler.blockEntity;
            int flow = be.realFlow;
            this.ratio = (double)flow / (double)this.getInputFluids(0).get(0).getAmount();
            FluidStack holded = contentHandler.fluidCapability.getFluidInSlot(0).copy();
            holded.setAmount(flow);
            contentHandler.fluidCapability.holdedInputs.add(holded);
            ((FluidTank)contentHandler.fluidCapability.tanks.get(0)).drain(flow, IFluidHandler.FluidAction.EXECUTE);
        }

        @Override
        public boolean handleOutputs(SidedContentHandler contentHandler) {
            FluidStack outputFluid = (FluidStack)this.outputFluids[0].getRepresentations().get(0);
            FluidStack toOutput = outputFluid.copy();
            int toPush = (int)((double)outputFluid.getAmount() * this.ratio);
            toOutput.setAmount(toPush);
            return contentHandler.fluidCapability.insertFluidInternal(1, toOutput, false).getAmount() != toPush;
        }
    }
}

