/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.fission;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.NCSolidFissionReactorPeripheral;
import igentuman.nc.compat.oc2.NCFissionReactorDevice;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.item.ItemFuel;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.multiblock.fission.FissionReactorMultiblock;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.RecipeInfo;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.NcParticleTypes;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FissionControllerBE<RECIPE extends Recipe>
extends FissionBE {
    public static String NAME = "fission_reactor_controller";
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    protected final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public BlockPos errorBlockPos = BlockPos.f_121853_;
    @NBTField
    public boolean isSteamMode = false;
    @NBTField
    public double heat = 0.0;
    @NBTField
    public int fuelCellsCount = 0;
    @NBTField
    public int reactivityLevel = 0;
    @NBTField
    public int irradiationHeat = 0;
    @NBTField
    public int moderatorsCount = 0;
    @NBTField
    public int heatSinksCount = 0;
    @NBTField
    public int moderatorAttachments = 0;
    @NBTField
    public boolean isCasingValid = false;
    @NBTField
    public boolean isInternalValid = false;
    @NBTField
    public int height = 1;
    @NBTField
    public int width = 1;
    @NBTField
    public int depth = 1;
    @NBTField
    public int toggleModeTimer = 2000;
    @NBTField
    public boolean enabledByController = false;
    @NBTField
    public double heatSinkCooling = 0.0;
    @NBTField
    public double activeCooling = 0.0;
    @NBTField
    public double heatPerTick = 0.0;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public double heatMultiplier = 0.0;
    @NBTField
    public int irradiationConnections = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public double moderationLevel = 1.0;
    @NBTField
    public boolean powered = false;
    protected boolean forceShutdown = false;
    public int fuelCellMultiplier = 1;
    public int moderatorCellMultiplier = 1;
    public ValidationResult validationResult = ValidationResult.INCOMPLETE;
    public RecipeInfo<RECIPE> recipeInfo = new RecipeInfo();
    public boolean controllerEnabled = false;
    private Direction facing;
    public RECIPE recipe;
    public HashMap<String, RECIPE> cachedRecipes = new HashMap();
    @NBTField
    private double steamRate;
    @NBTField
    public int steamPerTick = 0;
    private List<ItemStack> allowedInputs;
    private LazyOptional<NCSolidFissionReactorPeripheral> peripheralCap;
    public float speed = 0.001f;
    protected List<FissionBoilingRecipe> coolantRecipes;
    protected FissionBoilingRecipe boilingRecipe;
    private double targetModerationLevel = 1.0;

    @Override
    public String getName() {
        return NAME;
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (AbstractRecipe abstractRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (Ingredient ingredient : abstractRecipe.getItemIngredients()) {
                    this.allowedInputs.addAll(List.of(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputs;
    }

    public FissionControllerBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
        this.multiblock = new FissionReactorMultiblock(this);
        this.contentHandler = new SidedContentHandler(1, 1, 1 + this.activeCoolersTypes().size(), 1, new int[0]);
        this.contentHandler.setBlockEntity(this);
        this.contentHandler.fluidCapability.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler.fluidCapability.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler.itemHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler.itemHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        ((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).setCapacity(10000);
        ((FluidTank)this.contentHandler.fluidCapability.tanks.get(1)).setCapacity(10000);
        this.contentHandler.setAllowedInputFluids(0, this.getAllowedCoolants());
        this.contentHandler.setAllowedInputFluids(1, this.getAllowedCoolantsOutput());
        for (String type : this.activeCoolersTypes()) {
            this.contentHandler.setAllowedInputFluids(1 + this.activeCoolersTypes().indexOf(type), FissionBlocks.heatsinks.get(type).getAllowedFluids());
        }
    }

    private List<String> activeCoolersTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (String name : FissionBlocks.heatsinks.keySet()) {
            if (!name.contains("active") || name.contains("empty")) continue;
            types.add(name.replace("active_", ""));
        }
        return types;
    }

    protected List<FluidStack> getAllowedCoolantsOutput() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
            allowedCoolants.addAll(recipe.getOutputFluids(0));
        }
        return allowedCoolants;
    }

    protected List<FluidStack> getAllowedCoolants() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
            allowedCoolants.addAll(recipe.getInputFluids(0));
        }
        return allowedCoolants;
    }

    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler.fluidCapability.tanks.get(i);
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler.itemHandler;
    }

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 0, 100000000){

            @Override
            protected void onEnergyChanged() {
                FissionControllerBE.this.m_6596_();
            }
        };
    }

    private void addToCache(RECIPE recipe) {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    public RECIPE getRecipe() {
        if (this.contentHandler.itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            return null;
        }
        RECIPE cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (AbstractRecipe abstractRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
            if (!abstractRecipe.test(this.contentHandler)) continue;
            this.addToCache((Recipe)abstractRecipe);
            return (RECIPE)((Recipe)abstractRecipe);
        }
        return null;
    }

    public RECIPE getCachedRecipe() {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key) && ((Recipe)this.cachedRecipes.get(key)).test(this.contentHandler)) {
            return (RECIPE)((Recipe)this.cachedRecipes.get(key));
        }
        return null;
    }

    public double getSteamRate() {
        return Math.max(0.0, this.steamRate);
    }

    public void boil() {
        this.steamPerTick = 0;
        if (!this.isProcessing()) {
            return;
        }
        double cooling = this.coolingPerTick();
        if (this.getNetHeat() < 0.0) {
            cooling += this.getNetHeat();
        }
        cooling = Math.min(this.heatPerTick, cooling);
        double heatEff = cooling * (Double)FissionConfig.FISSION_CONFIG.BOILING_MULTIPLIER.get() * this.efficiency * 0.01 * this.heatMultiplier;
        if (this.hasCoolant()) {
            FluidStack steam = this.boilingRecipe.getOutputFluids().get(0);
            FluidStack coolant = this.boilingRecipe.getInputFluids(0).get(0);
            double conversion = heatEff / this.boilingRecipe.conversionRate();
            FluidStack currentCoolant = this.contentHandler.fluidCapability.getFluidInSlot(0);
            FluidStack currentOutput = this.contentHandler.fluidCapability.getFluidInSlot(1);
            if (!steam.isFluidEqual(currentOutput) && !currentOutput.isEmpty()) {
                this.heat += this.coolingPerTick() / 2.0;
                return;
            }
            double capacity = ((FluidTank)this.contentHandler.fluidCapability.tanks.get(1)).getCapacity() - currentOutput.getAmount();
            int ops = (int)(capacity / (double)steam.getAmount());
            capacity = ops * steam.getAmount();
            int canGetAmount = (int)Math.min((double)steam.getAmount() * conversion, capacity);
            ops = canGetAmount / steam.getAmount();
            ops = Math.min(currentCoolant.getAmount() / coolant.getAmount(), ops);
            this.steamPerTick = Math.max(ops * steam.getAmount(), 0);
            if (this.steamPerTick == 0) {
                this.heat += this.coolingPerTick() / 2.0;
                return;
            }
            ((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).drain(ops * coolant.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            FluidStack out = steam.copy();
            out.setAmount(ops * steam.getAmount());
            ((FluidTank)this.contentHandler.fluidCapability.tanks.get(1)).fill(out, IFluidHandler.FluidAction.EXECUTE);
            this.changed = true;
            if ((double)ops < Math.floor(conversion)) {
                this.heat += this.coolingPerTick() / (conversion - (double)ops);
            }
        }
    }

    public void toggleMode() {
        this.toggleModeTimer = 200;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new NCSolidFissionReactorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> NCFissionReactorDevice.createDevice(this)).cast();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.contentHandler.getItemCapability(side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.canAcceptFluid()) {
            return this.contentHandler.getFluidCapability(side);
        }
        if (cap == ForgeCapabilities.ENERGY && !this.isSteamMode && side == null) {
            return this.energy.cast();
        }
        if (ModUtil.isOC2Loaded() && cap == NCFissionReactorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        if (ModUtil.isMekanismLoadeed() && this.isSteamMode) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected void playRunningSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FISSION_REACTOR.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FISSION_REACTOR.get()).m_11660_())) {
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)NCSounds.FISSION_REACTOR.get(), SoundSource.BLOCKS, 0.2f, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    @Override
    public void tickClient() {
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
            return;
        }
        if (this.isProcessing()) {
            this.spawnParticles();
            this.playRunningSound();
        }
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            this.irradiationHeat = 0;
            this.controllerEnabled = false;
            return;
        }
        this.changed = false;
        this.hopToggleMode();
        boolean wasFormed = this.multiblock().isFormed();
        super.tickServer();
        boolean wasPowered = this.powered;
        this.handleValidation();
        this.trackChanges(wasPowered, this.powered);
        boolean wasEnabled = this.controllerEnabled;
        this.controllerEnabled = this.hasRedstoneSignal() && this.multiblock().isFormed();
        boolean bl = this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        if (this.controllerEnabled != wasEnabled && this.reactivityLevel > 10 && this.reactivityLevel < 99) {
            this.controllerEnabled = wasEnabled;
        }
        if (this.multiblock().isFormed()) {
            this.trackChanges(this.updateModerationLevel());
            this.trackChanges(this.contentHandler.tick());
            if (this.controllerEnabled || this.reactivityLevel > 0) {
                this.powered = this.processReaction();
                this.trackChanges(this.powered);
            } else {
                this.powered = false;
            }
            this.trackChanges(this.coolDown());
            this.handleMeltdown();
            this.contentHandler.setAllowedInputItems(this.getAllowedInputItems());
        } else if (this.isProcessing() && wasFormed) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), 10000 * this.fuelCellsCount, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        }
        boolean bl2 = this.refreshCacheFlag = !this.multiblock().isFormed();
        if (this.refreshCacheFlag || this.changed) {
            try {
                assert (this.f_58857_ != null);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.irradiationHeat = 0;
    }

    private void hopToggleMode() {
        if (this.toggleModeTimer < 201) {
            --this.toggleModeTimer;
            this.changed = true;
            if (this.toggleModeTimer < 1) {
                this.toggleModeTimer = 2000;
                this.isSteamMode = !this.isSteamMode;
            }
        }
    }

    @Override
    public FissionReactorMultiblock multiblock() {
        if (this.multiblock == null) {
            this.multiblock = new FissionReactorMultiblock(this);
        }
        return super.multiblock();
    }

    private void handleValidation() {
        boolean assembled;
        boolean wasFormed = this.multiblock().isFormed();
        boolean bl = assembled = wasFormed && this.isInternalValid && this.isCasingValid;
        if (!assembled && this.m_58904_().m_46467_() % 40L == 0L || this.m_58904_().m_46467_() % 200L == 0L && this.hasRecipe()) {
            this.multiblock().validate();
            this.isCasingValid = this.multiblock().isOuterValid();
            if (this.isCasingValid) {
                this.isInternalValid = this.multiblock().isInnerValid();
            }
            this.powered = false;
            this.changed = true;
            this.height = this.multiblock().height();
            this.width = this.multiblock().width();
            this.depth = this.multiblock().depth();
            if (this.multiblock().isFormed() && ((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).getCapacity() != 5000 * this.height * this.width * this.depth) {
                ((FluidTank)this.contentHandler.fluidCapability.tanks.get(0)).setCapacity(5000 * this.height * this.width * this.depth);
                ((FluidTank)this.contentHandler.fluidCapability.tanks.get(1)).setCapacity(5000 * this.height * this.width * this.depth);
            }
        }
        this.trackChanges(wasFormed, this.multiblock().isFormed());
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private void handleMeltdown() {
        if (this.heat >= this.getMaxHeat()) {
            BlockPos explosionPos = this.m_58899_().m_5484_(this.getFacing(), 2);
            ArrayList<BlockPos> fuelCells = new ArrayList<BlockPos>(this.multiblock().fuelCells);
            if ((Double)FissionConfig.FISSION_CONFIG.EXPLOSION_RADIUS.get() == 0.0) {
                this.m_58904_().m_254849_(null, (double)explosionPos.m_123341_(), (double)explosionPos.m_123342_(), (double)explosionPos.m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
            } else {
                this.m_58904_().m_254849_(null, (double)explosionPos.m_123341_(), (double)explosionPos.m_123342_(), (double)explosionPos.m_123343_(), ((Double)FissionConfig.FISSION_CONFIG.EXPLOSION_RADIUS.get()).floatValue(), Level.ExplosionInteraction.TNT);
                this.m_58904_().m_7731_(explosionPos, NCFluids.getBlock("corium"), 1);
                for (BlockPos pos : fuelCells) {
                    this.m_58904_().m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, Level.ExplosionInteraction.TNT);
                    this.m_58904_().m_7731_(pos, NCFluids.getBlock("corium"), 1);
                }
            }
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), 100000 * this.fuelCellsCount, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
            this.m_7651_();
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.multiblock() != null) {
            this.multiblock().onControllerRemoved();
        }
    }

    private boolean coolDown() {
        double wasHeat = this.heat;
        this.heat -= this.coolingPerTick();
        if (this.isSteamMode) {
            this.boil();
        }
        this.heat = Math.max(0.0, this.heat);
        return wasHeat != this.heat;
    }

    private boolean processReaction() {
        this.heatMultiplier = this.heatMultiplier() + this.collectedHeatMultiplier() - 1.0;
        if (this.recipeInfo.recipe != null && this.recipeInfo.isCompleted() && this.contentHandler.itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            this.recipeInfo.clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    private void spawnParticles() {
        if (this.multiblock() == null) {
            return;
        }
        if (!this.multiblock().isFormed()) {
            this.multiblock().validate();
        }
        if (this.f_58857_.m_46467_() % (long)(this.f_58857_.f_46441_.m_188503_(10) + 5) != 0L) {
            return;
        }
        BlockPos topBlock = this.multiblock().getTopRightInnerBlock();
        BlockPos bottomLeft = this.multiblock().getBottomLeftInnerBlock();
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)bottomLeft, (BlockPos)topBlock)) {
            if (!this.f_58857_.f_46441_.m_188499_()) continue;
            this.f_58857_.m_7106_((ParticleOptions)NcParticleTypes.RADIATION.get(), (double)((float)blockPos.m_123341_() + this.f_58857_.f_46441_.m_188501_()), (double)((float)blockPos.m_123342_() + this.f_58857_.f_46441_.m_188501_()), (double)((float)blockPos.m_123343_() + this.f_58857_.f_46441_.m_188501_()), 0.0, (double)-0.05f, 0.0);
        }
    }

    private boolean process() {
        this.reactivityLevel += this.controllerEnabled ? 1 : -1;
        this.reactivityLevel = Math.max(0, Math.min(this.reactivityLevel, 100));
        this.recipeInfo.process((double)this.fuelCellsCount * (this.heatMultiplier() + this.collectedHeatMultiplier() - 1.0) * (double)this.reactivityLevel / 100.0);
        if (this.recipeInfo.radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo.radiation / 10000.0, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        if (!this.recipeInfo.isCompleted()) {
            if (!this.isSteamMode) {
                this.energyStorage.addEnergy(this.calculateEnergy());
            }
            this.heat += this.calculateHeat();
        }
        this.handleRecipeOutput();
        this.efficiency = this.calculateEfficiency();
        return true;
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo.isCompleted()) {
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo.recipe();
            }
            if (((AbstractRecipe)this.recipe).handleOutputs(this.contentHandler)) {
                this.recipeInfo.clear();
                if (this.contentHandler.itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
                    this.recipe = null;
                }
            } else {
                this.recipeInfo.stuck = true;
            }
            this.m_6596_();
        }
    }

    public double heatMultiplier() {
        double h = this.heatPerTick();
        double c = Math.max(1.0, this.coolingPerTick());
        return Math.log10(h / c) / (1.0 + Math.exp(h / c * (Double)FissionConfig.FISSION_CONFIG.HEAT_MULTIPLIER.get())) + 1.0;
    }

    public double collectedHeatMultiplier() {
        return Math.min((Double)FissionConfig.FISSION_CONFIG.HEAT_MULTIPLIER_CAP.get(), Math.pow((this.heat + this.getMaxHeat() / 8.0) / this.getMaxHeat(), 5.0) + 0.9999694824);
    }

    public double coolingPerTick() {
        return this.heatSinksCooling() + this.environmentCooling();
    }

    public double environmentCooling() {
        return ((Biome)this.m_58904_().m_204166_(this.m_58899_()).get()).m_47554_() * 10.0f;
    }

    public double heatSinksCooling() {
        this.heatSinkCooling = this.multiblock().countCooling(this.refreshCacheFlag);
        return this.heatSinkCooling + this.activeCooling;
    }

    public double heatPerTick() {
        this.heatPerTick = this.recipeInfo.heat * (double)Math.max(this.fuelCellsCount, this.fuelCellMultiplier) + this.moderatorsHeat() + (double)this.irradiationHeat;
        return this.heatPerTick;
    }

    private double calculateHeat() {
        return this.heatPerTick() * Math.max(0.5, (double)this.reactivityLevel / 100.0);
    }

    private int calculateEnergy() {
        this.energyPerTick = (int)((this.recipeInfo.energy * (double)Math.abs(this.fuelCellMultiplier - this.fuelCellsCount) + this.moderatorsFE()) * (this.heatMultiplier() + this.collectedHeatMultiplier() - 1.0) * (Double)FissionConfig.FISSION_CONFIG.FE_GENERATION_MULTIPLIER.get() / 10.0 * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get() * (double)this.reactivityLevel / 100.0);
        return this.energyPerTick;
    }

    public double moderatorsHeat() {
        return this.moderationLevel * this.recipeInfo.heat * (double)this.moderatorCellMultiplier * ((Double)FissionConfig.FISSION_CONFIG.MODERATOR_HEAT_MULTIPLIER.get() / 100.0);
    }

    public double moderatorsFE() {
        return this.moderationLevel * this.recipeInfo.energy * (double)this.moderatorCellMultiplier * ((Double)FissionConfig.FISSION_CONFIG.MODERATOR_FE_MULTIPLIER.get() / 100.0);
    }

    private void updateRecipe() {
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo.setRecipe(this.recipe);
            this.recipeInfo.ticks = ((Recipe)this.recipeInfo.recipe()).getDepletionTime();
            this.recipeInfo.energy = ((Recipe)this.recipeInfo.recipe()).getEnergy();
            this.recipeInfo.heat = ((Recipe)this.recipeInfo.recipe()).getHeat();
            this.recipeInfo.radiation = ((Recipe)this.recipeInfo.recipe()).getRadiation();
            this.recipeInfo.be = this;
            ((AbstractRecipe)this.recipe).consumeInputs(this.contentHandler);
        }
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo.isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo.recipe() != null;
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (!this.isCasingValid || !this.isInternalValid) {
                this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
        }
        if (tag.m_128441_("Content")) {
            this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            this.energyStorage.setEnergy(infoTag.m_128451_("energy"));
            this.readTagData(infoTag);
            if (!this.isCasingValid || !this.isInternalValid) {
                this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
            if (tag.m_128441_("Content")) {
                this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
            }
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        infoTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        this.saveTagData(infoTag);
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public double getDepletionProgress() {
        return this.recipeInfo.getProgress();
    }

    public double getMaxHeat() {
        return (Double)FissionConfig.FISSION_CONFIG.HEAT_CAPACITY.get();
    }

    public double calculateEfficiency() {
        double mult = this.fuelCellsCount;
        if (this.fuelCellMultiplier > this.fuelCellsCount) {
            mult = (double)this.fuelCellMultiplier / (double)this.fuelCellsCount;
        }
        return (double)this.calculateEnergy() / (this.recipeInfo.energy * mult / 100.0);
    }

    public double getNetHeat() {
        return this.heatPerTick - this.heatSinksCooling();
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasRedstoneSignal() {
        return this.enabledByController || Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public Object[] getFuel() {
        return this.contentHandler.itemHandler.getSlotContent(0);
    }

    public void voidFuel() {
        this.contentHandler.voidSlot(0);
        this.contentHandler.itemHandler.holdedInputs.clear();
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public ItemStack getCurrentFuel() {
        if (!this.hasRecipe()) {
            return ItemStack.f_41583_;
        }
        return ((Recipe)this.recipeInfo.recipe()).getFirstItemStackIngredient(0);
    }

    public List<FissionBoilingRecipe> getBoilingRecipes() {
        if (this.coolantRecipes == null) {
            this.coolantRecipes = NcRecipeType.ALL_RECIPES.get("fission_boiling").getRecipeType().getRecipes(this.m_58904_());
        }
        return this.coolantRecipes;
    }

    public boolean hasCoolant() {
        FluidStack coolant = this.contentHandler.fluidCapability.getFluidInSlot(0);
        if (coolant.isEmpty()) {
            this.boilingRecipe = null;
            return false;
        }
        if (this.boilingRecipe == null) {
            for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
                if (!recipe.getInputFluids()[0].test(coolant)) continue;
                this.boilingRecipe = recipe;
                return true;
            }
        } else if (!this.boilingRecipe.getInputFluids()[0].test(coolant)) {
            this.boilingRecipe = null;
            return false;
        }
        return this.boilingRecipe instanceof FissionBoilingRecipe;
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo.ticksProcessed > 0.0 && !this.recipeInfo.isCompleted();
    }

    public void addIrradiationHeat() {
        this.irradiationHeat += this.irradiationConnections * 15;
    }

    public void enableReactor() {
        this.toggleReactor(true);
    }

    public void toggleReactor(boolean mode) {
        this.controllerEnabled = mode || this.getRedstoneSignal() > 0;
        this.enabledByController = mode;
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    public void adjustModerator(int redstoneSignal) {
        String formatted = String.format(Locale.US, "%.1f", Math.ceil((double)redstoneSignal / 15.0));
        this.targetModerationLevel = Double.parseDouble(formatted);
    }

    public boolean updateModerationLevel() {
        if (Math.abs(this.moderationLevel - this.targetModerationLevel) > 0.005) {
            this.moderationLevel = this.moderationLevel < this.targetModerationLevel ? (this.moderationLevel += 0.0025) : (this.moderationLevel -= 0.0025);
            return true;
        }
        return false;
    }

    public double getModerationLevel() {
        if (this.moderatorsCount == 0) {
            return 1.0;
        }
        return this.moderationLevel;
    }

    public void adjustModerationLevel(int level) {
        String formatted = String.format(Locale.US, "%.2f", (double)Math.max(1, level) / 100.0);
        this.targetModerationLevel = Double.parseDouble(formatted);
    }

    public boolean canAcceptFluid() {
        return this.isSteamMode || this.multiblock().coolantPerTick.size() > 0;
    }

    public boolean hasEnoughCoolant(String coolant, int amount) {
        for (int i = 0; i < this.contentHandler.fluidCapability.tanks.size(); ++i) {
            FluidStack stack = ((FluidTank)this.contentHandler.fluidCapability.tanks.get(i)).getFluid();
            if (!ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).m_135815_().equals(coolant) || stack.getAmount() < amount) continue;
            return true;
        }
        return false;
    }

    public void drainCoolant(String coolant, int amount) {
        for (int i = 0; i < this.contentHandler.fluidCapability.tanks.size(); ++i) {
            FluidStack stack = ((FluidTank)this.contentHandler.fluidCapability.tanks.get(i)).getFluid();
            if (!ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).m_135815_().equals(coolant) || stack.getAmount() < amount) continue;
            ((FluidTank)this.contentHandler.fluidCapability.tanks.get(i)).drain(amount, IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public static class FissionBoilingRecipe
    extends NcRecipe {
        protected double conversionRate;

        public FissionBoilingRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double conversionRate, double powerModifier, double radiation, double rar) {
            super(id, input, output, inputFluids, outputFluids, conversionRate, powerModifier, radiation, rar);
            this.conversionRate = conversionRate;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "fission_boiling";
        }

        @Override
        public String getCodeId() {
            return "fission_boiling";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FissionReactor.FISSION_BLOCKS.get("fission_reactor_controller").get());
        }

        public double conversionRate() {
            return Math.max(this.conversionRate, 1.0);
        }
    }

    public static class Recipe
    extends NcRecipe {
        protected ItemFuel fuelItem;

        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(this.codeId, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return "fission_reactor_controller";
        }

        public ItemFuel getFuelItem() {
            if (this.fuelItem == null) {
                Item item = this.getFirstItemStackIngredient(0).m_41720_();
                if (!(item instanceof ItemFuel) && !item.equals(Items.f_41852_)) {
                    this.fuelItem = new ItemFuel(FissionFuel.ITEM_PROPERTIES, item.toString(), "", "");
                    return this.fuelItem;
                }
                Item item1 = this.getFirstItemStackIngredient(0).m_41720_();
                if (item1 instanceof ItemFuel) {
                    this.fuelItem = (ItemFuel)item1;
                }
            }
            if (this.fuelItem.def == null) {
                this.fuelItem.initDefinition();
            }
            return this.fuelItem;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return ((Block)FissionReactor.FISSION_BLOCKS.get(this.codeId).get()).m_49954_().getString();
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FissionReactor.FISSION_BLOCKS.get(this.codeId).get());
        }

        public int getDepletionTime() {
            if (this.getFuelItem() == null) {
                return 0;
            }
            return (int)((double)(this.getFuelItem().depletion * 20) * this.timeModifier);
        }

        @Override
        public double getEnergy() {
            if (this.getFuelItem() == null) {
                return 0.0;
            }
            return this.getFuelItem().forge_energy;
        }

        public double getHeat() {
            if (this.getFuelItem() == null) {
                return 0.0;
            }
            return this.getFuelItem().heat;
        }

        @Override
        public double getRadiation() {
            return ItemRadiation.byItem(this.getFuelItem()) / 20.0;
        }
    }
}

