/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import igentuman.nc.setup.Registration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class PortalStructure
extends Structure {
    public static final Codec<PortalStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, PortalStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public PortalStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        return context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_()) < 150;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int yy;
        boolean overworld = true;
        if (!PortalStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        blockpos = overworld ? PortalStructure.findSuitableSpot(context, blockpos) : blockpos.m_175288_(40);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(context.f_226627_()));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        LevelHeightAccessor heightAccessor = context.f_226629_();
        int y = blockpos.m_123342_() - 10;
        int minY = heightAccessor.m_141937_() + 20;
        if (y > minY) {
            y = worldgenrandom.m_216332_(minY, y);
        }
        NoiseColumn baseColumn = context.f_226622_().m_214184_(blockpos.m_123341_(), blockpos.m_123343_(), heightAccessor, context.f_226624_());
        int lower = heightAccessor.m_141937_() + 3;
        for (yy = y; yy > lower && !baseColumn.m_183556_(yy).m_60795_(); --yy) {
        }
        if (yy > lower) {
            while (yy > lower && baseColumn.m_183556_(yy).m_60795_()) {
                --yy;
            }
            if (yy > lower) {
                y = yy + 1;
            }
        }
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), y, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    @NotNull
    private static BlockPos findSuitableSpot(Structure.GenerationContext context, BlockPos blockpos) {
        int yy;
        LevelHeightAccessor heightAccessor = context.f_226629_();
        int y = context.f_226622_().m_214096_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, context.f_226624_());
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(context.f_226627_()));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        y = worldgenrandom.m_216332_(heightAccessor.m_141937_() + 20, y - 10);
        NoiseColumn baseColumn = context.f_226622_().m_214184_(blockpos.m_123341_(), blockpos.m_123343_(), heightAccessor, context.f_226624_());
        int lower = heightAccessor.m_141937_() + 3;
        for (yy = y; yy > lower && !baseColumn.m_183556_(yy).m_60795_(); --yy) {
        }
        if (yy > lower) {
            while (yy > lower && baseColumn.m_183556_(yy).m_60795_()) {
                --yy;
            }
            if (yy > lower) {
                y = yy + 1;
            }
        }
        return blockpos.m_175288_(y);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)Registration.PORTAL.get();
    }
}

