/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TextUtils {
    public static MutableComponent applyFormat(Component component, ChatFormatting ... color) {
        Style style = component.m_7383_();
        for (ChatFormatting format : color) {
            style = style.m_131157_(format);
        }
        return component.m_6881_().m_6270_(style);
    }

    public static String numberFormat(double value) {
        String preffix = "";
        if (value < 1.0 && value > 0.0) {
            preffix = "0";
        }
        if (value > -1.0 && value < 0.0) {
            preffix = "0";
        }
        DecimalFormat df = new DecimalFormat("#.0");
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return preffix + df.format(value);
    }

    public static String roundFormat(double value) {
        String preffix = "";
        if (value < 1.0 && value > 0.0) {
            preffix = "0";
        }
        if (value > -1.0 && value < 0.0) {
            preffix = "0";
        }
        DecimalFormat df = new DecimalFormat("#.0");
        if (preffix.isEmpty()) {
            df = new DecimalFormat("#");
        }
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return preffix + df.format(value);
    }

    public static String scaledFormat(double value) {
        if (value >= 1.0E9) {
            return TextUtils.numberFormat(value / 1.0E9) + "G";
        }
        if (value >= 1000000.0) {
            return TextUtils.numberFormat(value / 1000000.0) + "M";
        }
        if (value >= 1000.0) {
            return TextUtils.numberFormat(value / 1000.0) + "k";
        }
        return TextUtils.numberFormat(value);
    }

    public static String convertToName(String key) {
        String[] parts;
        StringBuilder result = new StringBuilder();
        for (String l : parts = key.split("_|/")) {
            if (l.isEmpty()) continue;
            if (result.length() == 0) {
                result = new StringBuilder(l.substring(0, 1).toUpperCase() + l.substring(1));
                continue;
            }
            result.append(" ").append(l.substring(0, 1).toUpperCase()).append(l.substring(1));
        }
        return TextUtils.applySpeccialRules(result.toString());
    }

    public static String applySpeccialRules(String val) {
        val = val.replace("Rtg", "RTG");
        val = val.replace("Du", "DU");
        val = val.replace("Tbu", "TBU");
        val = val.replace("Bssco", "BSSCO");
        val = val.replace("Rf", "RF");
        return val;
    }
}

