/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public class DirectionUtil {
    public static final Direction[] VALUES = Direction.values();
    public static final Direction[] BY_HORIZONTAL_INDEX = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.m_122434_().m_122479_()).sorted(Comparator.comparingInt(Direction::m_122416_)).toArray(Direction[]::new);

    public static Rotation getRotationBetweenFacings(Direction orig, Direction to) {
        if (to == orig) {
            return Rotation.NONE;
        }
        if (orig.m_122434_() == Direction.Axis.Y || to.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        if ((orig = orig.m_122427_()) == to) {
            return Rotation.CLOCKWISE_90;
        }
        if ((orig = orig.m_122427_()) == to) {
            return Rotation.CLOCKWISE_180;
        }
        if ((orig = orig.m_122427_()) == to) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return null;
    }

    public static Direction rotateAround(Direction d, Direction.Axis axis) {
        if (axis == d.m_122434_()) {
            return d;
        }
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> DirectionUtil.rotateX(d);
            case Direction.Axis.Y -> d.m_122427_();
            case Direction.Axis.Z -> DirectionUtil.rotateZ(d);
        };
    }

    public static Direction rotateX(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + d);
        };
    }

    public static Direction rotateZ(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + d);
        };
    }
}

