/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class TurbineRecipeSerializer<RECIPE extends NcRecipe>
extends NcRecipeSerializer<RECIPE> {
    public TurbineRecipeSerializer(NcRecipeSerializer.IFactory factory) {
        super(factory);
    }

    @Override
    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        FluidStackIngredient[] inputFluids = new FluidStackIngredient[]{};
        try {
            if (json.has("inputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"inputFluids")) {
                    JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"inputFluids");
                    inputFluids = new FluidStackIngredient[input.getAsJsonArray().size()];
                    int i = 0;
                    for (Object in : input.getAsJsonArray()) {
                        inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)in);
                        ++i;
                    }
                } else {
                    JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"inputFluids");
                    inputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)inputJson)};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse input fluid for recipe: " + recipeId);
        }
        FluidStackIngredient[] outputFluids = new FluidStackIngredient[]{};
        try {
            if (json.has("outputFluids")) {
                if (GsonHelper.m_13885_((JsonObject)json, (String)"outputFluids")) {
                    JsonArray output = GsonHelper.m_13933_((JsonObject)json, (String)"outputFluids");
                    outputFluids = new FluidStackIngredient[output.getAsJsonArray().size()];
                    int i = 0;
                    for (JsonElement out : output.getAsJsonArray()) {
                        outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)out.getAsJsonObject());
                        ++i;
                    }
                } else {
                    JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluids");
                    outputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)output.getAsJsonObject())};
                }
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse output fluid for recipe: " + recipeId);
        }
        double heatRequired = 1.0;
        try {
            heatRequired = GsonHelper.m_144742_((JsonObject)json, (String)"heatRequired", (double)1.0);
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse params for recipe: " + recipeId);
        }
        return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], inputFluids, outputFluids, heatRequired, 1.0, 1.0, 1.0);
    }

    @Override
    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            this.readIngredients(buffer);
            double heatRequired = buffer.readDouble();
            double powerModifier = buffer.readDouble();
            double radiation = buffer.readDouble();
            return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], this.inputFluids, this.outputFluids, heatRequired, 1.0, 1.0, 1.0);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error reading from packet.", (Throwable)e);
            throw e;
        }
    }
}

