/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient;

import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class HashedFluid {
    @NotNull
    private final FluidStack fluidStack;
    private final int hashCode;

    public static HashedFluid create(@NotNull FluidStack stack) {
        return new HashedFluid(new FluidStack(stack, 1));
    }

    public static HashedFluid raw(@NotNull FluidStack stack) {
        return new HashedFluid(stack);
    }

    private HashedFluid(@NotNull FluidStack stack) {
        this.fluidStack = stack;
        this.hashCode = this.initHashCode();
    }

    @NotNull
    public FluidStack getStack() {
        return this.fluidStack;
    }

    @NotNull
    public FluidStack createStack(int size) {
        if (size <= 0 || this.fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.fluidStack, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HashedFluid)) return false;
        HashedFluid other = (HashedFluid)obj;
        if (this.fluidStack.isEmpty()) return false;
        if (!this.fluidStack.isFluidEqual(other.fluidStack)) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        int code = 1;
        code = 31 * code + this.fluidStack.getFluid().hashCode();
        if (this.fluidStack.hasTag()) {
            code = 31 * code + this.fluidStack.getTag().hashCode();
        }
        return code;
    }
}

