/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.client.NcClient;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.INcRecipeTypeProvider;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.registry.RecipeTypeDeferredRegister;
import igentuman.nc.registry.RecipeTypeRegistryObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NcRecipeType<RECIPE extends NcRecipe>
implements RecipeType<RECIPE>,
INcRecipeTypeProvider<RECIPE> {
    public static final RecipeTypeDeferredRegister RECIPE_TYPES = new RecipeTypeDeferredRegister("nuclearcraft");
    public static final HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> ALL_RECIPES = NcRecipeType.initializeRecipes();
    private List<RECIPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    public boolean isLoaded = false;

    private static HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> initializeRecipes() {
        HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> recipes = new HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>>();
        recipes.put(FissionControllerBE.NAME, NcRecipeType.register(FissionControllerBE.NAME));
        recipes.put("nc_ore_veins", NcRecipeType.register("nc_ore_veins"));
        recipes.put("fusion_core", NcRecipeType.register("fusion_core"));
        recipes.put("fusion_coolant", NcRecipeType.register("fusion_coolant"));
        recipes.put("fission_boiling", NcRecipeType.register("fission_boiling"));
        recipes.put(TurbineControllerBE.NAME, NcRecipeType.register(TurbineControllerBE.NAME));
        for (String processorName : Processors.registered().keySet()) {
            if (!Processors.registered().get(processorName).hasRecipes()) continue;
            recipes.put(processorName, NcRecipeType.register(processorName));
        }
        return recipes;
    }

    public static <RECIPE extends NcRecipe> RecipeTypeRegistryObject<RECIPE> register(String name) {
        return RECIPE_TYPES.register(name, () -> new NcRecipeType(name));
    }

    private NcRecipeType(String name) {
        this.registryName = NuclearCraft.rl(name);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public NcRecipeType<RECIPE> getRecipeType() {
        return this;
    }

    @Override
    @NotNull
    public List<RECIPE> getRecipes(@Nullable Level world) {
        if (world == null && (world = (Level)DistExecutor.unsafeRunForDist(() -> NcClient::tryGetClientWorld, () -> () -> ServerLifecycleHooks.getCurrentServer().m_129783_())) == null) {
            return this.cachedRecipes;
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            List recipes = recipeManager.m_44013_((RecipeType)this);
            this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
        }
        return this.cachedRecipes;
    }

    public static <C extends Container, RECIPE_TYPE extends Recipe<C>> Optional<RECIPE_TYPE> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, C inventory, Level level) {
        return level.m_7465_().m_44015_(recipeType, inventory, level).filter(recipe -> !recipe.m_142505_());
    }

    public static Optional<? extends Recipe<?>> byKey(Level level, ResourceLocation id) {
        return level.m_7465_().m_44043_(id).filter(recipe -> !recipe.m_142505_());
    }

    public void loadRecipes(Level level) {
        if (this.isLoaded) {
            return;
        }
        this.getRecipes(level);
        this.isLoaded = true;
    }

    public void loadRecipes(RecipeManager manager) {
        this.getRecipes(manager);
        this.isLoaded = true;
    }

    private void getRecipes(RecipeManager manager) {
        List recipes = manager.m_44013_((RecipeType)this);
        this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
    }
}

