/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerWrapper
implements IFluidHandler {
    private final FluidCapabilityHandler handler;
    private final BiPredicate<Integer, FluidStack> insert;
    private final Predicate<Integer> extract;
    private final SidedContentHandler.RelativeDirection direction;

    public FluidHandlerWrapper(FluidCapabilityHandler handler, SidedContentHandler.RelativeDirection direction, BiPredicate<Integer, FluidStack> insert, Predicate<Integer> extract) {
        this.handler = handler;
        this.direction = direction;
        this.insert = insert;
        this.extract = extract;
    }

    public int getTanks() {
        return this.handler.tanks.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return ((FluidTank)this.handler.tanks.get(tank)).getFluidInTank(0);
    }

    public int getTankCapacity(int tank) {
        return ((FluidTank)this.handler.tanks.get(tank)).getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return ((FluidTank)this.handler.tanks.get(tank)).isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (SlotModePair pair : (SlotModePair[])this.handler.sideMap.get(this.direction.ordinal())) {
            FluidTank tank;
            if (!this.insert.test(pair.getSlot(), resource) || !(tank = (FluidTank)this.handler.tanks.get(pair.getSlot())).isFluidValid(pair.getSlot(), resource)) continue;
            return tank.fill(resource.copy(), action);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (SlotModePair pair : (SlotModePair[])this.handler.sideMap.get(this.direction.ordinal())) {
            if (!this.extract.test(pair.getSlot()) || !resource.isFluidEqual(((FluidTank)this.handler.tanks.get(pair.getSlot())).getFluid())) continue;
            FluidTank tank = (FluidTank)this.handler.tanks.get(pair.getSlot());
            return tank.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (SlotModePair pair : (SlotModePair[])this.handler.sideMap.get(this.direction.ordinal())) {
            if (!this.extract.test(pair.getSlot())) continue;
            FluidTank tank = (FluidTank)this.handler.tanks.get(pair.getSlot());
            return tank.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }
}

