/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.AbstractCapabilityHandler;
import igentuman.nc.handler.sided.capability.FluidHandlerWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidCapabilityHandler
extends AbstractCapabilityHandler
implements INBTSerializable<CompoundTag> {
    public final NonNullList<FluidTank> tanks;
    public final NonNullList<LazyOptional<IFluidHandler>> fluidCapabilites;
    protected FluidStack[] sortedFluids;
    public List<FluidStack> holdedInputs = new ArrayList<FluidStack>();
    private Map<Direction, LazyOptional<FluidHandlerWrapper>> handlerCache = new HashMap<Direction, LazyOptional<FluidHandlerWrapper>>();
    public HashMap<Integer, List<FluidStack>> allowedFluids;

    public FluidCapabilityHandler(int inputSlots, int outputSlots, int inputCapacity, int outputCapacity) {
        int finalI;
        this.tanks = NonNullList.m_122779_();
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.fluidCapabilites = NonNullList.m_122779_();
        int i = 0;
        while (i < inputSlots) {
            finalI = i++;
            this.tanks.add((Object)new FluidTank(inputCapacity * 1000));
            this.fluidCapabilites.add((Object)LazyOptional.of(() -> (IFluidHandler)this.tanks.get(finalI)));
        }
        i = inputSlots - 1;
        while (i < inputSlots + outputSlots) {
            finalI = i++;
            this.tanks.add((Object)new FluidTank(outputCapacity * 1000));
            this.fluidCapabilites.add((Object)LazyOptional.of(() -> (IFluidHandler)this.tanks.get(finalI)));
        }
        this.initDefault();
    }

    public LazyOptional<FluidHandlerWrapper> getCapability(Direction side) {
        if (side == null) {
            return this.getCapability();
        }
        if (!this.handlerCache.containsKey(side)) {
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
            this.handlerCache.put(side, (LazyOptional<FluidHandlerWrapper>)LazyOptional.of(() -> new FluidHandlerWrapper(this, relativeDirection, (i, f) -> this.inputAllowed((Integer)i, (FluidStack)f, side), i -> this.outputAllowed((Integer)i, side))));
        }
        return this.handlerCache.get(side);
    }

    public boolean inputAllowed(Integer i, FluidStack fluid, Direction side) {
        if (side == null) {
            return true;
        }
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
        SlotModePair.SlotMode mode = ((SlotModePair[])this.sideMap.get(relativeDirection.ordinal()))[i].getMode();
        return (mode == SlotModePair.SlotMode.INPUT || mode == SlotModePair.SlotMode.PULL) && this.isValidSlotFluid(i, fluid) && this.isValidForInputSlot(i, fluid);
    }

    public boolean isValidSlotFluid(int id, FluidStack fluid) {
        if (this.allowedFluids == null) {
            return true;
        }
        if (!this.allowedFluids.containsKey(id)) {
            return true;
        }
        for (FluidStack stack : this.allowedFluids.get(id)) {
            if (!stack.isFluidEqual(fluid)) continue;
            return true;
        }
        return this.allowedFluids.isEmpty() || !this.allowedFluids.containsKey(id);
    }

    public boolean outputAllowed(Integer i, Direction side) {
        if (side == null) {
            return true;
        }
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
        SlotModePair.SlotMode mode = ((SlotModePair[])this.sideMap.get(relativeDirection.ordinal()))[i].getMode();
        return (mode == SlotModePair.SlotMode.OUTPUT || mode == SlotModePair.SlotMode.PUSH || mode == SlotModePair.SlotMode.PUSH_EXCESS) && this.getFluidInSlot(i).getAmount() > 0;
    }

    public <T> LazyOptional<T> getCapability() {
        for (Direction side : Direction.values()) {
            for (SlotModePair slotModePair : (SlotModePair[])this.sideMap.get(side.ordinal())) {
                if (slotModePair.getMode() == SlotModePair.SlotMode.DISABLED) continue;
                return ((LazyOptional)this.fluidCapabilites.get(slotModePair.getSlot())).cast();
            }
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.tanks.size(); ++i) {
            tag.m_128365_("tank" + i, (Tag)((FluidTank)this.tanks.get(i)).writeToNBT(new CompoundTag()));
        }
        tag.m_128405_("size", this.tanks.size());
        if (this.sideMapUpdated) {
            this.sideMapUpdated = false;
            tag.m_128365_("sideMap", SidedContentHandler.serializeSideMap(this.sideMap));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            ((FluidTank)this.tanks.get(i)).readFromNBT(nbt.m_128469_("tank" + i));
        }
        if (!nbt.m_128469_("sideMap").m_128456_()) {
            this.sideMap = SidedContentHandler.deserializeSideMap(nbt.m_128469_("sideMap"));
        }
        this.onLoad();
    }

    public boolean pushFluids(Direction dir) {
        return this.pushFluids(dir, false, this.tile.m_58899_());
    }

    public boolean pushFluids(Direction dir, boolean forceFlag, BlockPos pos) {
        BlockEntity be = this.tile.m_58904_().m_7702_(pos.m_121945_(dir));
        if (be == null) {
            return false;
        }
        LazyOptional cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
        if (cap.isPresent()) {
            IFluidHandler handler = (IFluidHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                FluidTank tank;
                if (pair.getMode() != SlotModePair.SlotMode.PUSH && !forceFlag || (tank = (FluidTank)this.tanks.get(pair.getSlot())).getFluidAmount() <= 0) continue;
                int amount = handler.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public boolean pullFluids(Direction dir) {
        return this.pullFluids(dir, false, this.tile.m_58899_());
    }

    public boolean pullFluids(Direction dir, boolean forceFlag, BlockPos pos) {
        BlockEntity be = this.tile.m_58904_().m_7702_(pos.m_121945_(dir));
        if (be == null) {
            return false;
        }
        LazyOptional cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
        if (cap.isPresent()) {
            IFluidHandler handler = (IFluidHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                FluidTank tank;
                if (pair.getMode() != SlotModePair.SlotMode.PULL && !forceFlag || (tank = (FluidTank)this.tanks.get(pair.getSlot())).getFluidAmount() >= tank.getCapacity()) continue;
                int amount = tank.fill(handler.drain(tank.getCapacity() - tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                return amount > 0;
            }
        }
        return false;
    }

    public FluidStack getFluidInSlot(int i) {
        return ((FluidTank)this.tanks.get(i)).getFluid();
    }

    public String getCacheKey() {
        Object key = "";
        if (this.sortedFluids == null) {
            this.sortedFluids = new FluidStack[this.inputSlots];
            for (int i = 0; i < this.inputSlots; ++i) {
                this.sortedFluids[i] = this.getFluidInSlot(i);
            }
            Arrays.sort(this.sortedFluids, Comparator.comparing(fluidStack -> fluidStack.getFluid().toString()));
        }
        for (FluidStack tank : this.sortedFluids) {
            key = (String)key + tank.getFluid().toString();
        }
        return key;
    }

    public boolean isValidForInputSlot(int i, FluidStack fluid) {
        if (this.outputAllowed(i, null)) {
            FluidStack stack = this.getFluidInSlot(i);
            if (stack.isEmpty()) {
                return true;
            }
            if (stack.isFluidEqual(fluid)) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidForOutputSlot(int i, FluidStack outputFluid) {
        if (this.outputAllowed(i, null)) {
            FluidStack stack = this.getFluidInSlot(i);
            if (stack.isEmpty()) {
                return this.isValidSlotFluid(i, outputFluid);
            }
            if (stack.isFluidEqual(outputFluid)) {
                return true;
            }
        }
        return false;
    }

    public boolean canPushExcessFluid(int i, FluidStack outputFluid) {
        for (Direction dir : Direction.values()) {
            LazyOptional cap;
            BlockEntity be = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_121945_(dir));
            if (be == null || !(cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_())).isPresent()) continue;
            IFluidHandler handler = (IFluidHandler)cap.orElse(null);
            SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
            for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                int amount;
                if (pair.getSlot() != i || pair.getMode() != SlotModePair.SlotMode.PUSH && pair.getMode() != SlotModePair.SlotMode.PUSH_EXCESS || (amount = handler.fill(outputFluid, IFluidHandler.FluidAction.SIMULATE)) != outputFluid.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack insertFluidInternal(int i, FluidStack toOutput, boolean b) {
        FluidStack stack = this.getFluidInSlot(i);
        if (stack.isEmpty()) {
            if (!b) {
                ((FluidTank)this.tanks.get(i)).fill(toOutput, IFluidHandler.FluidAction.EXECUTE);
            }
            return FluidStack.EMPTY;
        }
        if (stack.isFluidEqual(toOutput)) {
            int amount = ((FluidTank)this.tanks.get(i)).fill(toOutput, IFluidHandler.FluidAction.SIMULATE);
            if (amount == toOutput.getAmount()) {
                if (!b) {
                    ((FluidTank)this.tanks.get(i)).fill(toOutput, IFluidHandler.FluidAction.EXECUTE);
                }
                return FluidStack.EMPTY;
            }
            FluidStack result = toOutput.copy();
            result.shrink(amount);
            return result;
        }
        return toOutput;
    }

    public FluidStack pushExcessFluid(int i, FluidStack toOutput) {
        int n = 0;
        Direction[] directionArray = Direction.values();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction dir = directionArray[n];
            BlockEntity be = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_121945_(dir));
            if (be == null) {
                return toOutput;
            }
            LazyOptional cap = be.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_());
            if (cap.isPresent()) {
                IFluidHandler handler = (IFluidHandler)cap.orElse(null);
                SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(dir, this.getFacing());
                for (SlotModePair pair : (SlotModePair[])this.sideMap.get(relativeDirection.ordinal())) {
                    FluidTank tank;
                    if (pair.getMode() != SlotModePair.SlotMode.PUSH_EXCESS || (tank = (FluidTank)this.tanks.get(pair.getSlot())).getFluidAmount() <= 0 || !toOutput.getFluid().equals(tank.getFluid().getFluid()) || handler.fill(toOutput, IFluidHandler.FluidAction.SIMULATE) != toOutput.getAmount()) continue;
                    int amount = handler.fill(toOutput, IFluidHandler.FluidAction.EXECUTE);
                    return FluidStack.EMPTY;
                }
            }
            return toOutput;
        }
        return toOutput;
    }

    public void voidSlot(int slotId) {
        ((FluidTank)this.tanks.get(slotId)).setFluid(FluidStack.EMPTY);
    }

    public Object[] getSlotContent(int slotIdFromGlobalId) {
        FluidStack stack = ((FluidTank)this.tanks.get(slotIdFromGlobalId)).getFluid();
        if (stack.isEmpty()) {
            return new Object[0];
        }
        return new Object[]{ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString(), stack.getAmount()};
    }

    public boolean canPush() {
        for (int i = this.inputSlots; i < this.getSlots(); ++i) {
            if (this.getFluidInSlot(i).getAmount() <= 0) continue;
            return true;
        }
        return false;
    }

    private int getSlots() {
        return this.tanks.size();
    }

    public boolean canPull() {
        for (int i = 0; i < this.inputSlots; ++i) {
            if (this.getFluidInSlot(i).getAmount() >= ((FluidTank)this.tanks.get(i)).getCapacity()) continue;
            return true;
        }
        return false;
    }
}

