/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler;

import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.type.OreVeinRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class OreVeinProvider {
    private ServerLevel level;
    protected List<OreVeinRecipe> recipes;
    protected static Map<Level, OreVeinProvider> providers = new HashMap<Level, OreVeinProvider>();
    private int rolls = 0;

    private OreVeinProvider(ServerLevel level) {
        this.level = level;
        this.recipes = level.m_7465_().m_44013_(NcRecipeType.ALL_RECIPES.get("nc_ore_veins").getRecipeType());
    }

    public boolean chunkContainsVein(int chunkX, int chunkZ) {
        return this.rand(chunkX, chunkZ, new int[0]).nextInt((Integer)ProcessorsConfig.IN_SITU_LEACHING.VEINS_RARITY.get()) <= 10;
    }

    public int getVeinSize(int x, int z) {
        List range = (List)ProcessorsConfig.IN_SITU_LEACHING.VEIN_BLOCKS_AMOUNT.get();
        return this.rand(x, z, new int[0]).nextInt((Integer)range.get(1) - (Integer)range.get(0)) + (Integer)range.get(0);
    }

    public Random rand(int x, int z, int ... seeds) {
        int additional = 0;
        for (int seed : seeds) {
            additional += seed;
        }
        return new Random(this.level.m_7328_() / 2L + (long)x + (long)z + (long)additional);
    }

    public static OreVeinProvider get(ServerLevel level) {
        if (!providers.containsKey(level)) {
            providers.put((Level)level, new OreVeinProvider(level));
        }
        return providers.get(level);
    }

    public OreVeinRecipe selectRandomVein(Random random, int x, int z) {
        OreVeinRecipe recipe = this.recipes.get(random.nextInt(this.recipes.size()));
        if (recipe.rarityModifier > (double)this.rolls) {
            return this.selectRandomVein(this.rand(x, z, ++this.rolls), x, z);
        }
        this.rolls = 0;
        return recipe;
    }

    public OreVeinRecipe getVeinForChunk(int chunkX, int chunkZ) {
        if (!this.chunkContainsVein(chunkX, chunkZ)) {
            return null;
        }
        return this.selectRandomVein(this.rand(chunkX, chunkZ, new int[0]), chunkX, chunkZ);
    }
}

