/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler;

import igentuman.nc.util.CustomEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemEnergyHandler
implements ICapabilityProvider {
    private final int storage;
    private final int output;
    private final int input;
    protected final LazyOptional<ItemEnergy> energy = LazyOptional.of(this::createEnergy);
    public ItemStack stack;

    private ItemEnergy createEnergy() {
        return new ItemEnergy(this.stack, this.capacity(), this.chargeRate(), this.sendRate());
    }

    public int sendRate() {
        return this.output;
    }

    public int chargeRate() {
        return this.input;
    }

    public int capacity() {
        return this.storage;
    }

    public int getEnergyStored() {
        return ((IEnergyStorage)this.getCapability(ForgeCapabilities.ENERGY, null).orElse(null)).getEnergyStored();
    }

    public ItemEnergyHandler(ItemStack stack, int storage, int output, int input) {
        this.stack = stack;
        this.storage = storage;
        this.output = output;
        this.input = input;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }

    public class ItemEnergy
    extends CustomEnergyStorage {
        private ItemStack stack;

        public ItemEnergy(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
            this.stack = stack;
            this.energy = stack.m_41784_().m_128441_("energy") ? stack.m_41784_().m_128451_("energy") : 0;
        }

        @Override
        public int extractEnergy(int extract, boolean simulate) {
            int amount = super.extractEnergy(extract, simulate);
            if (!simulate) {
                this.stack.m_41784_().m_128405_("energy", this.energy);
            }
            return amount;
        }

        @Override
        public int receiveEnergy(int receieve, boolean simulate) {
            int amount = super.receiveEnergy(receieve, simulate);
            if (!simulate) {
                this.stack.m_41784_().m_128405_("energy", this.energy);
            }
            return amount;
        }
    }
}

