/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen;

import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.Fuel;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class NCLanguageProvider
extends LanguageProvider {
    public NCLanguageProvider(DataGenerator gen, String locale) {
        super(gen.getPackOutput(), "nuclearcraft", locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.nuclearcraft_items", "NuclearCraft Items");
        this.add("itemGroup.nuclearcraft_blocks", "NuclearCraft Blocks");
        this.add("itemGroup.nuclearcraft_fission_reactor", "NuclearCraft Fission Reactor");
        this.add("itemGroup.nuclearcraft_fusion_reactor", "NuclearCraft Fusion Reactor");
        this.add("itemGroup.nuclearcraft_fluids", "NuclearCraft Fluids");
        this.add("itemGroup.nuclearcraft_turbine", "NuclearCraft Turbine");
        this.ores();
        this.ingots();
        this.plates();
        this.dusts();
        this.nuggets();
        this.gems();
        this.parts();
        this.chunks();
        this.blocks();
        this.food();
        this.armor();
        this.records();
        this.tools();
        this.items();
        this.fuel();
        this.tooltips();
        this.isotopes();
        this.shielding();
        this.buckets();
        this.fluids();
        this.processors();
        this.energyBlocks();
        this.multiblocks();
        this.labels();
        this.messages();
        this.storageBlocks();
        this.sounds();
    }

    private void messages() {
        this.add("message.nc.player_radiation_contamination", "Radiation Dose: %s");
        this.add("message.nc.geiger_radiation_measure", "Radiation Level: %s");
        this.add("death.attack.radiation", "Died of Radiation Poisoning");
    }

    private void sounds() {
        this.add("music.hyperspace", "Hyperspace");
        this.add("music.end_of_the_world", "End of the World");
        this.add("music.wanderer", "Wanderer");
        this.add("music.money_for_nothing", "Money For Nothing");
        this.add("sound_event.nuclearcraft.item.geiger_1", "Geiger Counter Ticks Level 1 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_2", "Geiger Counter Ticks Level 2 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_3", "Geiger Counter Ticks Level 3 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_4", "Geiger Counter Ticks Level 4 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_5", "Geiger Counter Ticks Level 5 Intensity");
        this.add("sound_event.nuclearcraft.fusion.ready", "Fusion Reactor Ready");
        this.add("sound_event.nuclearcraft.fusion.running", "Fusion Reactor Running");
        this.add("sound_event.nuclearcraft.fusion.charging", "Fusion Reactor Charging");
        this.add("sound_event.nuclearcraft.fusion.switch", "Fusion Reactor Switch");
        this.add("sound_event.nuclearcraft.fission_reactor", "Fission Reactor Ticking");
    }

    private void labels() {
        this.add("nc.guide_book.name", "NuclearCraft Guide");
        this.add("nc.guide_book.desc", "Basics and advanced topics about NuclearCraft");
        this.add("nc.guide_book.edition", "Neoteric Edition");
        this.add("fusion_core.rf_amplifiers.power", "RF Amplifiers: %s%%");
        this.add("fusion_core.stability", "Plasma Stability: %s%%");
        this.add("nc.label.leacher_wrong_position", "Wrong Position");
        this.add("nc.label.leacher_no_source", "No Data Source");
        this.add("nc.label.leacher_no_acid", "No Acid");
        this.add("block.nuclearcraft.glowing_mushroom", "Glowing Mushroom");
        this.add("fusion_core", "Fusion Reactor Core");
        this.add("fusion_core.efficiency", "Efficiency: %s%%");
        this.add("nc_jei_cat.fusion_core", "Fusion Reactor");
        this.add("nc_jei_cat.fusion_coolant", "Fusion Reactor Coolant");
        this.add("nc_jei_cat.mek_chemical_conversion", "NC - GAS -> Fluid Conversion");
        this.add("nc_jei_cat.fission_boiling", "Boiling Reactor");
        this.add("reactor.size", "Structure size: %sx%sx%s");
        this.add("fission.casing.wrong.block", "Wrong block at: %s");
        this.add("fission_reactor.efficiency", "Efficiency: %s%%");
        this.add("fission_reactor.net_heat", "Net Heat: %s H/t");
        this.add("fission.casing.reactor_incomplete", "Reactor Incomplete");
        this.add("fission_reactor.heat_multiplier", "Heat Multiplier: %sx");
        this.add("processor_side_config.title", "Select Slot");
        this.add("processor_slot_mode.title", "Slot Mode");
        this.add("message.heat_sink.valid0", "This one is looking good");
        this.add("message.heat_sink.valid1", "I like this one");
        this.add("message.heat_sink.valid2", "This heat sink design shows promise");
        this.add("message.heat_sink.valid3", "The heat dissipation capability looks good");
        this.add("message.heat_sink.valid4", "The thermal conductivity appears to be efficient");
        this.add("message.heat_sink.valid5", "Attention to detail is evident in this design");
        this.add("message.heat_sink.valid6", "This heat sink design seems promising for our project");
        this.add("message.heat_sink.valid7", "Attention to detail is impressive");
        this.add("message.heat_sink.valid8", "This is a perfect fit for our application");
        this.add("message.heat_sink.valid9", "This meets our standards very well");
        this.add("message.heat_sink.invalid0", "Not sure if it's valid");
        this.add("message.heat_sink.invalid1", "Maybe you should check it again");
        this.add("message.heat_sink.invalid2", "Hm...");
        this.add("message.heat_sink.invalid3", "Will it explode? -Shouldn't");
        this.add("message.heat_sink.invalid4", "This doesn't seem to meet our standards.");
        this.add("message.heat_sink.invalid5", "There are some concerns about the validity of this.");
        this.add("message.heat_sink.invalid6", "I have some reservations about this.");
        this.add("message.heat_sink.invalid7", "This may not be suitable for our project.");
        this.add("message.heat_sink.invalid8", "This may need some significant revisions before it can be considered valid.");
        this.add("message.heat_sink.invalid9", "More work may be needed before this can be considered valid.");
        this.add("nc_jei_cat.fission_reactor_controller", "Fission Reactor Fuel Depletion");
        this.add("nc_jei_cat.nc_ore_veins", "Ore Veins");
        this.add("container.nc.storage", "Item Storage Container");
    }

    private void multiblocks() {
        String title;
        for (String name : FissionReactor.FISSION_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)FissionReactor.FISSION_BLOCKS.get(name).get(), title);
        }
        for (String name : TurbineRegistration.TURBINE_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)TurbineRegistration.TURBINE_BLOCKS.get(name).get(), title);
        }
        for (String name : FusionReactor.FUSION_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)FusionReactor.FUSION_BLOCKS.get(name).get(), title);
        }
        this.add((Block)FusionReactor.FUSION_CORE_PROXY.get(), "Fusion Reactor Core");
    }

    private void storageBlocks() {
        for (String name : NCStorageBlocks.STORAGE_BLOCKS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), title);
        }
    }

    private void energyBlocks() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), title);
        }
    }

    private void processors() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCProcessors.PROCESSORS.get(name).get(), title);
            this.add("nc_jei_cat." + name, title);
        }
    }

    private void buckets() {
        for (String name : NCFluids.NC_MATERIALS.keySet()) {
            String molten = "";
            if (NCItems.NC_INGOTS.containsKey(name)) {
                molten = "Molten ";
            }
            this.add((Item)NCFluids.NC_MATERIALS.get(name).getBucket(), "Bucket of " + molten + TextUtils.convertToName(name));
        }
        for (String name : NCFluids.NC_GASES.keySet()) {
            this.add((Item)NCFluids.NC_GASES.get(name).getBucket(), "Bucket of " + TextUtils.convertToName(name));
        }
    }

    private void fluids() {
        for (String name : NCFluids.NC_MATERIALS.keySet()) {
            String molten = "";
            if (NCItems.NC_INGOTS.containsKey(name)) {
                molten = "Molten ";
            }
            this.add("fluid_type." + NCFluids.NC_MATERIALS.get(name).type().getId().m_214298_(), molten + TextUtils.convertToName(name));
        }
        for (String name : NCFluids.NC_GASES.keySet()) {
            this.add("fluid_type." + NCFluids.NC_GASES.get(name).type().getId().m_214298_(), TextUtils.convertToName(name));
        }
    }

    private void shielding() {
        for (String name : NCItems.NC_SHIELDING.keySet()) {
            this.add((Item)NCItems.NC_SHIELDING.get(name).get(), TextUtils.convertToName(name) + " Shielding");
        }
    }

    private void tooltips() {
        this.add("tooltip.nc.jei.gas_to_fluid.desc", "NC blocks automatically converts Mek Gasses into Fluids during input");
        this.add("tooltip.nc.hev.desc", "Grants additional protection and passive effects when charged");
        this.add("tooltip.nc.moderator.desc", "Fission Reactor moderator. Has to be placed next to fuel cell. \n Each adjacent with fuel cell adds +%s%% efficiency and +%s%% heat gen");
        this.add("boiling.recipe.heat_required", "Heat required: %s H");
        this.add("processor.recipe.power", "Process Power: %s FE/t");
        this.add("processor.recipe.duration", "Process Duration: %s t");
        this.add("processor.recipe.radiation", "Process Radiation: %s uRad");
        this.add("fusion_core.charge", "Charging: %s%%");
        this.add("fusion_core.recipe.cooling_rate", "Cooling Rate: %s H");
        this.add("fusion_core.recipe.power", "Base Energy Generation: %s FE/t");
        this.add("fusion_core.recipe.duration", "Reaction Duration: %s t");
        this.add("fusion_core.recipe.radiation", "Reaction Radiation: %s uRad");
        this.add("fusion_core.recipe.temperature", "Optimal Temperature: %s MK");
        this.add("fission.recipe.power", "Base Energy Generation: %s FE/t");
        this.add("fission.recipe.duration", "Depletion Time: %s s");
        this.add("fission.recipe.radiation", "Reaction Radiation: %s pRad");
        this.add("fission.recipe.heat", "Heat Generation: %s H/t");
        this.add("gui.nc.reactor_mode.tooltip_steam", "Boiling Mode");
        this.add("gui.nc.reactor_mode.tooltip_energy", "Energy Mode");
        this.add("gui.nc.reactor_mode.timer", "Changing mode in: %s sec");
        this.add("reactor.steam_per_tick", "Boiling rate: %s mB/t");
        this.add("tooltip.nc.fusion_connector.descr", "Used to connect fusion core and toroidal reactor chamber");
        this.add("tooltip.nc.fusion_casing.descr", "Used to build toroidal fusion reactor chamber");
        this.add("tooltip.nc.rf_amplifier.not_found", "No RF Amplifiers attached");
        this.add("tooltip.nc.rf_amplifier.power", "Energy Required: %s FE/t");
        this.add("tooltip.nc.rf_amplifier.voltage", "Amplification: %s V");
        this.add("tooltip.nc.rf_amplifier.efficiency", "Efficiency: %s%%");
        this.add("tooltip.nc.rf_amplifier.heat", "Heat: %s H/t");
        this.add("tooltip.nc.rf_amplifier.max_temp", "Max Temperature: %s K");
        this.add("tooltip.nc.reactor.charge", "Charged: %s");
        this.add("tooltip.nc.reactor.has_magnets", "Electromagnets: %s");
        this.add("tooltip.nc.reactor.has_amplifiers", "RF Amplifiers: %s");
        this.add("tooltip.nc.reactor.has_coolant", "Coolant: %s");
        this.add("tooltip.nc.reactor.has_energy", "Energy: %s");
        this.add("tooltip.nc.reactor.has_fuel", "Fuel: %s");
        this.add("tooltip.nc.reactor.ready", "Ready");
        this.add("tooltip.nc.reactor.not_ready", "Not Ready");
        this.add("tooltip.nc.show_recipes", "Show Recipes");
        this.add("gui.nc.fluid_tank_renderer.can_void", "SHIFT+Mouse 1 to void content");
        this.add("tooltip.nc.electromagnet.not_found", "No Electromagnets attached");
        this.add("tooltip.nc.electromagnet.power", "Energy Required: %s FE/t");
        this.add("tooltip.nc.electromagnet.magnetic_field", "Magnetic Field: %s T");
        this.add("tooltip.nc.description.efficiency", "Efficiency: %s%%");
        this.add("tooltip.nc.description.expansion", "Expansion: %s%%");
        this.add("tooltip.nc.electromagnet.heat", "Heat: %s H/t");
        this.add("tooltip.nc.electromagnet.max_temp", "Max Temparature: %s K");
        this.add("tooltip.nc.blade.desc", "Converts the energy of the oncoming fluid flow into rotational energy in the rotor shaft. The expansion coefficient is larger than unity, so the volume of the fluid flow will increase each time it passes through a set. Must be placed in complete sets of four coplanar groups extending from the turbine shaft to the wall. Each blade block can process up to %s of oncoming fluid.");
        this.add("tooltip.nc.rotor_shaft.desc", "Connects the rotor blades to the dynamo to convert the generated kinetic energy into electrical energy. Must be placed axially as a cuboid along the centre of the turbine interior.");
        this.add("tooltip.nc.bearing.desc", "Connects the rotor shaft to the turbine wall and dynamo. Must cover the full area of each end of the shaft.");
        this.add("turbine.active.coils", "Active coils: %s");
        this.add("turbine.blades.flow", "Max steam flow: %s mB/t");
        this.add("tooltip.nc.liquid_empty", "Stored: 0 of %s");
        this.add("tooltip.nc.liquid_stored", "Stored: %s %s / %s");
        this.add("tooltip.nc.liquid_capacity", "Capacity: %s");
        this.add("effect.nuclearcraft.radiation_resistance", "Radiation Resistance");
        this.add("leacher.tooltip.valid_pump", "Pump - Ok");
        this.add("leacher.tooltip.invalid_pump", "Pump in the corner not found");
        this.add("processor.description.alloy_smelter", "Smelts and alloys items.");
        this.add("processor.description.centrifuge", "Separates fluids into their components.");
        this.add("processor.description.fuel_reprocessor", "Separates depleted fuel into components.");
        this.add("processor.description.melter", "Melts items into liquids.");
        this.add("processor.description.ingot_former", "Forms solid items from molten liquids.");
        this.add("processor.description.crystalizer", "Grows crystals from solutions.");
        this.add("processor.description.chemical_reactor", "Mixes fluids and gases together.");
        this.add("processor.description.assembler", "Machine what assembles items.");
        this.add("processor.description.decay_hastener", "Accelerates decay speed of radioactive materials.");
        this.add("processor.description.electrolyzer", "Separates fluids and gases into their components.");
        this.add("processor.description.extractor", "Extracts liquids from solid items.");
        this.add("processor.description.fluid_enricher", "Enriches fluids and gases with solid items.");
        this.add("processor.description.fluid_infuser", "Mixes fluids with items to get new items.");
        this.add("processor.description.irradiator", "Transform items and fluids with the power of Radiative Flux. Needs to be placed in reactor's wall.");
        this.add("processor.description.isotope_separator", "Splits items into isotopes.");
        this.add("processor.description.manufactory", "Crushes items into dusts and other materials.");
        this.add("processor.description.pressurizer", "Compresses items with high pressure.");
        this.add("processor.description.rock_crusher", "Produces dusts from rocks.");
        this.add("processor.description.supercooler", "Cools down fluids and gases.");
        this.add("processor.description.steam_turbine", "Produce energy with power of steam.");
        this.add("processor.description.gas_scrubber", "\u0421leansing ventilation.");
        this.add("processor.description.pump", "Pumps fluids and gasses from environment.");
        this.add("processor.description.analyzer", "Used to analyze environment and items.");
        this.add("processor.description.leacher", "Leaches undeground minerals with acids and pumps slurry back.");
        this.add("amount", "Amount: %s");
        this.add("sound_event.nuclearcraft.item.charged", "Item Charged");
        this.add("tooltip.nc.analyzed", "Item analyze completed");
        this.add("tooltip.nc.shielding.desc", "Combine with armor in crafting grid");
        this.add("tooltip.nc.rad_shielding", "Rad Shielding LVL: %s");
        this.add("tooltip.nc.use_in_leacher", "Item can be used in Leacher");
        this.add("tooltip.nc.energy_stored", "Energy Stored: %s / %s");
        this.add("tooltip.nc.energy_capacity", "Energy Capacity: %s");
        this.add("tooltip.nc.radiation", "Radiation: %s");
        this.add("tooltip.nc.radiation_removal", "Removes Radiation: %s");
        this.add("tooltip.toggle_description_keys", "Toggle description: CTRL+N");
        this.add("fuel.heat.descr", "Base Heat Gen: %s H/t");
        this.add("message.nc.battery.side_config", "Mode: %s");
        this.add("message.nc.barrel.side_config", "Mode: %s");
        this.add("gui.nc.reactor_comparator_config.tooltip_1", "Comparator: Energy Stored");
        this.add("gui.nc.reactor_comparator_config.tooltip_2", "Comparator: Heat Stored");
        this.add("gui.nc.reactor_comparator_config.tooltip_3", "Comparator: Depletion Progress");
        this.add("gui.nc.reactor_comparator_config.tooltip_4", "Comparator: Fuel Left");
        this.add("gui.nc.reactor_comparator_config.tooltip_5", "Input: On/Off Reactor");
        this.add("gui.nc.reactor_comparator_config.tooltip_6", "Input: Moderation Control");
        this.add("gui.nc.reactor_comparator_strength.tooltip", "Current Signal Strength: %s");
        this.add("gui.nc.redstone_config.tooltip_0", "WORK MODE: IGNORE SIGNAL");
        this.add("gui.nc.redstone_config.tooltip_1", "WORK MODE: ON SIGNAL");
        this.add("gui.nc.fluid_tank_renderer.amount_capacity", "%s/%s mB");
        this.add("gui.nc.fluid_tank_renderer.amount", "%s mB");
        this.add("fuel.forge_energy.descr", "Forge Energy: %s FE/t");
        this.add("rtg.fe_generation", "Energy Generation: %s FE/t");
        this.add("tooltip.nc.shift_rbm_to_change", "Sneak+Use to change");
        this.add("tooltip.nc.qnp_mode", "Mode: %s");
        this.add("tooltip.mode.one_block", "One Block");
        this.add("tooltip.mode.3x3", "3x3");
        this.add("tooltip.mode.3x3x3", "3x3x3");
        this.add("tooltip.mode.5x5", "5x5");
        this.add("tooltip.mode.vein", "Vein");
        this.add("tooltip.nc.chunk_position", "Chunk Position: %s");
        this.add("nc.ore_vein.borax", "Vein of Borax");
        this.add("nc.ore_vein.bornite", "Vein of Bornite");
        this.add("nc.ore_vein.cassiterite", "Vein of Cassiterite");
        this.add("nc.ore_vein.cobaltite", "Vein of Cobaltite");
        this.add("nc.ore_vein.magnesite", "Vein of Magnesite");
        this.add("nc.ore_vein.platinum", "Vein of Platinum");
        this.add("nc.ore_vein.sphalerite", "Vein of Sphalerite");
        this.add("nc.ore_vein.spodumene", "Vein of Spodumene");
        this.add("nc.ore_vein.uraninite", "Vein of Uraninite");
        this.add("nc.ore_vein.none", "Veins not found");
        this.add("nc.ore_vein.mixed", "Vein of Mixed minerals");
        this.add("tooltip.nc.content_saved", "Content Saved");
        this.add("fuel.heat_boiling.descr", "Boiling Reactor Heat: %s H/t");
        this.add("fuel.depletion.descr", "Base Depletion Time: %s sec");
        this.add("fuel.criticality.descr", "Criticality Factor: %s N/t");
        this.add("fuel.efficiency.descr", "Base Efficiency: %s%%");
        this.add("fuel.description", "Used in Fission Reactors. Use Fuel Ports to Load/Unload. \r\nActual FE generation depends on Reactor Efficiency.");
        this.add("heat_sink.heat.descr", "Cooling Rate: %s H/t");
        this.add("heat_sink.placement.rule", "Must be placed %s");
        this.add("heat_sink.between", "between %s and %s");
        this.add("heat_sink.atleast", "next to at least %s %s");
        this.add("heat_sink.atleasts", "next to at least %s %s blocks");
        this.add("heat_sink.exact", "next to exact %s %s");
        this.add("heat_sink.exacts", "next to exact %s %s blocks");
        this.add("heat_sink.less_than", "next to less than %s %s blocks");
        this.add("heat_sink.in_corner", "in corner of %s %s blocks");
        this.add("heat_sink.or", "or");
        this.add("heat_sink.and", "and");
        this.add("heat_sink.placement.error", "Error during placement rule generation");
        this.add("multiblock.interior.complete", "Interior Complete");
        this.add("multiblock.interior.incomplete", "Interior Incomplete");
        this.add("multiblock.casing.complete", "Multiblock Casing Complete");
        this.add("multiblock.casing.incomplete", "Multiblock Casing Incomplete");
        this.add("energy.bar.amount", "Total FE: %s / %s");
        this.add("reactor.internal_usage", "Internal usage: %s FE/t");
        this.add("coolant.bar.amount", "Coolant: %s / %s mB");
        this.add("hot_coolant.bar.amount", "Heated Coolant: %s / %s mB");
        this.add("heat.bar.amount", "Total Heat: %s / %s K");
        this.add("tooltip.nc.reactor.plasma_heat", "Plasma Heat: %s K");
        this.add("tooltip.nc.reactor.plasma_optimal", "Optimal: %s K");
        this.add("tooltip.machine.progress", "Progress: %s%%");
        this.add("reactor.fuel_cells", "Fuel Cells: %s");
        this.add("reactor.irradiators_connections", "Irradiation lines: %s");
        this.add("fission.interior.no_fuel_cells", "No Fuel Cells Found");
        this.add("fission.interior.no_moderators", "No Moderators Found");
        this.add("fission.interior.no_heat_sink", "No Heat Sinks Found");
        this.add("tooltip.nc.use_multitool", "Use Multitool to config sides");
        this.add("tooltip.nc.multitool.desc", "Commonly used to config sides of batteries, barrels, ports...");
        this.add("tooltip.nc.multitool.shift.desc", "Sneak + RBM to config back side");
        this.add("side_config.up", "UP: ");
        this.add("side_config.down", "DOWN: ");
        this.add("side_config.left", "LEFT: ");
        this.add("side_config.right", "RIGHT: ");
        this.add("side_config.front", "FRONT: ");
        this.add("side_config.back", "BACK: ");
        this.add("side_config.input", "INPUT");
        this.add("side_config.pull", "PULL");
        this.add("side_config.output", "OUTPUT");
        this.add("side_config.push", "PUSH");
        this.add("side_config.push_excess", "PUSH EXCESS");
        this.add("side_config.disabled", "DISABLED");
        this.add("side_config.default", "DEFAULT");
        this.add("gui.nc.side_config.tooltip", "Side Config");
        this.add("speed.multiplier", "Speed Multiplier: x%s");
        this.add("energy.multiplier", "Energy Multiplier: x%s");
        this.add("energy.per_tick", "Energy Per Tick: %s FE/t");
        this.add("reactor.cooling", "Cooling: %s H/t");
        this.add("reactor.heating", "Heat Gen: %s H/t");
        this.add("reactor.net_heat", "Net Heat: %s H/t");
        this.add("reactor.forge_energy_per_tick", "FE Gen: %s FE/t");
        this.add("reactor.heat_sinks_count", "Active Heat Sinks: %s");
        this.add("reactor.moderators_count", "Active Moderators: %s");
        this.add("reactor.moderation_level", "Moderation Level: %s%%");
        this.add("validation.structure.too_big", "Structure is too big");
        this.add("validation.structure.too_small", "Structure is too small");
        this.add("validation.structure.incomplete", "Incomplete");
        this.add("validation.structure.wrong_outer", "Wrong Casing at: %s");
        this.add("validation.structure.wrong_inner", "Wrong Block at: %s");
        this.add("validation.structure.too_many_controllers", "Too many controllers");
        this.add("validation.structure.no_controller", "No controllers");
        this.add("validation.structure.no_port", "No port found");
        this.add("validation.structure.valid", "Structure is Valid");
        this.add("validation.structure.wrong_corner", "Wrong corner block at: %s");
        this.add("validation.structure.wrong_proportions", "Wrong proportions");
        this.add("solar_panel.fe_generation", "Daytime Gen: %s FE/t");
        this.add("fission_port.descr", "One port for everything: Fluids, items, redstone, computers, etc...");
        this.add("irradiation_chamber.descr", "Irradiates items with neutron flux. \r\nHas to be placed in one line with moderator and fuel cell behind it.");
    }

    private void fuel() {
        for (List<String> name : Fuel.NC_FUEL.keySet()) {
            this.add((Item)Fuel.NC_FUEL.get(name).get(), TextUtils.convertToName(name.get(0)) + " " + TextUtils.convertToName(name.get(1)) + " " + name.get(2).toUpperCase() + " " + name.get(3).toUpperCase());
        }
        for (List<String> name : Fuel.NC_DEPLETED_FUEL.keySet()) {
            this.add((Item)Fuel.NC_DEPLETED_FUEL.get(name).get(), TextUtils.convertToName(name.get(0)) + " " + TextUtils.convertToName(name.get(1)) + " " + name.get(2).toUpperCase() + " " + name.get(3).toUpperCase());
        }
    }

    private void ores() {
        for (String ore : NCBlocks.ORE_BLOCKS.keySet()) {
            this.add((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), TextUtils.convertToName(ore) + " Ore");
        }
    }

    private void items() {
        for (String name : NCItems.NC_ITEMS.keySet()) {
            this.add((Item)NCItems.NC_ITEMS.get(name).get(), TextUtils.convertToName(name));
        }
        this.add("item.nuclearcraft.wanderer.desc", "Wanderer");
        this.add("item.nuclearcraft.end_of_the_world.desc", "End of the World");
        this.add("item.nuclearcraft.hyperspace.desc", "Hyperspace");
        this.add("item.nuclearcraft.money_for_nothing.desc", "Money For Nothing");
    }

    private void isotopes() {
        for (String name : Fuel.NC_ISOTOPES.keySet()) {
            this.add((Item)Fuel.NC_ISOTOPES.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void records() {
        for (String name : NCItems.NC_RECORDS.keySet()) {
            this.add((Item)NCItems.NC_RECORDS.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void tools() {
        this.add((Item)NCItems.QNP.get(), "QNP");
        this.add((Item)NCItems.MULTITOOL.get(), "Multitool");
        this.add((Item)NCItems.GEIGER_COUNTER.get(), "Geiger Counter");
        this.add((Item)NCItems.SPAXELHOE_THORIUM.get(), "Thorium Spaxel");
        this.add((Item)NCItems.SPAXELHOE_TOUGH.get(), "Tough Spaxel");
        this.add((Item)NCItems.LITHIUM_ION_CELL.get(), "Lithium Ion Cell");
    }

    private void armor() {
        this.add((Item)NCItems.TOUGH_HELMET.get(), "Tough Helmet");
        this.add((Item)NCItems.TOUGH_PANTS.get(), "Tough Pants");
        this.add((Item)NCItems.TOUGH_BOOTS.get(), "Tough Boots");
        this.add((Item)NCItems.TOUGH_CHEST.get(), "Tough Chest");
        this.add((Item)NCItems.HEV_HELMET.get(), "HEV Helmet");
        this.add((Item)NCItems.HEV_PANTS.get(), "HEV Pants");
        this.add((Item)NCItems.HEV_BOOTS.get(), "HEV Boots");
        this.add((Item)NCItems.HEV_CHEST.get(), "HEV Chest");
        this.add((Item)NCItems.HAZMAT_MASK.get(), "Hazmat Mask");
        this.add((Item)NCItems.HAZMAT_PANTS.get(), "Hazmat Pants");
        this.add((Item)NCItems.HAZMAT_BOOTS.get(), "Hazmat Boots");
        this.add((Item)NCItems.HAZMAT_CHEST.get(), "Hazmat Chest");
    }

    private void food() {
        for (String name : NCItems.NC_FOOD.keySet()) {
            this.add((Item)NCItems.NC_FOOD.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void parts() {
        for (String name : NCItems.NC_PARTS.keySet()) {
            this.add((Item)NCItems.NC_PARTS.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void gems() {
        for (String name : NCItems.NC_GEMS.keySet()) {
            this.add((Item)NCItems.NC_GEMS.get(name).get(), TextUtils.convertToName(name) + " Gem");
        }
    }

    private void ingots() {
        for (String ingot : NCItems.NC_INGOTS.keySet()) {
            this.add((Item)NCItems.NC_INGOTS.get(ingot).get(), TextUtils.convertToName(ingot) + " Ingot");
        }
    }

    private void plates() {
        for (String name : NCItems.NC_PLATES.keySet()) {
            this.add((Item)NCItems.NC_PLATES.get(name).get(), TextUtils.convertToName(name) + " Plate");
        }
    }

    private void dusts() {
        for (String name : NCItems.NC_DUSTS.keySet()) {
            this.add((Item)NCItems.NC_DUSTS.get(name).get(), TextUtils.convertToName(name) + " Dust");
        }
    }

    private void nuggets() {
        for (String name : NCItems.NC_NUGGETS.keySet()) {
            this.add((Item)NCItems.NC_NUGGETS.get(name).get(), TextUtils.convertToName(name) + " Nugget");
        }
    }

    private void chunks() {
        for (String name : NCItems.NC_CHUNKS.keySet()) {
            this.add((Item)NCItems.NC_CHUNKS.get(name).get(), TextUtils.convertToName(name) + " Chunk");
        }
    }

    private void blocks() {
        for (String name : NCBlocks.NC_BLOCKS.keySet()) {
            this.add((Block)NCBlocks.NC_BLOCKS.get(name).get(), TextUtils.convertToName(name) + " Block");
        }
        for (String name : NCBlocks.NC_ELECTROMAGNETS.keySet()) {
            this.add((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), TextUtils.convertToName(name));
        }
        for (String name : NCBlocks.NC_RF_AMPLIFIERS.keySet()) {
            this.add((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), TextUtils.convertToName(name));
        }
    }
}

