/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.materials;

import igentuman.nc.content.materials.Ores;
import igentuman.nc.handler.config.MaterialsConfig;

public class NCMaterialProduct {
    public String name;
    public String type;
    private boolean initialized = false;
    private Boolean registered = true;

    public NCMaterialProduct(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public static NCMaterialProduct get(String name, String type) {
        return new NCMaterialProduct(name, type);
    }

    public NCMaterialProduct config() {
        if (!this.initialized) {
            if (!MaterialsConfig.isLoaded()) {
                return this;
            }
            int id = Ores.all().keySet().stream().toList().indexOf(this.name);
            switch (this.type) {
                case "ingot": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.INGOTS.get(id).get();
                    break;
                }
                case "nugget": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.NUGGET.get(id).get();
                    break;
                }
                case "block": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.BLOCK.get(id).get();
                    break;
                }
                case "chunk": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.RAW_CHUNKS.get(id).get();
                    break;
                }
                case "plate": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.PLATES.get(id).get();
                    break;
                }
                case "dust": {
                    this.registered = (Boolean)MaterialsConfig.MATERIAL_PRODUCTS.DUSTS.get(id).get();
                }
            }
            this.initialized = true;
        }
        return this;
    }

    public boolean isRegistered() {
        return this.registered;
    }
}

