/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.fuel;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.config.FusionConfig;
import java.util.List;

public class FuelDef {
    public int[] isotopes;
    private boolean initialized = false;
    public String name = "";
    public String group = "";
    public double heat = 0.0;
    public int criticality = 0;
    public int depletion = 0;
    public int efficiency = 0;
    public int forge_energy = 0;

    public FuelDef(String group, String name, int forge_energy, double heat, int criticality, int depletion, int efficiency) {
        this.group = group;
        this.name = name;
        this.heat = heat;
        this.forge_energy = forge_energy;
        this.criticality = criticality;
        this.depletion = depletion;
        this.efficiency = efficiency;
    }

    public FuelDef isotopes(int ... isotopes) {
        this.isotopes = isotopes;
        return this;
    }

    public FuelDef(String group, String name, int forge_energy, double heat, double criticality, double depletion, double efficiency) {
        this(group, name, forge_energy, heat, (int)criticality, (int)depletion, (int)efficiency);
    }

    private Double heatMult() {
        if (!FusionConfig.isLoaded()) {
            return 3.24444444;
        }
        return (Double)FissionConfig.FUEL_CONFIG.HEAT_MULTIPLIER.get();
    }

    public FuelDef config() {
        if (!FusionConfig.isLoaded()) {
            return this;
        }
        if (!this.initialized) {
            this.initialized = true;
            int id = FuelManager.all().get(this.group).keySet().stream().toList().indexOf(this.name);
            this.efficiency = (Integer)((List)FissionConfig.FUEL_CONFIG.EFFICIENCY.get()).get(id);
            this.criticality = (Integer)((List)FissionConfig.FUEL_CONFIG.CRITICALITY.get()).get(id);
            this.heat = (Double)((List)FissionConfig.FUEL_CONFIG.HEAT.get()).get(id);
            this.depletion = (int)((double)((Integer)((List)FissionConfig.FUEL_CONFIG.DEPLETION.get()).get(id)).intValue() * (Double)FissionConfig.FUEL_CONFIG.DEPLETION_MULTIPLIER.get());
        }
        return this;
    }

    public double getHeatFEMode() {
        return this.config().heat;
    }

    public double getHeatBoilingMode() {
        double mult = this.heatMult();
        try {
            if (this.name.substring(0, 1).equalsIgnoreCase("l")) {
                mult *= 2.0;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Math.ceil(this.config().heat * mult);
    }
}

