/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content;

import igentuman.nc.block.entity.ElectromagnetBE;
import igentuman.nc.block.entity.RFAmplifierBE;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FusionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class RFAmplifier {
    private static HashMap<String, RFAmplifierPrefab> all = new HashMap();
    private static HashMap<String, RFAmplifierPrefab> registered = new HashMap();

    public static HashMap<String, RFAmplifierPrefab> all() {
        if (all.isEmpty()) {
            all.put("basic_rf_amplifier", new RFAmplifierPrefab("basic_rf_amplifier", 250, 300, 500000, 350000, 75));
            all.put("magnesium_diboride_rf_amplifier", new RFAmplifierPrefab("magnesium_diboride_rf_amplifier", 500, 500, 1000000, 39000, 80));
            all.put("niobium_tin_rf_amplifier", new RFAmplifierPrefab("niobium_tin_rf_amplifier", 750, 1140, 2000000, 18000, 90));
            all.put("niobium_titanium_rf_amplifier", new RFAmplifierPrefab("niobium_titanium_rf_amplifier", 1500, 2260, 3000000, 10000, 95));
            all.put("bscco_rf_amplifier", new RFAmplifierPrefab("bscco_rf_amplifier", 2500, 4500, 4000000, 104000, 99));
        }
        return all;
    }

    public static HashMap<String, RFAmplifierPrefab> registered() {
        if (registered.isEmpty()) {
            for (String name : RFAmplifier.all().keySet()) {
                if (!RFAmplifier.all().get(name).config().isRegistered()) continue;
                registered.put(name, RFAmplifier.all().get(name));
            }
        }
        return registered;
    }

    public static List<Boolean> initialRegistered() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String name : RFAmplifier.all().keySet()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialPower() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RFAmplifier.all().keySet()) {
            tmp.add(RFAmplifier.all().get(name).getPower());
        }
        return tmp;
    }

    public static Collection<Integer> initialMagneticField() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RFAmplifier.all().keySet()) {
            tmp.add(RFAmplifier.all().get(name).getVoltage());
        }
        return tmp;
    }

    public static Collection<Integer> initialHeat() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RFAmplifier.all().keySet()) {
            tmp.add(RFAmplifier.all().get(name).getHeat());
        }
        return tmp;
    }

    public static Collection<Integer> initialVoltage() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RFAmplifier.all().keySet()) {
            tmp.add(RFAmplifier.all().get(name).getVoltage());
        }
        return tmp;
    }

    public static class RFAmplifierPrefab {
        private boolean registered = true;
        private boolean initialized = false;
        private String name;
        protected int power = 0;
        protected int voltage = 0;
        protected int heat = 0;
        protected int maxTemp = 0;
        protected int efficiency = 0;
        private BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntity = ElectromagnetBE::new;

        public RFAmplifierPrefab(String name, int energy, int heat, int voltage, int maxTemp, int efficiency) {
            this.power = energy;
            this.name = name;
            this.heat = heat;
            this.voltage = voltage;
            this.maxTemp = maxTemp;
            this.efficiency = efficiency;
            this.blockEntity = RFAmplifierBE::new;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public int getMaxTemp() {
            return this.maxTemp;
        }

        public int getPower() {
            return this.power;
        }

        public RFAmplifierPrefab setPower(int power) {
            this.power = power;
            return this;
        }

        public RFAmplifierPrefab config() {
            if (!this.initialized) {
                if (!CommonConfig.isLoaded()) {
                    return this;
                }
                int id = RFAmplifier.all().keySet().stream().toList().indexOf(this.name);
                this.registered = (Boolean)((List)FusionConfig.RF_AMPLIFIERS_CONFIG.REGISTERED.get()).get(id);
                this.power = (Integer)((List)FusionConfig.RF_AMPLIFIERS_CONFIG.POWER.get()).get(id);
                this.heat = (Integer)((List)FusionConfig.RF_AMPLIFIERS_CONFIG.HEAT.get()).get(id);
                this.voltage = (Integer)((List)FusionConfig.RF_AMPLIFIERS_CONFIG.VOLTAGE.get()).get(id);
                this.initialized = true;
            }
            return this;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public BlockEntityType.BlockEntitySupplier<? extends BlockEntity> getBlockEntity() {
            return this.blockEntity;
        }

        public RFAmplifierPrefab setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends RFAmplifierBE> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        public int getVoltage() {
            return this.voltage;
        }

        public int getHeat() {
            return this.heat;
        }
    }
}

