/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.jei.util.TickTimer;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ProcessorCategoryWrapper<T extends NcRecipe>
implements IRecipeCategory<T> {
    public static final ResourceLocation TEXTURE = NuclearCraft.rl("textures/gui/processor_jei.png");
    private final IDrawable background;
    private IDrawable progressBackground;
    private final IDrawable icon;
    private IDrawable[] slots;
    protected RecipeType<T> recipeType;
    private IGuiHelper guiHelper;
    private final ProcessorPrefab processor;
    private int xShift = -25;
    private int yShift = -38;
    HashMap<Integer, TickTimer> timer = new HashMap();
    HashMap<Integer, IDrawable> arrow = new HashMap();
    int height = 22;

    public ProcessorCategoryWrapper(IGuiHelper guiHelper, RecipeType<T> recipeType) {
        this.recipeType = recipeType;
        this.guiHelper = guiHelper;
        this.processor = Processors.all().get(this.getRecipeType().getUid().m_135815_());
        if (this.processor.getSlotsConfig().isDoubleSlotHeight()) {
            this.height = 45;
            this.yShift += 11;
        }
        if (this.processor.getSlotsConfig().hasThreeRows()) {
            this.xShift -= 8;
        }
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 150, this.height);
        this.icon = GlobalVars.CATALYSTS.containsKey(this.getRecipeType().getUid().m_135815_()) ? guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)GlobalVars.CATALYSTS.get(this.getRecipeType().getUid().m_135815_()).get(0)) : guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)("nc_jei_cat." + this.getRecipeType().getUid().m_135815_()));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int d = (int)(((AbstractRecipe)recipe).getTimeModifier() * (double)this.processor.config().getTime() / 2.0);
        int fluidsOut = this.processor.getSlotsConfig().getOutputFluids();
        int itemsOut = this.processor.getSlotsConfig().getOutputItems();
        int itemsIn = this.processor.getSlotsConfig().getInputItems();
        int fluidsIn = this.processor.getSlotsConfig().getInputFluids();
        int barXshift = 0;
        if (fluidsOut + itemsOut == 3 || fluidsOut + itemsOut == 6) {
            barXshift = -8;
        }
        int extraXshift = 0;
        if (fluidsOut + itemsOut > 6) {
            extraXshift = -20;
        }
        if (itemsIn + fluidsIn > 5) {
            extraXshift = 20;
        }
        if (this.arrow.containsKey(d)) {
            int barHeight = 16;
            if (this.processor.progressBar > 14) {
                barHeight = 36;
            }
            this.progressBackground.draw(graphics, 47 + this.xShift + 25 + barXshift + extraXshift, this.height / 2 - barHeight / 2);
            this.arrow.get(d).draw(graphics, 47 + this.xShift + 25 + barXshift + extraXshift, this.height / 2 - barHeight / 2);
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            int[] pos = this.processor.getSlotsConfig().getSlotPositions().get(i);
            this.slots[i].draw(graphics, pos[0] + this.xShift - 1 + barXshift, pos[1] + this.yShift - 1);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (mouseX > (double)(47 + this.xShift + 25) && mouseX < (double)(47 + this.xShift + 25 + 36) && mouseY > (double)(this.height / 2 - 8) && mouseY < (double)(this.height / 2 + 8)) {
            lines.add((Component)Component.m_237110_((String)"processor.recipe.duration", (Object[])new Object[]{(int)(((AbstractRecipe)recipe).getTimeModifier() * (double)this.processor.config().getTime())}).m_130940_(ChatFormatting.AQUA));
            lines.add((Component)Component.m_237110_((String)"processor.recipe.power", (Object[])new Object[]{(int)(((AbstractRecipe)recipe).getEnergy() * (double)this.processor.config().getPower())}).m_130940_(ChatFormatting.RED));
            if (((AbstractRecipe)recipe).getRadiation() != 1.0) {
                lines.add((Component)Component.m_237110_((String)"processor.recipe.radiation", (Object[])new Object[]{((AbstractRecipe)recipe).getRadiation() * 1000.0}).m_130940_(ChatFormatting.GREEN));
            }
        }
        return lines;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, T recipe, @NotNull IFocusGroup focuses) {
        int itemIdx = 0;
        int inputCounter = 0;
        int inputFluidCounter = 0;
        int putFluidCounter = 0;
        int outputCounter = 0;
        int fluidsOut = this.processor.getSlotsConfig().getOutputFluids();
        int itemsOut = this.processor.getSlotsConfig().getOutputItems();
        int d = (int)(((AbstractRecipe)recipe).getTimeModifier() * (double)this.processor.config().getTime() / 2.0);
        if (!this.timer.containsKey(d)) {
            this.timer.put(d, new TickTimer(d, 36, true));
        }
        if (!this.arrow.containsKey(d)) {
            int xoffset = ProgressBar.bars.get(this.processor.progressBar)[0];
            int yoffset = ProgressBar.bars.get(this.processor.progressBar)[1];
            int barHeight = 15;
            if (this.processor.progressBar > 14) {
                barHeight = 36;
            }
            this.progressBackground = this.guiHelper.createDrawable(NuclearCraft.rl("textures/gui/progress.png"), xoffset, yoffset, 36, barHeight);
            this.arrow.put(d, (IDrawable)this.guiHelper.drawableBuilder(NuclearCraft.rl("textures/gui/progress.png"), xoffset, yoffset - barHeight - 1, 36, barHeight).buildAnimated((ITickTimer)this.timer.get(d), IDrawableAnimated.StartDirection.LEFT));
        }
        int barXshift = 0;
        if (fluidsOut + itemsOut == 3 || fluidsOut + itemsOut == 6) {
            barXshift = -8;
        }
        this.slots = new IDrawable[this.processor.getSlotsConfig().getSlotPositions().size()];
        int fluidTankCapacity = 16;
        for (FluidStackIngredient fluidStack : ((AbstractRecipe)recipe).getInputFluids()) {
            fluidTankCapacity = Math.max(fluidTankCapacity, fluidStack.getAmount());
        }
        for (FluidStack fluidStack : ((AbstractRecipe)recipe).getOutputFluids()) {
            fluidTankCapacity = Math.max(fluidTankCapacity, fluidStack.getAmount());
        }
        for (int[] pos : this.processor.getSlotsConfig().getSlotPositions()) {
            if (this.processor.getSlotsConfig().getSlotType(itemIdx).contains("item_in")) {
                builder.addSlot(RecipeIngredientRole.INPUT, pos[0] + this.xShift + barXshift, pos[1] + this.yShift).addIngredients(((AbstractRecipe)recipe).getInputIngredient(inputCounter));
                this.slots[itemIdx] = this.guiHelper.createDrawable(NuclearCraft.rl("textures/gui/widgets.png"), 0, 0, 18, 18);
                ++itemIdx;
                ++inputCounter;
                continue;
            }
            if (this.processor.getSlotsConfig().getSlotType(itemIdx).contains("item_out")) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, pos[0] + this.xShift + barXshift, pos[1] + this.yShift).addItemStack(((AbstractRecipe)recipe).getOutputItem(outputCounter));
                this.slots[itemIdx] = this.guiHelper.createDrawable(NuclearCraft.rl("textures/gui/widgets.png"), 0, 36, 18, 18);
                ++itemIdx;
                ++outputCounter;
                continue;
            }
            if (this.processor.getSlotsConfig().getSlotType(itemIdx).contains("fluid_in")) {
                if (!((AbstractRecipe)recipe).getInputFluids(inputFluidCounter).get(0).equals((Object)FluidStack.EMPTY)) {
                    ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, pos[0] + this.xShift + barXshift, pos[1] + this.yShift).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, ((AbstractRecipe)recipe).getInputFluids(inputFluidCounter))).setFluidRenderer((long)((fluidTankCapacity + ((AbstractRecipe)recipe).getInputFluids()[inputFluidCounter].getAmount()) / 2), false, 16, 16);
                }
                this.slots[itemIdx] = this.guiHelper.createDrawable(NuclearCraft.rl("textures/gui/widgets.png"), 18, 0, 18, 18);
                ++itemIdx;
                ++inputFluidCounter;
                continue;
            }
            if (!this.processor.getSlotsConfig().getSlotType(itemIdx).contains("fluid_out")) continue;
            if (!((AbstractRecipe)recipe).getOutputFluids(putFluidCounter).get(0).equals((Object)FluidStack.EMPTY)) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, pos[0] + this.xShift + barXshift, pos[1] + this.yShift).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, ((AbstractRecipe)recipe).getOutputFluids(putFluidCounter))).setFluidRenderer((long)((fluidTankCapacity + ((AbstractRecipe)recipe).getOutputFluids().get(putFluidCounter).getAmount()) / 2), false, 16, 16);
            }
            this.slots[itemIdx] = this.guiHelper.createDrawable(NuclearCraft.rl("textures/gui/widgets.png"), 18, 36, 18, 18);
            ++itemIdx;
            ++putFluidCounter;
        }
    }
}

