/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.block;

import com.mojang.math.Transformation;
import igentuman.nc.block.ISizeToggable;
import igentuman.nc.block.entity.energy.BatteryBE;
import igentuman.nc.client.block.BatteryBlockLoader;
import igentuman.nc.util.ClientTools;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class BatteryBlockBakedModel
implements IDynamicBakedModel {
    private final ModelState modelState;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final Map<String, List<BakedQuad>> quadCache = new HashMap<String, List<BakedQuad>>();
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    public BatteryBlockLoader.BatteryModelGeometry batteryModelGeometry;
    public List<BakedQuad> sideQuads;

    public BatteryBlockBakedModel(ModelState modelState, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ItemTransforms itemTransforms, BatteryBlockLoader.BatteryModelGeometry batteryModelGeometry) {
        this.modelState = modelState;
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.itemTransforms = itemTransforms;
        this.batteryModelGeometry = batteryModelGeometry;
    }

    public boolean m_7547_() {
        return false;
    }

    public List<BakedQuad> sideQuads() {
        if (this.sideQuads == null) {
            float l = 0.0f;
            float r = 1.0f;
            float p = 1.0f;
            Transformation rotation = this.modelState.m_6189_();
            TextureAtlasSprite textureSide = this.spriteGetter.apply(this.batteryModelGeometry.sideDefault);
            TextureAtlasSprite textureTop = this.spriteGetter.apply(this.batteryModelGeometry.topDefault);
            this.sideQuads = List.of(ClientTools.createQuad(ClientTools.v(r, p, r), ClientTools.v(r, p, l), ClientTools.v(l, p, l), ClientTools.v(l, p, r), textureTop), ClientTools.createQuad(ClientTools.v(l, l, l), ClientTools.v(r, l, l), ClientTools.v(r, l, r), ClientTools.v(l, l, r), textureSide), ClientTools.createQuad(ClientTools.v(r, p, r), ClientTools.v(r, l, r), ClientTools.v(r, l, l), ClientTools.v(r, p, l), textureSide), ClientTools.createQuad(ClientTools.v(l, p, l), ClientTools.v(l, l, l), ClientTools.v(l, l, r), ClientTools.v(l, p, r), textureSide), ClientTools.createQuad(ClientTools.v(r, p, l), ClientTools.v(r, l, l), ClientTools.v(l, l, l), ClientTools.v(l, p, l), textureSide), ClientTools.createQuad(ClientTools.v(l, p, r), ClientTools.v(l, l, r), ClientTools.v(r, l, r), ClientTools.v(r, p, r), textureSide));
        }
        return this.sideQuads;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        if (side != null || layer != null && !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        HashMap sideConfig = (HashMap)extraData.get(BatteryBE.SIDE_CONFIG);
        if (sideConfig == null) {
            return this.sideQuads();
        }
        String cacheKey = this.keyFor(sideConfig.values());
        if (this.quadCache.containsKey(cacheKey) && this.quadCache.get(cacheKey) != null) {
            return this.quadCache.get(cacheKey);
        }
        float l = 0.0f;
        float r = 1.0f;
        float p = 1.0f;
        Transformation rotation = this.modelState.m_6189_();
        this.quadCache.put(cacheKey, List.of(ClientTools.createQuad(ClientTools.v(r, p, r), ClientTools.v(r, p, l), ClientTools.v(l, p, l), ClientTools.v(l, p, r), switch ((ISizeToggable.SideMode)((Object)sideConfig.get(Direction.UP.ordinal()))) {
            case ISizeToggable.SideMode.DISABLED -> this.spriteGetter.apply(this.batteryModelGeometry.topNone);
            case ISizeToggable.SideMode.IN -> this.spriteGetter.apply(this.batteryModelGeometry.topIn);
            case ISizeToggable.SideMode.OUT -> this.spriteGetter.apply(this.batteryModelGeometry.topOut);
            default -> this.spriteGetter.apply(this.batteryModelGeometry.topDefault);
        }), ClientTools.createQuad(ClientTools.v(l, l, l), ClientTools.v(r, l, l), ClientTools.v(r, l, r), ClientTools.v(l, l, r), this.getSideTexture(sideConfig, Direction.DOWN)), ClientTools.createQuad(ClientTools.v(r, p, r), ClientTools.v(r, l, r), ClientTools.v(r, l, l), ClientTools.v(r, p, l), this.getSideTexture(sideConfig, Direction.EAST)), ClientTools.createQuad(ClientTools.v(l, p, l), ClientTools.v(l, l, l), ClientTools.v(l, l, r), ClientTools.v(l, p, r), this.getSideTexture(sideConfig, Direction.WEST)), ClientTools.createQuad(ClientTools.v(r, p, l), ClientTools.v(r, l, l), ClientTools.v(l, l, l), ClientTools.v(l, p, l), this.getSideTexture(sideConfig, Direction.NORTH)), ClientTools.createQuad(ClientTools.v(l, p, r), ClientTools.v(l, l, r), ClientTools.v(r, l, r), ClientTools.v(r, p, r), this.getSideTexture(sideConfig, Direction.SOUTH))));
        return this.quadCache.get(cacheKey);
    }

    private String keyFor(Collection<ISizeToggable.SideMode> values) {
        Object result = "";
        for (ISizeToggable.SideMode value : values) {
            result = (String)result + value.ordinal();
        }
        return result;
    }

    private TextureAtlasSprite getSideTexture(HashMap<Integer, ISizeToggable.SideMode> sideConfig, Direction direction) {
        TextureAtlasSprite textureSide = this.spriteGetter.apply(this.batteryModelGeometry.sideDefault);
        switch (sideConfig.get(direction.ordinal())) {
            case DISABLED: {
                textureSide = this.spriteGetter.apply(this.batteryModelGeometry.sideNone);
                break;
            }
            case IN: {
                textureSide = this.spriteGetter.apply(this.batteryModelGeometry.sideIn);
                break;
            }
            case OUT: {
                textureSide = this.spriteGetter.apply(this.batteryModelGeometry.sideOut);
            }
        }
        return textureSide;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(this.batteryModelGeometry.sideDefault);
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.itemTransforms;
    }
}

