/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class SteamTurbineBE
extends NCProcessorBE<Recipe> {
    @NBTField
    protected double efficiency = 0.001;

    public SteamTurbineBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, Processors.STEAM_TURBINE);
    }

    @Override
    public String getName() {
        return Processors.STEAM_TURBINE;
    }

    @Override
    public void tickServer() {
        this.sendOutPower();
        this.efficiency += 0.001;
        this.efficiency = Math.max(1.0E-4, Math.min(10.0, this.efficiency));
        if (this.energyStorage.getEnergyStored() >= this.energyStorage.getMaxEnergyStored()) {
            return;
        }
        super.tickServer();
    }

    @Override
    protected void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            return;
        }
        this.recipeInfo.process(this.speedMultiplier() / this.efficiency);
        this.efficiency += 4.0E-4;
        this.energyStorage.addEnergy((int)((double)this.getEnergyTransferPerTick() * ((Recipe)this.recipe).getEnergy()));
    }

    @Override
    public double speedMultiplier() {
        return super.speedMultiplier();
    }

    @Override
    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyMaxStorage(), 0, this.getEnergyMaxStorage()){

            @Override
            protected void onEnergyChanged() {
                SteamTurbineBE.this.m_6596_();
            }
        };
    }

    public int energyToSend() {
        return Math.min(this.energyStorage.getEnergyStored(), this.getEnergyTransferPerTick());
    }

    protected void sendOutPower() {
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (be == null || (doContinue = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), this.energyToSend()), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    protected int getEnergyMaxStorage() {
        return this.getEnergyTransferPerTick() * 10;
    }

    protected int getEnergyTransferPerTick() {
        return (Integer)CommonConfig.ENERGY_GENERATION.STEAM_TURBINE.get();
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return Processors.STEAM_TURBINE;
        }
    }
}

