/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ProcessorBlock;
import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.block.entity.processor.PumpBE;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.event.client.BlockOverlayHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import igentuman.nc.util.insitu_leaching.WorldVeinsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class LeacherBE
extends NCProcessorBE<Recipe> {
    public static final byte PUMPS_ERROR = 4;
    public static final byte NO_SOURCE = 3;
    public static final byte WRONG_POSITION = 2;
    public static final byte POSITION_IS_CORRECT = 1;
    public static final byte NO_ACID = 0;
    protected List<ItemStack> minableOres;
    @NBTField
    public BlockPos currentMiningPos;
    @NBTField
    public boolean pumpsAreValid = false;
    @NBTField
    public byte leacherState = (byte)2;
    @NBTField
    public ItemStack catalyst = ItemStack.f_41583_;
    protected PumpBE[] pumps = new PumpBE[4];
    protected byte pumpValidationTimeout = (byte)40;
    int currentMiningTimeout = 0;

    public LeacherBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, Processors.LEACHER);
    }

    @Override
    public String getName() {
        return Processors.LEACHER;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        this.handleState();
        byte lastState = this.leacherState;
        this.leacherState = 1;
        if (!this.hasCatalyst()) {
            this.leacherState = (byte)3;
        }
        if (!this.pumpsAreValid) {
            this.leacherState = (byte)4;
        }
        if (lastState != this.leacherState) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 3);
        }
        if (this.leacherState == 1) {
            super.tickServer();
        }
    }

    private void handleState() {
        this.pumpValidationTimeout = (byte)(this.pumpValidationTimeout - 1);
        if (this.pumpValidationTimeout <= 0) {
            this.pumpValidationTimeout = (byte)40;
            this.clearHighligts();
            this.validatePumps();
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.clearHighligts();
    }

    private void clearHighligts() {
        ChunkPos chunkPos = new ChunkPos(this.m_58899_());
        boolean isClientSide = Objects.requireNonNull(this.m_58904_()).f_46443_;
        if (isClientSide) {
            BlockOverlayHandler.removeFromOutline(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_(), chunkPos.m_45605_()));
            BlockOverlayHandler.removeFromOutline(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_(), chunkPos.m_45609_()));
            BlockOverlayHandler.removeFromOutline(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_(), chunkPos.m_45609_()));
            BlockOverlayHandler.removeFromOutline(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_(), chunkPos.m_45605_()));
        }
    }

    public PumpBE[] getPumpsForClient() {
        this.validatePumps();
        return this.pumps;
    }

    @Override
    public void tickClient() {
        this.handleState();
    }

    public boolean isPumpValid(NCBlockPos pos, int id) {
        for (int y = 0; y < 20; ++y) {
            BlockEntity be = this.m_58904_().m_7702_(pos.m_7495_());
            if (!(be instanceof PumpBE)) continue;
            this.pumps[id] = (PumpBE)be;
            return this.pumps[id].isInSituValid();
        }
        return false;
    }

    public void validatePumps() {
        ChunkPos chunkPos = new ChunkPos(this.m_58899_());
        boolean isClientSide = Objects.requireNonNull(this.m_58904_()).f_46443_;
        this.pumpsAreValid = this.isPumpValid(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_() + 5, chunkPos.m_45605_()), 0);
        if (!this.pumpsAreValid && isClientSide) {
            BlockOverlayHandler.addToOutline(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_(), chunkPos.m_45605_()));
        }
        if (!this.isPumpValid(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_() + 5, chunkPos.m_45609_()), 1)) {
            this.pumpsAreValid = false;
            if (isClientSide) {
                BlockOverlayHandler.addToOutline(new NCBlockPos(chunkPos.m_45604_(), this.f_58858_.m_123342_(), chunkPos.m_45609_()));
            }
        }
        if (!this.isPumpValid(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_() + 5, chunkPos.m_45609_()), 2)) {
            if (isClientSide) {
                BlockOverlayHandler.addToOutline(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_(), chunkPos.m_45609_()));
            }
            this.pumpsAreValid = false;
        }
        if (!this.isPumpValid(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_() + 5, chunkPos.m_45605_()), 3)) {
            if (isClientSide) {
                BlockOverlayHandler.addToOutline(new NCBlockPos(chunkPos.m_45608_(), this.f_58858_.m_123342_(), chunkPos.m_45605_()));
            }
            this.pumpsAreValid = false;
        }
    }

    public boolean hasCatalyst() {
        return !this.catalystHandler.getStackInSlot(0).m_41619_();
    }

    @Override
    public void processRecipe() {
        if (!this.hasCatalyst()) {
            return;
        }
        super.processRecipe();
    }

    @Override
    protected void updateRecipe() {
        this.gatherOre();
        super.updateRecipe();
    }

    public void gatherOre() {
        if (!this.hasCatalyst()) {
            this.catalyst = ItemStack.f_41583_;
            return;
        }
        this.catalyst = this.catalystHandler.getStackInSlot(0);
        ItemStack ore = ItemStack.f_41583_;
        if (this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty()) {
            this.leacherState = 0;
            return;
        }
        if (this.catalyst.m_41720_().equals(Items.f_42573_)) {
            ore = this.useMapCatalyst();
        }
        if (this.catalyst.m_41720_().equals(NCItems.NC_PARTS.get("research_paper").get())) {
            ore = this.useResearchPaper();
        }
        if (ModUtil.isIeLoaded() && this.catalyst.m_41720_().equals(ItemRadiation.getItemByName("immersiveengineering:coresample"))) {
            ore = this.useIECoreSample();
        }
        this.contentHandler.itemHandler.insertItemInternal(0, ore, false);
    }

    protected ItemStack useIECoreSample() {
        return ItemStack.f_41583_;
    }

    protected ItemStack useResearchPaper() {
        CompoundTag tagData = this.catalyst.m_41784_();
        if (!tagData.m_128441_("pos") || !tagData.m_128441_("vein")) {
            this.leacherState = (byte)3;
            return ItemStack.f_41583_;
        }
        BlockPos mapPos = BlockPos.m_122022_((long)tagData.m_128454_("pos"));
        ChunkPos chunkPos = new ChunkPos(mapPos);
        if (!chunkPos.equals((Object)new ChunkPos(this.m_58899_()))) {
            this.leacherState = (byte)2;
            return ItemStack.f_41583_;
        }
        if (this.m_58904_() == null) {
            return ItemStack.f_41583_;
        }
        return WorldVeinsManager.get(this.m_58904_()).getWorldVeinData((ServerLevel)this.m_58904_()).gatherRandomOre(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    protected ItemStack useMapCatalyst() {
        MapItem cfr_ignored_0 = (MapItem)this.catalyst.m_41720_();
        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)this.catalyst, (Level)this.m_58904_());
        if (mapData == null) {
            return ItemStack.f_41583_;
        }
        if (this.f_58858_.m_123341_() < mapData.f_256718_ - 64 || this.f_58858_.m_123341_() > mapData.f_256718_ + 64 && this.f_58858_.m_123343_() < mapData.f_256789_ - 64 || this.f_58858_.m_123343_() > mapData.f_256789_ + 64) {
            this.leacherState = (byte)2;
            return ItemStack.f_41583_;
        }
        if (this.currentMiningPos == null) {
            if (this.currentMiningTimeout > 200) {
                this.currentMiningTimeout = 0;
                this.currentMiningPos = new NCBlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_());
            } else {
                ++this.currentMiningTimeout;
                return ItemStack.f_41583_;
            }
        }
        if (!this.mineFirstMinableBlock()) {
            this.currentMiningPos = null;
            this.currentMiningTimeout = 0;
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> allMinableOres() {
        if (this.minableOres == null) {
            this.minableOres = new ArrayList<ItemStack>();
            for (Recipe recipe : this.getRecipes()) {
                for (Ingredient ingredient : recipe.getItemIngredients()) {
                    this.minableOres.addAll(Arrays.asList(ingredient.m_43908_()));
                }
            }
        }
        return this.minableOres;
    }

    private List<Recipe> getRecipes() {
        return NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_());
    }

    protected boolean mineFirstMinableBlock() {
        int startY = this.currentMiningPos.m_123342_();
        int startX = new ChunkPos(this.currentMiningPos).m_45604_();
        int startZ = new ChunkPos(this.currentMiningPos).m_45605_();
        NCBlockPos tempMiningPos = new NCBlockPos((Vec3i)this.currentMiningPos);
        for (int y = startY; y > this.m_58904_().m_141937_(); --y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    ItemStack toMine;
                    BlockState toCheck = this.m_58904_().m_8055_((BlockPos)tempMiningPos.y(y).x(x + startX).z(z + startZ));
                    if (!toCheck.m_204336_(Tags.Blocks.ORES) || !this.isMinable(toMine = new ItemStack((ItemLike)toCheck.m_60734_()))) continue;
                    this.currentMiningPos = new BlockPos((Vec3i)tempMiningPos);
                    if (!this.contentHandler.itemHandler.insertItemInternal(0, toMine, true).m_41619_()) continue;
                    this.m_58904_().m_46961_((BlockPos)tempMiningPos.y(y).x(x + startX).z(z + startZ), false);
                    this.contentHandler.itemHandler.insertItemInternal(0, toMine, false);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMinable(ItemStack toMine) {
        for (ItemStack stack : this.allMinableOres()) {
            if (!stack.equals(toMine, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public List<Item> getAllowedCatalysts() {
        ArrayList<Item> items = new ArrayList<Item>(List.of((Item)NCItems.NC_PARTS.get("research_paper").get(), Items.f_42573_));
        if (ModUtil.isIeLoaded()) {
            Item ieCoreSample = ItemRadiation.getItemByName("immersiveengineering:coresample");
            items.add(ieCoreSample);
        }
        return items;
    }

    @Override
    public int toggleSideConfig(int slotId, int direction) {
        if (slotId == 1) {
            return SlotModePair.SlotMode.DISABLED.ordinal();
        }
        this.m_6596_();
        this.saveSideMapFlag = true;
        return this.contentHandler.toggleSideConfig(slotId, direction);
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return Processors.LEACHER;
        }
    }
}

