/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.fission;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionBE;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FissionPortBE
extends FissionBE {
    public static String NAME = "fission_reactor_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte redstoneMode = (byte)2;
    @NBTField
    public BlockPos controllerPos;
    @NBTField
    public boolean isSteamMode = false;

    public FissionPortBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        if (this.multiblock() == null || this.controller() == null) {
            return;
        }
        byte wasSignal = this.analogSignal;
        boolean updated = this.sendOutPower();
        if (this.controllerPos == null) {
            this.controllerPos = this.controller().m_58899_();
            updated = true;
            this.m_6596_();
        }
        if (this.isSteamMode != ((FissionControllerBE)this.controller()).isSteamMode) {
            this.isSteamMode = ((FissionControllerBE)this.controller()).isSteamMode;
            updated = true;
        }
        this.updateAnalogSignal();
        switch (this.redstoneMode) {
            case 5: {
                ((FissionControllerBE)this.controller()).toggleReactor(this.hasRedstoneSignal());
                break;
            }
            case 6: {
                ((FissionControllerBE)this.controller()).adjustModerator(this.analogSignal);
            }
        }
        updated = wasSignal != this.analogSignal || updated;
        Direction dir = this.getFacing();
        if (this.itemHandler() != null) {
            updated = this.itemHandler().pushItems(dir, true, this.f_58858_) || updated;
            boolean bl = updated = this.itemHandler().pullItems(dir, true, this.f_58858_) || updated;
        }
        if (updated) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void updateAnalogSignal() {
        switch (this.redstoneMode) {
            case 1: {
                this.analogSignal = (byte)(((FissionControllerBE)this.controller()).energyStorage.getEnergyStored() * 15 / ((FissionControllerBE)this.controller()).energyStorage.getMaxEnergyStored());
                break;
            }
            case 2: {
                this.analogSignal = (byte)(((FissionControllerBE)this.controller()).heat * 15.0 / ((FissionControllerBE)this.controller()).getMaxHeat());
                break;
            }
            case 3: {
                this.analogSignal = (byte)(((FissionControllerBE)this.controller()).recipeInfo.ticksProcessed * 15.0 / (double)((FissionControllerBE)this.controller()).recipeInfo.ticks);
                break;
            }
            case 4: {
                this.analogSignal = (byte)(this.itemHandler().getStackInSlot(0).m_41613_() * 15 / this.itemHandler().getStackInSlot(0).m_41741_());
                break;
            }
            case 6: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
            }
        }
    }

    protected ItemCapabilityHandler itemHandler() {
        return ((FissionControllerBE)this.controller()).contentHandler.itemHandler;
    }

    protected FluidCapabilityHandler fluidHandler() {
        return ((FissionControllerBE)this.controller()).contentHandler.fluidCapability;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return ((FissionControllerBE)this.controller()).contentHandler.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && ((FissionControllerBE)this.controller()).isSteamMode) {
            return ((FissionControllerBE)this.controller()).getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ENERGY && !((FissionControllerBE)this.controller()).isSteamMode) {
            return ((FissionControllerBE)this.controller()).getEnergy().cast();
        }
        if (ModUtil.isMekanismLoadeed() && this.isSteamMode) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (((FissionControllerBE)this.controller()).contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> ((FissionControllerBE)this.controller()).contentHandler.gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (((FissionControllerBE)this.controller()).contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> ((FissionControllerBE)this.controller()).contentHandler.getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return ((FissionControllerBE)this.controller()).getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected boolean sendOutPower() {
        if (this.multiblock() == null) {
            return false;
        }
        AtomicInteger capacity = new AtomicInteger(((FissionControllerBE)this.controller()).energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_121945_(direction));
                if (be == null || (doContinue = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), ((FissionControllerBE)this.controller()).energyStorage.getMaxEnergyStored()), false);
                        capacity.addAndGet(-received);
                        ((FissionControllerBE)this.controller()).energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    @Override
    public FissionControllerBE<?> controller() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().f_46443_ && this.controllerPos != null) {
            FissionControllerBE controllerBe;
            BlockEntity be = this.m_58904_().m_7702_(this.controllerPos);
            return be instanceof FissionControllerBE ? (controllerBe = (FissionControllerBE)be) : null;
        }
        try {
            FissionControllerBE controllerBe;
            BlockEntity be = this.multiblock().controller().controllerBE();
            return be instanceof FissionControllerBE ? (controllerBe = (FissionControllerBE)be) : null;
        }
        catch (NullPointerException e) {
            if (this.controllerPos != null) {
                FissionControllerBE controllerBe;
                BlockEntity be = this.m_58904_().m_7702_(this.controllerPos);
                return be instanceof FissionControllerBE ? (controllerBe = (FissionControllerBE)be) : null;
            }
            return null;
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        this.saveTagData(infoTag);
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return ((FissionControllerBE)this.controller()).energyStorage.getEnergyStored();
    }

    public double getDepletionProgress() {
        if (this.controller() == null) {
            return 0.0;
        }
        return ((FissionControllerBE)this.controller()).getDepletionProgress();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return ((FissionControllerBE)this.controller()).energyStorage.getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return ((FissionControllerBE)this.controller()).energyPerTick;
    }

    public void toggleRedstoneMode() {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode > 6) {
            this.redstoneMode = 1;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return ((FissionControllerBE)this.controller()).getFluidTank(i);
    }

    public boolean getMode() {
        if (this.controller() == null) {
            return false;
        }
        return ((FissionControllerBE)this.controller()).isSteamMode;
    }

    public int getSteamPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return ((FissionControllerBE)this.controller()).steamPerTick;
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte HEAT = 2;
        public static final byte PROGRESS = 3;
        public static final byte ITEMS = 4;
        public static final byte SWITCH = 5;
        public static final byte MODERATOR = 6;
    }
}

