/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.fission;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionBE;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.multiblock.fission.HeatSinkDef;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FissionHeatSinkBE
extends FissionBE {
    public static String NAME = "fission_heat_sink";
    public HeatSinkDef def;
    public boolean isValid = false;
    public double heat;

    public FissionHeatSinkBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public FissionHeatSinkBE(BlockPos pPos, BlockState pBlockState, String name) {
        super(pPos, pBlockState, name);
    }

    public boolean isValid(boolean forceCheck) {
        if (forceCheck) {
            this.isValid = this.def().getValidator().isValid(this);
            this.refreshCacheFlag = true;
        }
        return this.isValid() && this.isAttachedToFuelCell();
    }

    private HeatSinkDef def() {
        if (this.def == null) {
            this.setHeatSinkDef(FissionBlocks.heatsinks().get(this.m_58900_().m_60734_().m_5456_().toString().replace("_heat_sink", "")));
        }
        return this.def;
    }

    @Override
    public boolean isAttachedToFuelCell() {
        if (this.def().mustdDirectlyTouchFuelCell()) {
            return this.isDirectlyAttachedToFuelCell(this.f_58858_);
        }
        return super.isAttachedToFuelCell();
    }

    private boolean isValid() {
        return this.isValid;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        if (this.multiblock() != null && (this.attachedToFuelCell || this.refreshCacheFlag)) {
            for (Direction dir : Direction.values()) {
                BlockEntity be = this.m_58904_().m_7702_(this.m_58899_().m_121945_(dir));
                if (!(be instanceof FissionBE)) continue;
                ((FissionBE)be).attachedToFuelCell = true;
            }
            this.isValid(true);
            this.refreshCacheFlag = false;
        }
    }

    public void setHeatSinkDef(HeatSinkDef def) {
        this.def = def;
        this.heat = def.getHeat();
        this.hasToTouchFuelCell = def.getValidator().hasToTouchFuelCell();
    }

    public double getHeat() {
        if (this.heat == 0.0) {
            this.heat = this.def.getHeat();
        }
        return this.heat;
    }

    @Override
    public boolean isDirectlyAttachedToFuelCell(BlockPos ignoredPos) {
        if (this.def == null) {
            return super.isDirectlyAttachedToFuelCell(ignoredPos);
        }
        if (this.def.getValidator().hasToTouchFuelCell()) {
            return super.isDirectlyAttachedToFuelCell(ignoredPos);
        }
        return this.isAttachedToFuelCell();
    }
}

